/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.identity;

import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.restcomm.sbc.bo.Account;
import org.restcomm.sbc.dao.AccountsDao;
import org.restcomm.sbc.identity.AccountKey;

public class UserIdentityContext {
    final AccountKey accountKey;
    final Account effectiveAccount;
    Set<String> effectiveAccountRoles;

    public UserIdentityContext(HttpServletRequest request, AccountsDao accountsDao) {
        this.accountKey = this.extractAccountKey(request, accountsDao);
        this.effectiveAccount = this.accountKey != null ? (this.accountKey.isVerified() ? this.accountKey.getAccount() : null) : null;
        if (this.effectiveAccount != null) {
            this.effectiveAccountRoles = this.extractAccountRoles(this.effectiveAccount);
        }
    }

    private Set<String> extractAccountRoles(Account account) {
        if (account == null) {
            return null;
        }
        HashSet<String> roles = new HashSet<String>();
        if (!StringUtils.isEmpty((String)account.getRole())) {
            roles.add(account.getRole());
        }
        return roles;
    }

    private AccountKey extractAccountKey(HttpServletRequest request, AccountsDao dao) {
        String base64Credentials;
        String credentials;
        String[] values;
        String[] parts;
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && (parts = authHeader.split(" ")).length >= 2 && parts[0].equals("Basic") && (values = (credentials = new String(Base64.decodeBase64((String)(base64Credentials = parts[1].trim())), Charset.forName("UTF-8"))).split(":", 2)).length >= 2) {
            AccountKey accountKey = new AccountKey(values[0], values[1], dao);
            return accountKey;
        }
        return null;
    }

    public AccountKey getAccountKey() {
        return this.accountKey;
    }

    public Account getEffectiveAccount() {
        return this.effectiveAccount;
    }

    public Set<String> getEffectiveAccountRoles() {
        return this.effectiveAccountRoles;
    }
}

