/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.managers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.restcomm.sbc.bo.BanList;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.bo.Statistics;
import org.restcomm.sbc.bo.shiro.ShiroResources;
import org.restcomm.sbc.call.Call;
import org.restcomm.sbc.call.CallManager;
import org.restcomm.sbc.dao.BlackListDao;
import org.restcomm.sbc.dao.CallDetailRecordsDao;
import org.restcomm.sbc.dao.DaoManager;
import org.restcomm.sbc.dao.StatisticsDao;
import org.restcomm.sbc.dao.WhiteListDao;
import org.restcomm.sbc.managers.Monitor;
import org.restcomm.sbc.managers.ScriptDelegationService;
import org.restcomm.sbc.managers.ThreatManager;
import org.restcomm.sbc.managers.jmx.JMXProvider;
import org.restcomm.sbc.managers.jmx.JMXProviderFactory;
import org.restcomm.sbc.notification.AlertListener;
import org.restcomm.sbc.notification.NotificationListener;
import org.restcomm.sbc.notification.SuspectActivityElectable;
import org.restcomm.sbc.notification.impl.SuspectActivityCache;
import org.restcomm.sbc.threat.Threat;

/*
 * Exception performing whole class analysis ignored.
 */
public class Monitor {
    private static Monitor monitor;
    private static transient Logger LOG;
    private EventListenerList listenerList = new EventListenerList();
    private final int CACHE_MAX_ITEMS = 1024;
    private final int CACHE_ITEM_TTL = 60;
    private final long LOOP_INTERVAL = 60L;
    private SuspectActivityCache<String, SuspectActivityElectable> cache;
    private DaoManager daoManager;
    private JMXProvider jmxManager;
    private CallManager callManager;
    private ThreatManager threatManager = ThreatManager.getThreatManager();
    private ScheduledExecutorService scheduledExecutorService;

    private Monitor() {
        this.cache = SuspectActivityCache.getCache((int)1024, (int)60);
        this.daoManager = (DaoManager)ShiroResources.getInstance().get(DaoManager.class);
        try {
            this.jmxManager = JMXProviderFactory.getJMXProvider();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.error((Object)"JMX Error", (Throwable)e);
        }
        this.callManager = CallManager.getCallManager();
        Runtime.getRuntime().addShutdownHook((Thread)new ProcessorHook(this));
    }

    public static Monitor getMonitor() {
        if (monitor == null) {
            monitor = new Monitor();
        }
        return monitor;
    }

    public void addNotificationListener(NotificationListener listener) {
        this.listenerList.add(NotificationListener.class, listener);
    }

    public void addAlertListener(AlertListener listener) {
        this.listenerList.add(AlertListener.class, listener);
    }

    protected void fireNotificationEvent(Object source, String message) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != NotificationListener.class) continue;
            ((NotificationListener)listeners[i + 1]).onActionRequired(source, message);
        }
    }

    protected void fireAlertEvent(SuspectActivityElectable sae) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != AlertListener.class) continue;
            ((AlertListener)listeners[i + 1]).onActionRequired(sae);
        }
    }

    private synchronized void applyThreatsToBlackList() {
        BlackListDao blackListDao = this.daoManager.getBlackListDao();
        for (Threat threat : this.threatManager.getThreats()) {
            BanList entry = new BanList(DateTime.now(), DateTime.now().plusHours(24), threat.getHost(), Sid.generate((Sid.Type)Sid.Type.ACCOUNT), BanList.Reason.THREAT, Action.APPLY);
            blackListDao.addBanList(entry);
        }
    }

    private synchronized void applyBanningRules() {
        BlackListDao blackListDao = this.daoManager.getBlackListDao();
        List entries = blackListDao.getBanLists();
        int status = 0;
        for (BanList entry : entries) {
            switch (1.$SwitchMap$org$restcomm$sbc$managers$Monitor$Action[entry.getAction().ordinal()]) {
                case 1: {
                    status = ScriptDelegationService.runBanScript((String)entry.getIpAddress());
                    if (status == 0) {
                        entry = entry.setAction(Action.NONE);
                        blackListDao.updateBanList(entry);
                        break;
                    }
                    LOG.error((Object)"Cannot execute BlackList adding!, operation rollback");
                    this.fireNotificationEvent((Object)entry, "Cannot execute BlackList adding!, operation rollback");
                    break;
                }
                case 2: {
                    status = ScriptDelegationService.runUnBanScript((String)entry.getIpAddress());
                    if (status == 0) {
                        blackListDao.removeBanList(entry);
                        break;
                    }
                    LOG.error((Object)"Cannot execute BlackList removing!, operation rollback");
                    this.fireNotificationEvent((Object)entry, "Cannot execute BlackList removing!, operation rollback");
                    break;
                }
            }
        }
        WhiteListDao whiteListDao = this.daoManager.getWhiteListDao();
        entries = whiteListDao.getBanLists();
        status = 0;
        for (BanList entry : entries) {
            switch (1.$SwitchMap$org$restcomm$sbc$managers$Monitor$Action[entry.getAction().ordinal()]) {
                case 1: {
                    status = ScriptDelegationService.runAllowScript((String)entry.getIpAddress());
                    if (status == 0) {
                        entry = entry.setAction(Action.NONE);
                        whiteListDao.updateBanList(entry);
                        break;
                    }
                    LOG.error((Object)"Cannot execute WhiteList adding!, operation rollback");
                    this.fireNotificationEvent((Object)entry, "Cannot execute WhiteList adding!, operation rollback");
                    break;
                }
                case 2: {
                    status = ScriptDelegationService.runDisallowScript((String)entry.getIpAddress());
                    if (status == 0) {
                        whiteListDao.removeBanList(entry);
                        break;
                    }
                    LOG.error((Object)"Cannot execute WhiteList removing!, operation rollback");
                    this.fireNotificationEvent((Object)entry, "Cannot execute WhiteList adding!, operation rollback");
                    break;
                }
            }
        }
    }

    private synchronized void synchronizeCDR() {
        CallDetailRecordsDao cdrDao = this.daoManager.getCallDetailRecordsDao();
        Collection entries = this.callManager.getCalls();
        ArrayList<String> removed = new ArrayList<String>();
        for (Call call : entries) {
            switch (1.$SwitchMap$org$restcomm$sbc$call$Call$Status[call.getStatus().ordinal()]) {
                case 1: 
                case 2: {
                    cdrDao.addCallDetailRecord(call.getCdr());
                    removed.add(call.getSessionId());
                    break;
                }
            }
        }
        for (String id : removed) {
            this.callManager.remove(id);
        }
    }

    private void writeStats() {
        StatisticsDao statsDao = this.daoManager.getStatisticsDao();
        Statistics record = new Statistics(Sid.generate((Sid.Type)Sid.Type.RANDOM), this.jmxManager.getMemoryUsage(), this.jmxManager.getCPULoadAverage(), this.getLiveCallCount(), this.getCallRatePerSecond(), this.getCallRejectedCount(), 0, DateTime.now());
        statsDao.addRecord(record);
    }

    public int getLiveCallCount() {
        return this.callManager.getCalls().size();
    }

    public double getCallRatePerSecond() {
        return 0.0;
    }

    public int getCallRejectedCount() {
        return 0;
    }

    public void start() {
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.scheduledExecutorService.scheduleWithFixedDelay((Runnable)new Task(this), 60L, 60L, TimeUnit.SECONDS);
    }

    public void stop() throws IOException {
        this.scheduledExecutorService.shutdown();
        this.jmxManager.close();
    }

    public static void main(String[] argv) {
        Monitor monitor = Monitor.getMonitor();
        monitor.start();
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    static /* synthetic */ void access$100(Monitor x0) {
        x0.synchronizeCDR();
    }

    static /* synthetic */ void access$200(Monitor x0) {
        x0.applyThreatsToBlackList();
    }

    static /* synthetic */ void access$300(Monitor x0) {
        x0.applyBanningRules();
    }

    static /* synthetic */ void access$400(Monitor x0) {
        x0.writeStats();
    }

    static {
        LOG = Logger.getLogger(Monitor.class);
    }
}

