/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import org.apache.log4j.Logger;
import org.mobicents.media.io.ice.IceAuthenticator;
import org.mobicents.media.io.ice.IceHandler;
import org.mobicents.media.io.ice.events.IceEventListener;
import org.mobicents.media.io.ice.events.SelectedCandidatesEvent;
import org.mobicents.media.server.impl.rtp.RtpListener;
import org.mobicents.media.server.impl.srtp.DtlsListener;
import org.mobicents.media.server.io.network.channel.MultiplexedChannel;
import org.mobicents.media.server.io.network.channel.PacketHandler;
import org.mobicents.media.server.io.sdp.format.RTPFormats;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.utils.Text;
import org.restcomm.sbc.media.PortManager;
import org.restcomm.sbc.media.RtcpHandler;
import org.restcomm.sbc.media.RtpChannel;
import org.restcomm.sbc.media.RtpHandler;
import org.restcomm.sbc.media.dtls.DtlsHandler;

public class RtpChannel
extends MultiplexedChannel
implements DtlsListener,
IceEventListener,
Channel {
    private static Logger logger = Logger.getLogger(RtpChannel.class);
    private static final int PORT_ANY = -1;
    private final PortManager portManager = PortManager.getPortManager();
    private static final String LOCALHOST = "127.0.0.1";
    private String bindAddress = "127.0.0.1";
    private String localBindAddress = "127.0.0.1";
    private boolean bound = false;
    private SocketAddress remotePeer;
    private RtpHandler rtpHandler = new RtpHandler();
    private DtlsHandler dtlsHandler;
    private IceHandler stunHandler;
    private RtcpHandler rtcpHandler = new RtcpHandler();
    private boolean ice;
    private boolean secure = false;
    private boolean rtcpMux = false;
    private RtpListener rtpListener;
    private String originalHost;
    private int originalPort;

    private RtpChannel() {
        this.dtlsHandler = new DtlsHandler();
        this.stunHandler = new IceHandler(1, (IceEventListener)this);
    }

    public RtpChannel(String originalHost, int originalPort) {
        this();
        this.originalHost = originalHost;
        this.originalPort = originalPort;
    }

    public boolean canHandleRTCP(byte[] packet) {
        return this.rtcpHandler.canHandle(packet);
    }

    public boolean canHandleRTP(byte[] packet) {
        return this.rtpHandler.canHandle(packet);
    }

    public boolean canHandleDTLS(byte[] packet) {
        return this.dtlsHandler.canHandle(packet);
    }

    public boolean canHandleICE(byte[] packet) {
        return this.stunHandler.canHandle(packet);
    }

    public void setRtpListener(RtpListener listener) {
        this.rtpListener = listener;
    }

    public RTPFormats getFormatMap() {
        return this.rtpHandler.getFormatMap();
    }

    public void updateMode(ConnectionMode connectionMode) {
        switch (1.$SwitchMap$org$mobicents$media$server$spi$ConnectionMode[connectionMode.ordinal()]) {
            case 1: {
                this.rtpHandler.setReceivable(false);
                this.rtpHandler.setLoopable(false);
                break;
            }
            case 2: {
                this.rtpHandler.setReceivable(true);
                this.rtpHandler.setLoopable(false);
                break;
            }
            case 3: {
                this.rtpHandler.setReceivable(false);
                this.rtpHandler.setLoopable(false);
                break;
            }
            case 4: 
            case 5: {
                this.rtpHandler.setReceivable(true);
                this.rtpHandler.setLoopable(false);
                break;
            }
            case 6: {
                this.rtpHandler.setReceivable(false);
                this.rtpHandler.setLoopable(true);
                break;
            }
        }
    }

    private void onBinding() {
        this.secure = true;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("onBinding() rtcpMux " + this.rtcpMux));
            logger.trace((Object)("onBinding() secure  " + this.secure));
            logger.trace((Object)("onBinding() secure  " + this.secure));
        }
        if (this.rtcpMux) {
            this.rtcpHandler.setChannel(this.dataChannel);
        }
        this.dtlsHandler.addListener((DtlsListener)this);
        this.handlers.addHandler((PacketHandler)this.stunHandler);
    }

    public void bindLocal(DatagramChannel channel, int port) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("bindLocal() RtpChannel " + channel.getLocalAddress() + ":" + port));
        }
        if (port == -1) {
            port = this.portManager.getNextAvailablePort();
        }
        IOException ex = null;
        for (int q = 0; q < 100; ++q) {
            try {
                channel.bind(new InetSocketAddress(this.localBindAddress, port));
                ex = null;
                break;
            }
            catch (IOException e) {
                ex = e;
                logger.info((Object)("Failed trying to bind " + this.localBindAddress + ":" + port));
                port = this.portManager.getNextAvailablePort();
                continue;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public void bind(DatagramChannel channel, int port) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("bind(channel, port) RtpChannel " + channel.getLocalAddress() + ":" + port));
        }
        if (port == -1) {
            port = this.portManager.getNextAvailablePort();
        }
        IOException ex = null;
        for (int q = 0; q < 100; ++q) {
            try {
                channel.bind(new InetSocketAddress(this.bindAddress, port));
                ex = null;
                break;
            }
            catch (IOException e) {
                ex = e;
                logger.info((Object)("Failed trying to bind " + this.bindAddress + ":" + port));
                port = this.portManager.getNextAvailablePort();
                continue;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public void bind(DatagramChannel channel) throws IOException, SocketException {
        this.dataChannel = channel;
        this.onBinding();
        if (!channel.socket().isBound()) {
            this.bind(channel, -1);
        }
        this.bound = true;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("bind(channel) RtpChannel " + channel.getLocalAddress()));
            logger.trace((Object)("bind(channel) connected  " + this.isConnected()));
            logger.trace((Object)("bind(channel) secure     " + this.secure));
            logger.trace((Object)("bind(channel) available  " + this.isAvailable()));
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    public boolean isConnected() {
        return this.dataChannel != null && this.dataChannel.isConnected();
    }

    public boolean isAvailable() {
        boolean available;
        boolean bl = available = this.dataChannel != null && this.dataChannel.isConnected();
        if (this.secure) {
            available = available && this.dtlsHandler.isHandshakeComplete();
        }
        return available;
    }

    public void setRemotePeer(SocketAddress address) {
        this.remotePeer = address;
        if (this.dataChannel != null) {
            if (this.dataChannel.isConnected()) {
                try {
                    this.disconnect();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
            try {
                this.dataChannel.connect(address);
            }
            catch (IOException e) {
                logger.info((Object)"Can not connect to remote address , please check that you are not using local address - 127.0.0.X to connect to remote");
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("RemotePeer  " + this.remotePeer.toString()));
            logger.trace((Object)("Datachannel " + this.dataChannel));
        }
    }

    public String getExternalAddress() {
        return this.originalHost;
    }

    public boolean hasExternalAddress() {
        return this.notEmpty(this.getExternalAddress());
    }

    private boolean notEmpty(String text) {
        return text != null && !text.isEmpty();
    }

    public void enableIce(IceAuthenticator authenticator) {
        if (!this.ice) {
            this.ice = true;
            this.stunHandler.setAuthenticator(authenticator);
            this.handlers.addHandler((PacketHandler)this.stunHandler);
        }
    }

    public void disableIce() {
        if (this.ice) {
            this.ice = false;
            this.handlers.removeHandler((PacketHandler)this.stunHandler);
        }
    }

    public void enableSRTP(String hashFunction, String remotePeerFingerprint) {
        if (!this.secure) {
            this.secure = true;
            this.dtlsHandler.setRemoteFingerprint(hashFunction, remotePeerFingerprint);
            this.dtlsHandler.addListener((DtlsListener)this);
            this.rtpHandler.enableSrtp(this.dtlsHandler);
            if (this.rtcpMux) {
                this.rtcpHandler.enableSRTCP(this.dtlsHandler);
            }
            this.dtlsHandler.setChannel(this.dataChannel);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enableSRTP() rtpMux   " + this.rtcpMux));
            logger.trace((Object)("enableSRTP connected  " + this.isConnected()));
            logger.trace((Object)("enableSRTP secure     " + this.secure));
            logger.trace((Object)("enableSRTP available  " + this.isAvailable()));
        }
    }

    public void enableSRTP() {
        if (!this.secure) {
            this.secure = true;
            this.rtpHandler.enableSrtp(this.dtlsHandler);
            if (this.rtcpMux) {
                this.rtcpHandler.enableSRTCP(this.dtlsHandler);
            }
            this.dtlsHandler.setChannel(this.dataChannel);
            this.dtlsHandler.addListener((DtlsListener)this);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enableSRTP() rtpMux     " + this.rtcpMux));
            logger.trace((Object)("enableSRTP() connected  " + this.isConnected()));
            logger.trace((Object)("enableSRTP() secure     " + this.secure));
            logger.trace((Object)("enableSRTP() available  " + this.isAvailable()));
        }
    }

    public void setFormatMap(RTPFormats rtpFormats) {
        this.flush();
        this.rtpHandler.setFormatMap(rtpFormats);
    }

    public void setRemoteFingerprint(String hashFunction, String fingerprint) {
        this.dtlsHandler.setRemoteFingerprint(hashFunction, fingerprint);
    }

    public void disableSRTP() {
        if (this.secure) {
            this.secure = false;
            this.dtlsHandler.setRemoteFingerprint("", "");
            this.dtlsHandler.resetLocalFingerprint();
            this.rtpHandler.disableSrtp();
            if (this.rtcpMux) {
                this.rtcpHandler.disableSRTCP();
            }
        }
    }

    public Text getWebRtcLocalFingerprint() {
        if (this.secure) {
            return new Text(this.dtlsHandler.getLocalFingerprint());
        }
        return new Text();
    }

    @Override
    public void close() {
        super.close();
        this.reset();
        this.bound = false;
    }

    private void reset() {
        this.rtpHandler.reset();
        if (this.rtcpMux) {
            this.rtcpHandler.reset();
            this.rtcpMux = false;
        }
        if (this.ice) {
            this.disableIce();
            this.stunHandler.reset();
        }
        if (this.secure) {
            this.disableSRTP();
            this.dtlsHandler.reset();
        }
    }

    public void onDtlsHandshakeComplete() {
        logger.info((Object)"DTLS handshake completed for RTP candidate.");
    }

    public void onDtlsHandshakeFailed(Throwable e) {
        if (this.rtpListener != null) {
            this.rtpListener.onRtpFailure(e);
        }
    }

    public void onSelectedCandidates(SelectedCandidatesEvent event) {
        logger.info((Object)"onSelectedCandidates(), handshake must begin");
        if (this.secure) {
            this.dtlsHandler.handshake();
        }
    }

    public void setChannel(DatagramChannel rtpChannel) {
        this.dataChannel = rtpChannel;
    }

    public void setRtcpMux(boolean rtcpMux) {
        this.rtcpMux = rtcpMux;
    }
}

