/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.text.ParseException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.NotThreadSafe;
import org.restcomm.sbc.bo.Account;
import org.restcomm.sbc.bo.CallDetailRecord;
import org.restcomm.sbc.bo.CallDetailRecordFilter;
import org.restcomm.sbc.bo.CallDetailRecordList;
import org.restcomm.sbc.bo.RestCommResponse;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.configuration.RestcommConfiguration;
import org.restcomm.sbc.dao.AccountsDao;
import org.restcomm.sbc.dao.CallDetailRecordsDao;
import org.restcomm.sbc.dao.DaoManager;
import org.restcomm.sbc.rest.SecuredEndpoint;
import org.restcomm.sbc.rest.converter.CallDetailRecordConverter;
import org.restcomm.sbc.rest.converter.CallDetailRecordListConverter;
import org.restcomm.sbc.rest.converter.RestCommResponseConverter;

@NotThreadSafe
public abstract class CallsEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected DaoManager daos;
    protected Gson gson;
    protected GsonBuilder builder;
    protected XStream xstream;
    protected CallDetailRecordListConverter listConverter;
    protected AccountsDao accountsDao;
    protected String instanceId;
    protected boolean normalizePhoneNumbers;

    @PostConstruct
    public void init() {
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        this.daos = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.accountsDao = this.daos.getAccountsDao();
        super.init(this.configuration);
        CallDetailRecordConverter converter = new CallDetailRecordConverter(this.configuration);
        this.listConverter = new CallDetailRecordListConverter(this.configuration);
        this.builder = new GsonBuilder();
        this.builder.registerTypeAdapter(CallDetailRecord.class, (Object)converter);
        this.builder.registerTypeAdapter(CallDetailRecordList.class, (Object)this.listConverter);
        this.builder.setPrettyPrinting();
        this.gson = this.builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        this.xstream.registerConverter((Converter)this.listConverter);
        this.instanceId = RestcommConfiguration.getInstance().getMain().getInstanceId();
        this.normalizePhoneNumbers = this.configuration.getBoolean("normalize-numbers-for-outbound-calls");
    }

    protected Response getCall(String sid, MediaType responseType) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Read:Calls");
        CallDetailRecordsDao dao = this.daos.getCallDetailRecordsDao();
        CallDetailRecord cdr = dao.getCallDetailRecord(new Sid(sid));
        if (cdr == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(account, account.getSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)cdr);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)cdr), (String)"application/json").build();
        }
        return null;
    }

    protected Response getCalls(UriInfo info, MediaType responseType) {
        CallDetailRecordFilter filter;
        CallDetailRecordFilter filterForTotal;
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Read:Calls");
        boolean localInstanceOnly = true;
        try {
            String localOnly = (String)info.getQueryParameters().getFirst((Object)"localOnly");
            if (localOnly != null && localOnly.equalsIgnoreCase("false")) {
                localInstanceOnly = false;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String pageSize = (String)info.getQueryParameters().getFirst((Object)"PageSize");
        String page = (String)info.getQueryParameters().getFirst((Object)"Page");
        String recipient = (String)info.getQueryParameters().getFirst((Object)"To");
        String sender = (String)info.getQueryParameters().getFirst((Object)"From");
        String status = (String)info.getQueryParameters().getFirst((Object)"Status");
        String startTime = (String)info.getQueryParameters().getFirst((Object)"StartTime");
        String endTime = (String)info.getQueryParameters().getFirst((Object)"EndTime");
        String parentCallSid = (String)info.getQueryParameters().getFirst((Object)"ParentCallSid");
        String conferenceSid = (String)info.getQueryParameters().getFirst((Object)"ConferenceSid");
        if (pageSize == null) {
            pageSize = "50";
        }
        if (page == null) {
            page = "0";
        }
        int limit = Integer.parseInt(pageSize);
        int offset = page == "0" ? 0 : (Integer.parseInt(page) - 1) * Integer.parseInt(pageSize) + Integer.parseInt(pageSize);
        CallDetailRecordsDao dao = this.daos.getCallDetailRecordsDao();
        try {
            filterForTotal = localInstanceOnly ? new CallDetailRecordFilter(recipient, sender, status, startTime, endTime, parentCallSid, conferenceSid, null, null) : new CallDetailRecordFilter(recipient, sender, status, startTime, endTime, parentCallSid, conferenceSid, null, null, this.instanceId);
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        int total = dao.getTotalCallDetailRecords(filterForTotal);
        if (Integer.parseInt(page) > total / limit) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            filter = localInstanceOnly ? new CallDetailRecordFilter(recipient, sender, status, startTime, endTime, parentCallSid, conferenceSid, Integer.valueOf(limit), Integer.valueOf(offset)) : new CallDetailRecordFilter(recipient, sender, status, startTime, endTime, parentCallSid, conferenceSid, Integer.valueOf(limit), Integer.valueOf(offset), this.instanceId);
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        List cdrs = dao.getCallDetailRecords(filter);
        this.listConverter.setCount(Integer.valueOf(total));
        this.listConverter.setPage(Integer.valueOf(Integer.parseInt(page)));
        this.listConverter.setPageSize(Integer.valueOf(Integer.parseInt(pageSize)));
        this.listConverter.setPathUri(info.getRequestUri().getPath());
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new CallDetailRecordList(cdrs));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)new CallDetailRecordList(cdrs)), (String)"application/json").build();
        }
        return null;
    }
}

