/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.bo;

import java.net.InetSocketAddress;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.managers.NetworkManager;

public class Connector {
    private Sid sid;
    private Sid accountSid;
    private int port;
    private State state;
    private Transport transport;
    private String point;
    private InetSocketAddress outboundInterface;

    public Connector(Sid sid, Sid accountSid, int port, Transport transport, String point, State state) {
        this.sid = sid;
        this.port = port;
        this.state = state;
        this.transport = transport;
        this.point = point;
        this.accountSid = accountSid;
        this.outboundInterface = new InetSocketAddress(NetworkManager.getIpAddress(point), port);
    }

    public Connector(int port, Transport transport, String point, State state) {
        this.port = port;
        this.state = state;
        this.transport = transport;
        this.point = point;
        this.outboundInterface = new InetSocketAddress(NetworkManager.getIpAddress(point), port);
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getPort() {
        return this.port;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public State getState() {
        return this.state;
    }

    public String getPoint() {
        return this.point;
    }

    public String getHost() {
        return NetworkManager.getIpAddress(this.point);
    }

    public Sid getAccountSid() {
        return this.accountSid;
    }

    public Sid getSid() {
        return this.sid;
    }

    public Connector setPort(int port) {
        return new Connector(this.sid, this.accountSid, port, this.transport, this.point, this.state);
    }

    public Connector setTransport(Transport transPort) {
        return new Connector(this.sid, this.accountSid, this.port, this.transport, this.point, this.state);
    }

    public Connector setState(State state) {
        return new Connector(this.sid, this.accountSid, this.port, this.transport, this.point, state);
    }

    public Connector setPoint(String point) {
        return new Connector(this.sid, this.accountSid, this.port, this.transport, point, this.state);
    }

    public Connector setAccountSid(Sid accountSid) {
        return new Connector(this.sid, accountSid, this.port, this.transport, this.point, this.state);
    }

    public String toPrint() {
        return "[" + NetworkManager.getIpAddress(this.point) + ":" + (Object)((Object)this.transport) + ":" + this.port + "] " + this.point + "/" + this.outboundInterface.toString() + ":" + (Object)((Object)this.state);
    }

    public InetSocketAddress getOutboundInterface() {
        return this.outboundInterface;
    }

    public Address buildAddress() throws ServletParseException {
        return ConfigurationCache.getSipFactory().createAddress("sip:" + NetworkManager.getIpAddress(this.point) + ":" + this.port + ";transport=" + this.transport.name().toLowerCase());
    }

    public static final class Builder {
        private Sid sid;
        private Sid accountSid;
        private int port;
        private State state;
        private Transport transport;
        private String point;

        private Builder() {
        }

        public Connector build() {
            return new Connector(this.sid, this.accountSid, this.port, this.transport, this.point, this.state);
        }

        public void setTransport(Transport transport) {
            this.transport = transport;
        }

        public void setState(State state) {
            this.state = state;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setPoint(String point) {
            this.point = point;
        }

        public void setAccountSid(Sid accountSid) {
            this.accountSid = accountSid;
        }

        public void setSid(Sid sid) {
            this.sid = sid;
        }
    }

    public static enum State {
        UP("UP"),
        DOWN("DOWN");

        private final String text;

        private State(String text) {
            this.text = text;
        }

        public static State getValueOf(String text) {
            State[] values;
            for (State value : values = State.values()) {
                if (!value.toString().equals(text)) continue;
                return value;
            }
            throw new IllegalArgumentException(text + " is not a valid state.");
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum Transport {
        UDP("UDP"),
        TCP("TCP"),
        SCTP("SCTP"),
        TLS("TLS"),
        WS("WS"),
        WSS("WSS");

        private final String text;

        private Transport(String text) {
            this.text = text;
        }

        public static Transport getValueOf(String text) {
            Transport[] values;
            for (Transport value : values = Transport.values()) {
                if (!value.toString().equals(text)) continue;
                return value;
            }
            throw new IllegalArgumentException(text + " is not a valid transport.");
        }

        public String toString() {
            return this.text;
        }
    }
}

