/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.dao.mybatis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.restcomm.sbc.bo.Route;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.dao.DaoUtils;
import org.restcomm.sbc.dao.RoutesDao;

@ThreadSafe
public final class MybatisRoutesDao
implements RoutesDao {
    private static final String namespace = "org.restcomm.sbc.dao.RoutesDao.";
    private final SqlSessionFactory sessions;

    public MybatisRoutesDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRoute(Route entry) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.restcomm.sbc.dao.RoutesDao.addEntry", this.toMap(entry));
            session.commit();
        }
    }

    @Override
    public Route getRoute(Sid sid) {
        Route entry = null;
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("sid", sid.toString());
        entry = this.getRoutingPolicy("org.restcomm.sbc.dao.RoutesDao.getEntry", parms);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Route getRoutingPolicy(String selector, Object parameters) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne(selector, parameters);
            if (result != null) {
                Route route = this.toRoutingPolicy(result);
                return route;
            }
            Route route = null;
            return route;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Route> getRoutes() {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.restcomm.sbc.dao.RoutesDao.getEntries");
            ArrayList<Route> entrys = new ArrayList<Route>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    entrys.add(this.toRoutingPolicy(result));
                }
            }
            ArrayList<Route> arrayList = entrys;
            return arrayList;
        }
    }

    @Override
    public void removeRoute(Sid sid) {
        this.removeRoutingPolicy("org.restcomm.sbc.dao.RoutesDao.removeEntry", sid.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRoutingPolicy(String selector, Object parameters) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, parameters);
            session.commit();
        }
    }

    private Route toRoutingPolicy(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        Sid sourceConnector = DaoUtils.readSid(map.get("source_connector_sid"));
        Sid targetConnector = DaoUtils.readSid(map.get("target_connector_sid"));
        Sid entrySid = DaoUtils.readSid(map.get("account_sid"));
        return new Route(sid, entrySid, sourceConnector, targetConnector);
    }

    private Map<String, Object> toMap(Route entry) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(entry.getSid()));
        map.put("source_connector_sid", DaoUtils.writeSid(entry.getSourceConnector()));
        map.put("target_connector_sid", DaoUtils.writeSid(entry.getTargetConnector()));
        map.put("account_sid", DaoUtils.writeSid(entry.getAccountSid()));
        return map;
    }
}

