/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.identity.shiro;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleRole;
import org.apache.shiro.authz.permission.WildcardPermission;

public class RestcommRoles {
    private Map<String, SimpleRole> roles = new HashMap<String, SimpleRole>();
    private static transient Logger LOG = Logger.getLogger(RestcommRoles.class);

    public RestcommRoles(Configuration configuration) {
        this.loadSecurityRoles(configuration);
    }

    public SimpleRole getRole(String role) {
        return this.roles.get(role);
    }

    private void loadSecurityRoles(Configuration configuration) {
        List roleNames = configuration.getList("role[@name]");
        int numberOfRoles = roleNames.size();
        if (numberOfRoles > 0) {
            for (int roleIndex = 0; roleIndex < numberOfRoles; ++roleIndex) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("role(").append(roleIndex).append(")").toString();
                String prefix = buffer.toString();
                String name = configuration.getString(prefix + "[@name]");
                List permissions = configuration.getList(prefix + ".permission");
                if (name == null || permissions.size() <= 0) continue;
                SimpleRole role = new SimpleRole(name);
                for (String permissionString : permissions) {
                    LOG.info((Object)("loading permission " + permissionString + " into " + name + " role"));
                    WildcardPermission permission = new WildcardPermission(permissionString);
                    role.add((Permission)permission);
                }
                this.roles.put(name, role);
            }
        }
    }

    public String toString() {
        if (this.roles == null || this.roles.size() == 0) {
            return "no roles defined";
        }
        StringBuffer buffer = new StringBuffer();
        for (String role : this.roles.keySet()) {
            buffer.append(role);
            SimpleRole simpleRole = this.roles.get(role);
            Set permissions = simpleRole.getPermissions();
            buffer.append("[");
            for (Permission permission : permissions) {
                buffer.append(permission.toString());
                buffer.append(",");
            }
            buffer.append("]");
        }
        return buffer.toString();
    }
}

