/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.restcomm.sbc.bo.Connector;
import org.restcomm.sbc.bo.NetworkPoint;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.managers.NetworkManager;
import org.restcomm.sbc.rest.converter.AbstractConverter;

@ThreadSafe
public final class ConnectorConverter
extends AbstractConverter
implements JsonSerializer<Connector> {
    public ConnectorConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return Connector.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Connector connector = (Connector)object;
        writer.startNode("Connector");
        NetworkPoint point = NetworkManager.getNetworkPoint(connector.getPoint());
        if (point != null) {
            this.writeID(point.getAddress().getHostAddress(), "IpAddress", writer);
        } else {
            this.writeID("N/A", "IpAddress", writer);
        }
        this.writeSid(connector.getSid(), writer);
        this.writePort(connector.getPort(), writer);
        this.writeID(connector.getPoint(), "NetworkPointId", writer);
        this.writeTransport(connector.getTransport().toString(), writer);
        this.writeState(connector.getState().toString(), writer);
        this.writeAccountSid(connector.getAccountSid(), writer);
        writer.endNode();
    }

    public JsonElement serialize(Connector connector, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeID(NetworkManager.getNetworkPoint(connector.getPoint()).getAddress().getHostAddress(), "ip_address", object);
        this.writeSid(connector.getSid(), object);
        this.writePort(connector.getPort(), object);
        this.writeID(connector.getPoint(), "n_point", object);
        this.writeTransport(connector.getTransport().toString(), object);
        this.writeState(connector.getState().toString(), object);
        this.writeAccountSid(connector.getAccountSid(), object);
        return object;
    }

    protected void writeSid(Sid sid, String name, HierarchicalStreamWriter writer) {
        writer.startNode(name);
        writer.setValue(sid.toString());
        writer.endNode();
    }

    protected void writeSid(Sid sid, String name, JsonObject object) {
        object.addProperty(name, sid.toString());
    }

    private void writePort(int port, HierarchicalStreamWriter writer) {
        writer.startNode("Port");
        if (port != 0) {
            writer.setValue("" + port);
        }
        writer.endNode();
    }

    private void writePort(int port, JsonObject object) {
        object.addProperty("port", (Number)port);
    }

    private void writeTransport(String transport, HierarchicalStreamWriter writer) {
        writer.startNode("Transport");
        if (transport != null) {
            writer.setValue(transport);
        }
        writer.endNode();
    }

    private void writeTransport(String transport, JsonObject object) {
        object.addProperty("transport", transport);
    }

    private void writeState(String state, HierarchicalStreamWriter writer) {
        writer.startNode("State");
        if (state != null) {
            writer.setValue(state);
        }
        writer.endNode();
    }

    private void writeState(String state, JsonObject object) {
        object.addProperty("state", state);
    }

    private void writeID(String id, String name, HierarchicalStreamWriter writer) {
        writer.startNode(name);
        if (id != null) {
            writer.setValue(id);
        }
        writer.endNode();
    }

    private void writeID(String id, String name, JsonObject object) {
        object.addProperty(name, id);
    }
}

