/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.chain.impl;

import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.restcomm.chain.ParallelProcessorChain;
import org.restcomm.chain.ProcessorChain;
import org.restcomm.chain.impl.DefaultParallelProcessorChain;
import org.restcomm.chain.impl.MalformedProcessorChainException;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.Processor;
import org.restcomm.chain.processor.impl.DefaultDPIProcessor;
import org.restcomm.chain.processor.impl.DefaultProcessor;
import org.restcomm.chain.processor.impl.ImmutableMessage;
import org.restcomm.chain.processor.impl.MutableMessage;
import org.restcomm.chain.processor.impl.ProcessorParsingException;

public abstract class DefaultParallelProcessorChain
extends DefaultDPIProcessor
implements ParallelProcessorChain {
    private static transient Logger LOG = Logger.getLogger(DefaultParallelProcessorChain.class);
    private Processor nextLink;
    private HashMap<Integer, Processor> processors = new HashMap();

    public DefaultParallelProcessorChain() {
    }

    public DefaultParallelProcessorChain(String name) {
        super(name);
    }

    public void process(MutableMessage message) throws ProcessorParsingException {
        MutableMessage immutableMessage = message;
        this.fireProcessingEvent((Message)immutableMessage, (Processor)this.getCallback());
        ExecutorService taskExecutor = Executors.newFixedThreadPool(this.processors.size());
        for (Processor processor : this.processors.values()) {
            taskExecutor.execute((Runnable)new ProcessorTask(this, (ImmutableMessage)immutableMessage, processor));
        }
        taskExecutor.shutdown();
        try {
            taskExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.error((Object)e.getMessage());
        }
        if (message != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("<< DPC " + this.type + " output message [" + message + "]"));
        }
        this.fireEndEvent((Message)message, (Processor)this.getCallback());
        Processor nextLink = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DPC " + this.type + " from callback " + this.getName() + " chain " + this.getCallback()));
        }
        if ((nextLink = this.getNextLink((Processor)((DefaultProcessor)this.getCallback()))) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("DPC " + this.type + " from callback " + this.getName() + " nextlink " + nextLink));
            }
            nextLink.process(message);
        }
    }

    public String getName() {
        return "Raw Default Parallel Chain Implementation";
    }

    public int getId() {
        return this.hashCode();
    }

    public void link(Processor processor) throws MalformedProcessorChainException {
        if (processor == null) {
            throw new MalformedProcessorChainException("Processors could not be null");
        }
        this.processors.put(processor.getId(), processor);
    }

    public Processor getNextLink(Processor processor) {
        return this.nextLink;
    }

    public void setNextLink(Processor processor) throws MalformedProcessorChainException {
        this.nextLink = processor;
    }

    static /* synthetic */ void access$000(DefaultParallelProcessorChain x0, Message x1, Processor x2) {
        x0.fireProcessingEvent(x1, x2);
    }

    static /* synthetic */ ProcessorChain access$100(DefaultParallelProcessorChain x0) {
        return x0.chain;
    }

    static /* synthetic */ Logger access$200() {
        return LOG;
    }

    static /* synthetic */ Processor.Type access$300(DefaultParallelProcessorChain x0) {
        return x0.type;
    }

    static /* synthetic */ ProcessorChain access$400(DefaultParallelProcessorChain x0) {
        return x0.chain;
    }

    static /* synthetic */ void access$500(DefaultParallelProcessorChain x0, Message x1, Processor x2) {
        x0.fireEndEvent(x1, x2);
    }
}

