/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.bo;

import java.net.Inet6Address;
import java.net.InetAddress;
import org.restcomm.sbc.bo.NetworkPoint;
import org.restcomm.sbc.bo.Sid;

public class NetworkPoint {
    private String id;
    private int group;
    private String description;
    private InetAddress address;
    private String macAddress;
    private InetAddress broadcast;
    private short prefixMask;
    private Tag tag;
    private Sid accountSid;

    public NetworkPoint(String id) {
        this.id = id;
        this.tag = Tag.IDLE;
    }

    public NetworkPoint(String id, Sid accountSid, Tag tag) {
        this.id = id;
        this.accountSid = accountSid;
        this.tag = tag;
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public NetworkPoint setTag(Tag tag) {
        return new NetworkPoint(this.id, this.accountSid, tag);
    }

    public NetworkPoint setId(String id) {
        return new NetworkPoint(id, this.accountSid, this.tag);
    }

    public String getId() {
        return this.id;
    }

    public Tag getTag() {
        return this.tag;
    }

    public Sid getAccountSid() {
        return this.accountSid;
    }

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public InetAddress getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(InetAddress broadcast) {
        this.broadcast = broadcast;
    }

    public short getPrefixMask() {
        return this.prefixMask;
    }

    public void setPrefixMask(short prefixMask) {
        this.prefixMask = prefixMask;
    }

    public String toPrint() {
        return "id=" + this.id + ", group=" + this.group + ", mac=" + this.macAddress + ", description=" + this.description + ", ip=" + this.address.getHostAddress() + ", ipv6 ?" + (this.address instanceof Inet6Address);
    }
}

