/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.call;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.bo.CallDetailRecord;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.call.Call;
import org.restcomm.sbc.call.CallListener;
import org.restcomm.sbc.media.MediaSession;
import org.restcomm.sbc.media.MediaSessionListener;
import org.restcomm.sbc.media.MediaZone;

/*
 * Exception performing whole class analysis ignored.
 */
public class Call
implements MediaSessionListener {
    private static transient Logger LOG = Logger.getLogger(Call.class);
    private Call parent;
    private Sid sid;
    private CallDetailRecord cdr;
    private MediaSession mediaSession;
    private Status status;
    private Direction direction;
    private String sessionId;
    private EventListenerList listenerList = new EventListenerList();

    protected Call(Call parent, String sessionId, String to, String from, String direction, String callerName) {
        this.parent = parent;
        this.sessionId = sessionId;
        this.sid = Sid.generate((Sid.Type)Sid.Type.RANDOM);
        Sid parentCallSid = Sid.generate((Sid.Type)Sid.Type.RANDOM);
        DateTime dateCreated = DateTime.now();
        String apiVersion = ConfigurationCache.getApiVersion();
        this.mediaSession = new MediaSession(sessionId);
        this.mediaSession.addMediaSessionListener((MediaSessionListener)this);
        URI uri = null;
        try {
            uri = new URI(apiVersion + "/Calls/" + this.sid.toString());
        }
        catch (URISyntaxException e) {
            LOG.error((Object)"Cannot Create URI");
        }
        this.direction = Direction.getValueOf((String)direction);
        this.status = Status.INITIATING;
        this.cdr = new CallDetailRecord(this.sid, "", parentCallSid, dateCreated, dateCreated, to, from, Status.access$000((Status)this.status), dateCreated, dateCreated, Integer.valueOf(0), new BigDecimal(0), null, direction, null, apiVersion, null, callerName, uri, null, Integer.valueOf(0), Boolean.valueOf(false), Boolean.valueOf(false));
    }

    public void addCallListener(CallListener listener) {
        this.listenerList.add(CallListener.class, listener);
    }

    public CallDetailRecord getCdr() {
        return this.cdr;
    }

    public MediaSession getMediaSession() {
        return this.mediaSession;
    }

    public Status getStatus() {
        return this.status;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Sid getSid() {
        return this.sid;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    protected void setStatus(int statusCode, String reasonPhrase) {
        if (statusCode >= 400) {
            this.setStatus(Status.FAILED);
        } else if (statusCode >= 200) {
            this.setStatus(Status.COMPLETED);
        }
    }

    protected void setStatus(Status status) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Call was in status " + this.getStatus() + ", now changing to " + Status.access$000((Status)status)));
        }
        this.status = status;
        this.cdr = this.cdr.setStatus(Status.access$000((Status)status));
        switch (1.$SwitchMap$org$restcomm$sbc$call$Call$Status[status.ordinal()]) {
            case 1: {
                this.cdr = this.cdr.setStartTime(DateTime.now());
                break;
            }
            case 2: {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Datecreated " + this.cdr.getDateCreated()));
                    LOG.trace((Object)("StartTime   " + this.cdr.getStartTime()));
                }
                this.cdr = this.cdr.setRingDuration(Integer.valueOf((int)this.cdr.getStartTime().minus(this.cdr.getDateCreated().getMillis()).getMillis() / 1000));
                break;
            }
            case 3: {
                this.cdr = this.cdr.setEndTime(DateTime.now());
                this.cdr = this.cdr.setDuration(Integer.valueOf((int)this.cdr.getEndTime().minus(this.cdr.getStartTime().getMillis()).getMillis() / 1000));
                break;
            }
            case 4: {
                this.cdr = this.cdr.setEndTime(DateTime.now());
                this.cdr = this.cdr.setDuration(Integer.valueOf((int)this.cdr.getEndTime().minus(this.cdr.getStartTime().getMillis()).getMillis() / 1000));
                break;
            }
        }
    }

    public boolean equals(Object call) {
        Call otherCall = (Call)call;
        if (!(call instanceof Call)) {
            return false;
        }
        return otherCall.getSessionId().equals(this.getSessionId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        result = prime * result + (this.sid == null ? 0 : this.sid.hashCode());
        result = prime * result + (this.direction == null ? 0 : this.direction.hashCode());
        return result;
    }

    public Call getParent() {
        return this.parent;
    }

    public EventListenerList getListeners() {
        return this.listenerList;
    }

    public void onMediaTimeout(MediaSession session, MediaZone zone) {
        if (LOG.isInfoEnabled()) {
            LOG.warn((Object)("Force ending media on " + zone.toPrint()));
            LOG.info((Object)"TODO a BYE here ");
        }
    }

    public void onMediaTerminated(MediaSession mediaSession, MediaZone mediaZone) {
        if (mediaSession.isActive()) {
            // empty if block
        }
    }

    public void onMediaFailed(MediaSession mediaSession, MediaZone mediaZone) {
        LOG.error((Object)"MediaSession/Zone Failed!");
        if (mediaSession.isActive()) {
            mediaSession.finalize();
        }
    }

    public void onMediaReady(MediaSession mediaSession, MediaZone mediaZone) {
        try {
            if (!mediaSession.isActive()) {
                mediaSession.start();
            }
            if (!mediaZone.isRunning()) {
                mediaZone.start();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Cannot start MediaSession/Zone", (Throwable)e);
        }
    }
}

