/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.chain.impl;

import java.io.IOException;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import org.apache.log4j.Logger;
import org.mobicents.media.server.io.sdp.SdpException;
import org.restcomm.chain.ProcessorChain;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.ProcessorCallBack;
import org.restcomm.chain.processor.impl.DefaultProcessor;
import org.restcomm.chain.processor.impl.ProcessorParsingException;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.bo.Connector;
import org.restcomm.sbc.bo.Location;
import org.restcomm.sbc.bo.LocationNotFoundException;
import org.restcomm.sbc.call.CallManager;
import org.restcomm.sbc.managers.LocationManager;
import org.restcomm.sbc.managers.MessageUtil;
import org.restcomm.sbc.managers.ProtocolAdapterFactory;
import org.restcomm.sbc.managers.RouteManager;
import org.restcomm.sbc.media.MediaController;
import org.restcomm.sbc.media.MediaSession;
import org.restcomm.sbc.router.RoutingPolicy;

public class IncomingDPIProcessor
extends DefaultProcessor
implements ProcessorCallBack {
    private static transient Logger LOG = Logger.getLogger(IncomingDPIProcessor.class);
    private RouteManager routeManager = RouteManager.getRouteManager();
    private RoutingPolicy routingPolicy = ConfigurationCache.getRoutingPolicy();
    private LocationManager locationManager = LocationManager.getLocationManager();

    public IncomingDPIProcessor(ProcessorChain callback) {
        super(callback);
    }

    public IncomingDPIProcessor(String name, ProcessorChain callback) {
        super(name, callback);
    }

    public String getName() {
        return "Incoming DPI Processor";
    }

    public int getId() {
        return this.hashCode();
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProcessorCallBack getCallback() {
        return this;
    }

    public String getVersion() {
        return "1.0.0";
    }

    private void processRequest(Message message) throws ProcessorParsingException {
        SIPMutableMessage m = (SIPMutableMessage)message;
        SipServletMessage sm = m.getContent();
        m.setSourceLocalAddress(sm.getLocalAddr());
        m.setSourceRemoteAddress(sm.getRemoteAddr());
        m.setSourceTransport(sm.getTransport() == null ? "UDP" : sm.getTransport().toUpperCase());
        if (RouteManager.isFromDMZ((SipServletMessage)m.getContent())) {
            m.setDirection(0);
            try {
                Connector connector = this.routeManager.getRouteToMZ(sm.getLocalAddr(), sm.getLocalPort(), sm.getInitialTransport());
                m.setTargetLocalAddress(connector.getHost());
                m.setTargetRemoteAddress(this.routingPolicy.getCandidate().getHost());
                m.setTargetTransport(connector.getTransport().toString());
            }
            catch (Exception e) {
                LOG.error((Object)"ERROR", (Throwable)e);
            }
        } else {
            m.setDirection(1);
            SipURI toURI = (SipURI)sm.getTo().getURI();
            m.setTarget(0);
            m.setTargetLocalAddress(ConfigurationCache.getIpOfDomain());
            if (!sm.getMethod().equals("REGISTER")) {
                Location location = null;
                try {
                    location = this.locationManager.getLocation(toURI.getUser() + "@" + ConfigurationCache.getDomain());
                    m.setTargetRemoteAddress(location.getHost());
                    m.setTargetTransport(location.getTransport().toUpperCase());
                }
                catch (LocationNotFoundException e) {
                    LOG.warn((Object)(toURI.getUser() + " is not a registered user in the domain " + ConfigurationCache.getDomain()));
                    LOG.warn((Object)" this UAC may be registered directly in the back-Sip REGISTRAR");
                    m.setTargetRemoteAddress(this.routingPolicy.getCandidate().getHost());
                }
            }
        }
        m.setTarget(2);
        if (sm.getContentLength() > 0 && sm.getContentType().equals("application/sdp")) {
            try {
                MediaSession mediaSession = CallManager.getCallManager().getMediaSession(sm.getSession().getId());
                MediaController.StreamProfile streamProfile = m.getSourceTransport().equals(ProtocolAdapterFactory.PROTOCOL_WSS) ? MediaController.StreamProfile.WEBRTC : MediaController.StreamProfile.AVP;
                mediaSession.buildOffer(streamProfile, new String(sm.getRawContent()), m.getTargetLocalAddress());
                m.setMetadata((Object)mediaSession);
            }
            catch (IOException | SdpException e) {
                LOG.error((Object)"Invalid MediaMetadata!", e);
            }
        }
    }

    private void processResponse(Message message) {
        SIPMutableMessage m = (SIPMutableMessage)message;
        SipServletMessage sm = m.getContent();
        m.setSourceLocalAddress(sm.getLocalAddr());
        m.setSourceRemoteAddress(sm.getRemoteAddr());
        m.setSourceTransport(sm.getTransport() == null ? "UDP" : sm.getTransport().toUpperCase());
        if (RouteManager.isFromDMZ((SipServletMessage)m.getContent())) {
            m.setDirection(0);
            m.setTarget(2);
            try {
                Connector connector = this.routeManager.getRouteToMZ(sm.getLocalAddr(), sm.getLocalPort(), sm.getInitialTransport());
                m.setTargetLocalAddress(connector.getHost());
                m.setTargetRemoteAddress(this.routingPolicy.getCandidate().getHost());
                m.setTargetTransport(connector.getTransport().toString());
            }
            catch (Exception e) {
                LOG.error((Object)"ERROR", (Throwable)e);
            }
        } else {
            m.setDirection(1);
            SipURI fromURI = (SipURI)sm.getFrom().getURI();
            m.setTarget(0);
            if (!sm.getMethod().equals("REGISTER")) {
                Location location = null;
                try {
                    location = this.locationManager.getLocation(fromURI.getUser() + "@" + ConfigurationCache.getDomain());
                    m.setTargetLocalAddress(ConfigurationCache.getIpOfDomain());
                    m.setTargetRemoteAddress(location.getHost());
                    m.setTargetTransport(location.getTransport().toUpperCase());
                }
                catch (Exception e) {
                    LOG.error((Object)"ERROR", (Throwable)e);
                }
            }
        }
        if (sm.getContentLength() > 0 && sm.getContentType().equals("application/sdp")) {
            try {
                SipServletResponse response = (SipServletResponse)sm;
                String callSessionId = this.getCallSessionId(response.getRequest());
                MediaSession mediaSession = CallManager.getCallManager().getMediaSession(callSessionId);
                MediaController.StreamProfile streamProfile = m.getSourceTransport().equals(ProtocolAdapterFactory.PROTOCOL_WSS) ? MediaController.StreamProfile.WEBRTC : MediaController.StreamProfile.AVP;
                mediaSession.buildAnswer(streamProfile, new String(sm.getRawContent()), m.getTargetLocalAddress());
                m.setMetadata((Object)mediaSession);
            }
            catch (IOException | SdpException e) {
                LOG.error((Object)"Invalid MediaMetadata!", e);
            }
        }
    }

    public void doProcess(Message message) throws ProcessorParsingException {
        SIPMutableMessage m = (SIPMutableMessage)message;
        SipServletMessage sm = (SipServletMessage)message.getContent();
        if (sm instanceof SipServletRequest) {
            this.processRequest((Message)m);
        }
        if (sm instanceof SipServletResponse) {
            this.processResponse((Message)m);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)message.toString());
            LOG.trace((Object)("-------" + sm.getLocalAddr() + "->" + sm.getRemoteAddr()));
            LOG.trace((Object)("-------Receiving message: \n" + sm));
        }
    }

    private String getCallSessionId(SipServletRequest currentRequest) {
        SipServletRequest oRequest = (SipServletRequest)currentRequest.getSession().getAttribute(MessageUtil.B2BUA_ORIG_REQUEST_ATTR);
        return oRequest.getSession().getId();
    }
}

