/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.adapter;

import java.io.IOException;
import java.net.NoRouteToHostException;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletResponse;
import org.apache.log4j.Logger;
import org.mobicents.media.server.io.sdp.SdpException;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.media.MediaController;
import org.restcomm.sbc.media.MediaSession;

public abstract class ProtocolAdapter {
    private static transient Logger LOG = Logger.getLogger(ProtocolAdapter.class);

    public abstract Message adapt(Message var1) throws NoRouteToHostException;

    protected abstract String adaptSdp(MediaController var1, String var2) throws SdpException;

    public abstract String getProtocol();

    public Message adaptMedia(Message message) {
        SIPMutableMessage m = (SIPMutableMessage)message;
        SipServletMessage sm = m.getContent();
        try {
            MediaController mediaController;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(sm.getMethod() + " adapting SDP"));
            }
            String host = message.getTargetLocalAddress();
            MediaSession mediaSession = (MediaSession)m.getMetadata();
            if (sm instanceof SipServletResponse) {
                mediaController = mediaSession.getAnswer();
                mediaSession.attach();
            } else {
                mediaController = mediaSession.getOffer();
            }
            String sdpContent = mediaController.getProxySdp(host);
            sdpContent = this.adaptSdp(mediaController, host);
            m.setMetadata(mediaSession);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("MDA " + m.getMetadata()));
                LOG.debug((Object)m.toString());
                LOG.debug((Object)("patched Content:\n" + sdpContent));
            }
            sm.setContent((Object)sdpContent, "application/sdp");
            m.setContent(sm);
        }
        catch (IOException e) {
            LOG.error((Object)"No SDP content!", (Throwable)e);
            return m;
        }
        catch (SdpException e) {
            LOG.error((Object)"MediaMetadata invalid!", (Throwable)e);
            return m;
        }
        return m;
    }
}

