/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.adapter.impl;

import java.net.NoRouteToHostException;
import javax.servlet.sip.SipServletMessage;
import org.apache.log4j.Logger;
import org.mobicents.media.server.io.sdp.SdpException;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.adapter.ProtocolAdapter;
import org.restcomm.sbc.managers.ProtocolAdapterFactory;
import org.restcomm.sbc.media.MediaController;

public class WSSProtocolAdapter
extends ProtocolAdapter {
    private static transient Logger LOG = Logger.getLogger(WSSProtocolAdapter.class);
    private SIPMutableMessage m;

    @Override
    public Message adapt(Message message) throws NoRouteToHostException {
        this.m = (SIPMutableMessage)message;
        SipServletMessage sm = this.m.getContent();
        String sourceTransport = this.m.getSourceTransport();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(">> adapt() Adapting protocol [" + sourceTransport + "->" + this.getProtocol() + "]"));
        }
        if (sm.getContentLength() > 0 && sm.getContentType().equalsIgnoreCase("application/sdp")) {
            message = this.adaptMedia(message);
        }
        return this.m;
    }

    @Override
    protected String adaptSdp(MediaController mediaController, String host) throws SdpException {
        String sdpContent = mediaController.getWebrtcSdp(host);
        return sdpContent;
    }

    @Override
    public String getProtocol() {
        return ProtocolAdapterFactory.PROTOCOL_WSS;
    }
}

