/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.bo;

import java.math.BigDecimal;
import java.net.URI;
import java.util.Currency;
import org.joda.time.DateTime;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.Immutable;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.NotThreadSafe;
import org.restcomm.sbc.bo.Sid;

@Immutable
public class CallDetailRecord {
    private final Sid sid;
    private final String instanceId;
    private final Sid parentCallSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String to;
    private final String from;
    private final String status;
    private final DateTime startTime;
    private final DateTime endTime;
    private final Integer duration;
    private final Integer ringDuration;
    private final BigDecimal price;
    private final Currency priceUnit;
    private final String direction;
    private final String answeredBy;
    private final String apiVersion;
    private final String forwardedFrom;
    private final String callerName;
    private final URI uri;
    private final String callPath;
    private final Boolean muted;
    private final Boolean onHold;

    public CallDetailRecord(Sid sid, String instanceId, Sid parentCallSid, DateTime dateCreated, DateTime dateUpdated, String to, String from, String status, DateTime startTime, DateTime endTime, Integer duration, BigDecimal price, Currency priceUnit, String direction, String answeredBy, String apiVersion, String forwardedFrom, String callerName, URI uri, String callPath, Integer ringDuration, Boolean muted, Boolean onHold) {
        this.sid = sid;
        this.instanceId = instanceId;
        this.parentCallSid = parentCallSid;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
        this.to = to;
        this.from = from;
        this.status = status;
        this.startTime = startTime;
        this.endTime = endTime;
        this.duration = duration;
        this.price = price;
        this.priceUnit = priceUnit;
        this.direction = direction;
        this.answeredBy = answeredBy;
        this.apiVersion = apiVersion;
        this.forwardedFrom = forwardedFrom;
        this.callerName = callerName;
        this.uri = uri;
        this.callPath = callPath;
        this.ringDuration = ringDuration;
        this.muted = muted;
        this.onHold = onHold;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Sid getSid() {
        return this.sid;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Sid getParentCallSid() {
        return this.parentCallSid;
    }

    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    public DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public String getStatus() {
        return this.status;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public Integer getRingDuration() {
        return this.ringDuration;
    }

    public BigDecimal getPrice() {
        return this.price == null ? new BigDecimal("0.0") : this.price;
    }

    public Currency getPriceUnit() {
        return this.priceUnit == null ? Currency.getInstance("USD") : this.priceUnit;
    }

    public String getDirection() {
        return this.direction;
    }

    public String getAnsweredBy() {
        return this.answeredBy;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getForwardedFrom() {
        return this.forwardedFrom;
    }

    public String getCallerName() {
        return this.callerName;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getCallPath() {
        return this.callPath;
    }

    public Boolean isMuted() {
        return this.muted;
    }

    public Boolean isOnHold() {
        return this.onHold;
    }

    public CallDetailRecord setStatus(String status) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.dateCreated, DateTime.now(), this.to, this.from, status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.onHold);
    }

    public CallDetailRecord setStartTime(DateTime startTime) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.dateCreated, DateTime.now(), this.to, this.from, this.status, startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.onHold);
    }

    public CallDetailRecord setEndTime(DateTime endTime) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.dateCreated, DateTime.now(), this.to, this.from, this.status, this.startTime, endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.onHold);
    }

    public CallDetailRecord setDuration(Integer duration) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.dateCreated, DateTime.now(), this.to, this.from, this.status, this.startTime, this.endTime, duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.onHold);
    }

    public CallDetailRecord setRingDuration(Integer ringDuration) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.dateCreated, DateTime.now(), this.to, this.from, this.status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, ringDuration, this.muted, this.onHold);
    }

    public CallDetailRecord setPrice(BigDecimal price) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.dateCreated, DateTime.now(), this.to, this.from, this.status, this.startTime, this.endTime, this.duration, price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.onHold);
    }

    public CallDetailRecord setAnsweredBy(String answeredBy) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.dateCreated, DateTime.now(), this.to, this.from, this.status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.onHold);
    }

    public CallDetailRecord setMuted(Boolean muted) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.dateCreated, DateTime.now(), this.to, this.from, this.status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, muted, this.onHold);
    }

    public CallDetailRecord setOnHold(Boolean onHold) {
        return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.dateCreated, DateTime.now(), this.to, this.from, this.status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, onHold);
    }

    public boolean equals(Object cdr) {
        CallDetailRecord otherRecord = (CallDetailRecord)cdr;
        if (!(cdr instanceof CallDetailRecord)) {
            return false;
        }
        return otherRecord.getSid().equals(this.getSid());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.sid == null ? 0 : this.sid.hashCode());
        result = prime * result + (this.to == null ? 0 : this.to.hashCode());
        result = prime * result + (this.from == null ? 0 : this.from.hashCode());
        result = prime * result + (this.dateCreated == null ? 0 : this.dateCreated.hashCode());
        result = prime * result + (this.direction == null ? 0 : this.direction.hashCode());
        return result;
    }

    @NotThreadSafe
    public static final class Builder {
        private Sid sid = null;
        private String instanceId = null;
        private Sid parentCallSid = null;
        private DateTime dateCreated = null;
        private DateTime dateUpdated = DateTime.now();
        private String to = null;
        private String from = null;
        private String status = null;
        private DateTime startTime = null;
        private DateTime endTime = null;
        private Integer duration = null;
        private Integer ringDuration = null;
        private BigDecimal price = null;
        private Currency priceUnit;
        private String direction = null;
        private String answeredBy = null;
        private String apiVersion = null;
        private String forwardedFrom = null;
        private String callerName = null;
        private URI uri = null;
        private String callPath = null;
        private Boolean muted = null;
        private Boolean onHold = null;

        private Builder() {
        }

        public CallDetailRecord build() {
            return new CallDetailRecord(this.sid, this.instanceId, this.parentCallSid, this.dateCreated, this.dateUpdated, this.to, this.from, this.status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.apiVersion, this.forwardedFrom, this.callerName, this.uri, this.callPath, this.ringDuration, this.muted, this.onHold);
        }

        public void setSid(Sid sid) {
            this.sid = sid;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public void setParentCallSid(Sid parentCallSid) {
            this.parentCallSid = parentCallSid;
        }

        public void setDateCreated(DateTime dateCreated) {
            this.dateCreated = dateCreated;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setStartTime(DateTime startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(DateTime endTime) {
            this.endTime = endTime;
        }

        public void setDuration(Integer duration) {
            this.duration = duration;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public void setPriceUnit(Currency priceUnit) {
            this.priceUnit = priceUnit;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public void setAnsweredBy(String answeredBy) {
            this.answeredBy = answeredBy;
        }

        public void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        public void setForwardedFrom(String forwardedFrom) {
            this.forwardedFrom = forwardedFrom;
        }

        public void setCallerName(String callerName) {
            this.callerName = callerName;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }

        public void setCallPath(String callPath) {
            this.callPath = callPath;
        }

        public void setMuted(Boolean muted) {
            this.muted = muted;
        }

        public void setOnHold(Boolean onHold) {
            this.onHold = onHold;
        }
    }
}

