/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.call;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import org.infinispan.Cache;
import org.restcomm.sbc.bo.CallDetailRecord;
import org.restcomm.sbc.bo.CallDetailRecordFilter;
import org.restcomm.sbc.call.Call;
import org.restcomm.sbc.call.CallListener;
import org.restcomm.sbc.call.CallManagerListener;
import org.restcomm.sbc.managers.CacheManager;
import org.restcomm.sbc.media.MediaSession;

public class CallManager {
    private Cache<String, Call> calls;
    private static CallManager callManager;
    private static final Logger LOG;
    private EventListenerList listenerList = new EventListenerList();

    private CallManager() {
        this.calls = CacheManager.getCacheManager().getCache("callmanager");
        this.calls.start();
    }

    public static CallManager getCallManager() {
        if (callManager == null) {
            callManager = new CallManager();
        }
        return callManager;
    }

    public void addCallManagerListener(CallManagerListener listener) {
        this.listenerList.add(CallManagerListener.class, listener);
    }

    public Call createCall(Call parent, String sessionId, String to, String from, String direction, String forwardedFrom, String callerName) {
        Call call = new Call(parent, sessionId, to, from, direction, callerName);
        this.fireCallCreatedEvent(call);
        this.calls.put((Object)sessionId, (Object)call);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("calls.put " + sessionId + " hashcode " + call.hashCode()));
        }
        return call;
    }

    public MediaSession getMediaSession(String sessionId) {
        return ((Call)this.calls.get((Object)sessionId)).getMediaSession();
    }

    public void changeCallStatus(String sessionId, int statusCode, String reasonPhrase) {
        if (statusCode >= 400) {
            this.changeCallStatus(sessionId, Call.Status.FAILED);
        } else if (statusCode > 200) {
            this.changeCallStatus(sessionId, Call.Status.ALERTING);
        }
    }

    public void changeCallStatus(String sessionId, Call.Status status) {
        Call call = this.getCall(sessionId);
        call.setStatus(status);
        switch (status) {
            case INITIATING: {
                this.fireCallCreatedEvent(call);
                this.fireCallInitiatingEvent(call);
                break;
            }
            case BRIDGED: {
                this.fireCallAnsweredEvent(call);
                this.fireCallBridgedEvent(call);
                break;
            }
            case COMPLETED: {
                this.fireCallReleasedEvent(call);
                this.fireCallCompletedEvent(call);
                call.getMediaSession().finalize();
                break;
            }
            case FAILED: {
                this.fireCallRejectedEvent(call);
                this.fireCallFailedEvent(call);
                call.getMediaSession().finalize();
                break;
            }
            case RINGING: {
                this.fireCallRingingEvent(call);
                break;
            }
            case ALERTING: {
                if (call.getDirection() == Call.Direction.INBOUND) {
                    this.fireCallIncomingEvent(call);
                } else {
                    this.fireCallDialingEvent(call);
                }
                this.fireCallAlertingEvent(call);
            }
        }
    }

    public void remove(String sessionId) {
        this.calls.remove((Object)sessionId);
    }

    public Call getCall(String sessionId) {
        Call call = (Call)this.calls.get((Object)sessionId);
        if (LOG.isTraceEnabled() && call != null) {
            LOG.trace((Object)("call hashCode " + call.hashCode()));
        }
        return call;
    }

    public Collection<Call> getCalls() {
        ArrayList<Call> al = new ArrayList<Call>((Collection<Call>)this.calls.values());
        return al;
    }

    public int getTotalCalls(CallDetailRecordFilter filterForTotal) {
        int counter = 0;
        for (Object l : this.calls.values()) {
            CallDetailRecord call = (CallDetailRecord)l;
            String recipient = filterForTotal.getRecipient();
            String sender = filterForTotal.getSender();
            if (recipient != null && !call.getAnsweredBy().startsWith(recipient.replace("%", "")) || sender != null && !call.getFrom().startsWith(sender.replace("%", ""))) continue;
            ++counter;
        }
        return counter;
    }

    public List<Call> getCalls(CallDetailRecordFilter filter) {
        int offsetCounter = 0;
        int limitCounter = 0;
        int limit = filter.getLimit();
        int offset = filter.getOffset();
        ArrayList<Call> acalls = new ArrayList<Call>();
        for (Object l : this.calls.values()) {
            Call call = (Call)l;
            String recipient = filter.getRecipient();
            String sender = filter.getSender();
            if (recipient != null && !call.getCdr().getAnsweredBy().startsWith(recipient.replace("%", "")) || sender != null && !call.getCdr().getFrom().startsWith(sender.replace("%", "")) || ++offsetCounter <= offset || limitCounter >= limit) continue;
            acalls.add(call);
            ++limitCounter;
        }
        return acalls;
    }

    protected void fireCallCreatedEvent(Call call) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CallManagerListener.class) continue;
            ((CallManagerListener)listeners[i + 1]).onCallCreated(call);
        }
    }

    protected void fireCallAnsweredEvent(Call call) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CallManagerListener.class) continue;
            ((CallManagerListener)listeners[i + 1]).onCallAnswered(call);
        }
    }

    protected void fireCallReleasedEvent(Call call) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CallManagerListener.class) continue;
            ((CallManagerListener)listeners[i + 1]).onCallReleased(call);
        }
    }

    protected void fireCallRejectedEvent(Call call) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CallManagerListener.class) continue;
            ((CallManagerListener)listeners[i + 1]).onCallRejected(call);
        }
    }

    protected void fireCallIncomingEvent(Call call) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CallManagerListener.class) continue;
            ((CallManagerListener)listeners[i + 1]).onCallIncoming(call);
        }
    }

    protected void fireCallDialingEvent(Call call) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CallManagerListener.class) continue;
            ((CallManagerListener)listeners[i + 1]).onCallDialing(call);
        }
    }

    protected void fireCallInitiatingEvent(Call call) {
        Object[] listeners = call.getListeners().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CallListener.class) continue;
            ((CallListener)listeners[i + 1]).onCallInitiating();
        }
    }

    protected void fireCallFailedEvent(Call call) {
        Object[] listeners = call.getListeners().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CallListener.class) continue;
            ((CallListener)listeners[i + 1]).onCallFailed();
        }
    }

    protected void fireCallCompletedEvent(Call call) {
        Object[] listeners = call.getListeners().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CallListener.class) continue;
            ((CallListener)listeners[i + 1]).onCallCompleted();
        }
    }

    protected void fireCallBridgedEvent(Call call) {
        Object[] listeners = call.getListeners().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CallListener.class) continue;
            ((CallListener)listeners[i + 1]).onCallBridged();
        }
    }

    protected void fireCallRingingEvent(Call call) {
        Object[] listeners = call.getListeners().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CallListener.class) continue;
            ((CallListener)listeners[i + 1]).onCallRinging();
        }
    }

    protected void fireCallAlertingEvent(Call call) {
        Object[] listeners = call.getListeners().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CallListener.class) continue;
            ((CallListener)listeners[i + 1]).onCallAlerting();
        }
    }

    static {
        LOG = Logger.getLogger(CallManager.class);
    }
}

