/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.managers.jmx.jboss;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMX;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.listener.SipConnectorListener;
import org.mobicents.servlet.sip.startup.SipProtocolHandler;
import org.restcomm.sbc.bo.Connector;
import org.restcomm.sbc.bo.NetworkPoint;
import org.restcomm.sbc.managers.NetworkManager;
import org.restcomm.sbc.managers.jmx.JMXProvider;

public class Provider
implements JMXProvider,
NotificationListener,
SipConnectorListener {
    private static transient Logger LOG = Logger.getLogger(Provider.class);
    private JMXConnector jmxc;
    private MBeanServerConnection mbsc;
    private ObjectName osMBeanName;
    private ObjectName objectMBeanName;
    private ObjectName sipMBeanName;
    private ArrayList<Connector> connectors;

    public Provider() throws IOException, MalformedObjectNameException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        String urlString = "service:jmx:remoting-jmx://localhost:9999";
        String objectNamePointer = "jboss.sip:type=SipConnector,*";
        String osNamePointer = "java.lang:type=OperatingSystem";
        String sipNamePointer = "jboss.as:subsystem=sip";
        System.out.println("Starting lookup ...");
        JMXServiceURL serviceURL = new JMXServiceURL(urlString);
        this.jmxc = JMXConnectorFactory.connect(serviceURL, null);
        this.mbsc = this.jmxc.getMBeanServerConnection();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("\nCreate an RMI connector client on: " + urlString));
        }
        this.osMBeanName = new ObjectName(osNamePointer);
        this.sipMBeanName = new ObjectName(sipNamePointer);
        this.objectMBeanName = new ObjectName(objectNamePointer);
        Set<ObjectInstance> mbeans = this.mbsc.queryMBeans(this.objectMBeanName, null);
        ObjectName interfaceMBeanName = new ObjectName("jboss.as:interface=mz-201");
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        InterfaceMBean interfaceProxy = JMX.newMBeanProxy(this.mbsc, interfaceMBeanName, InterfaceMBean.class);
        interfaceProxy.setName("mz-201");
        interfaceProxy.setInetAddress("192.168.88.2");
        for (ObjectInstance mbean : mbeans) {
            if (!LOG.isDebugEnabled()) continue;
            System.err.println("SipConnector Ontree: " + mbean);
            ObjectInstance oInstance = mbean;
            System.err.println("Class  Name:t" + oInstance.getClassName());
        }
    }

    private void readAttributes(MBeanServerConnection mBeanServer, ObjectInstance http) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        MBeanInfo info = mBeanServer.getMBeanInfo(http.getObjectName());
        MBeanAttributeInfo[] attrInfo = info.getAttributes();
        LOG.debug((Object)("Attributes for object: " + http + ":\n"));
        for (MBeanAttributeInfo attr : attrInfo) {
            LOG.debug((Object)(" -- Attribute " + attr.getName()));
        }
    }

    private void readOperations(MBeanServerConnection mBeanServer, ObjectInstance http) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        MBeanInfo info = mBeanServer.getMBeanInfo(http.getObjectName());
        MBeanOperationInfo[] operInfo = info.getOperations();
        LOG.debug((Object)("Operations for object: " + http + ":\n"));
        for (MBeanOperationInfo oper : operInfo) {
            LOG.debug((Object)(" -- Operation --- " + oper.getName()));
        }
    }

    @Override
    public boolean removeSipConnector(String ipAddress, int port, String transport) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Boolean stat = (Boolean)this.mbsc.invoke(this.objectMBeanName, "removeSipConnector", new Object[]{ipAddress, port, transport}, new String[]{String.class.getCanonicalName(), Integer.TYPE.getCanonicalName(), String.class.getCanonicalName()});
        return stat;
    }

    @Override
    public boolean addSipConnector(String ipAddress, int port, String transport) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        transport = transport.toLowerCase();
        SipConnectorProxy sipConnector = JMX.newMBeanProxy(this.mbsc, this.sipMBeanName, SipConnectorProxy.class);
        sipConnector.addConnector("sip-" + transport + "-" + ipAddress + "-" + port, port, false, ipAddress, port, "sip-" + transport, "", "sip", "sip-" + transport, true, ipAddress, "", true, "SIP/2.0", 1099, 3079, false);
        return true;
    }

    @Override
    public List<Connector> getConnectors() {
        try {
            Set<ObjectInstance> mbeans = this.mbsc.queryMBeans(this.objectMBeanName, null);
            for (ObjectInstance mbean : mbeans) {
                if (!LOG.isDebugEnabled()) continue;
                System.err.println("SipConnector Ontree: " + mbean);
                SipProtocolHandler handler = (SipProtocolHandler)this.mbsc.getAttribute(this.objectMBeanName, "protocol");
            }
            SipConnector[] sipConnectors = (SipConnector[])this.mbsc.invoke(this.objectMBeanName, "findSipConnectors", null, null);
            for (int i = 0; i < sipConnectors.length; ++i) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SipConnector " + sipConnectors[i]));
                }
                NetworkPoint point = NetworkManager.getNetworkPointByIpAddress(sipConnectors[i].getIpAddress());
                Connector connector = new Connector(sipConnectors[i].getPort(), Connector.Transport.getValueOf(sipConnectors[i].getTransport()), point.getId(), Connector.State.DOWN);
                this.connectors.add(connector);
            }
        }
        catch (InstanceNotFoundException e) {
            LOG.error((Object)e);
        }
        catch (MBeanException e) {
            LOG.error((Object)e);
        }
        catch (ReflectionException e) {
            LOG.error((Object)e);
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
        catch (AttributeNotFoundException e) {
            LOG.error((Object)e);
        }
        return this.connectors;
    }

    public void traceSipConnectors() throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        SipConnector[] sipConnectors = (SipConnector[])this.mbsc.invoke(this.objectMBeanName, "findSipConnectors", null, null);
        for (int i = 0; i < sipConnectors.length; ++i) {
            System.out.println(sipConnectors[i]);
            LOG.info((Object)sipConnectors[i]);
        }
    }

    @Override
    public void close() throws IOException {
        this.jmxc.close();
    }

    @Override
    public int getCPULoadAverage() {
        Object attrVal = null;
        try {
            attrVal = this.mbsc.getAttribute(this.osMBeanName, "SystemCpuLoad");
        }
        catch (IOException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
            return 0;
        }
        return (int)((Double)attrVal * 100.0);
    }

    @Override
    public int getMemoryUsage() {
        long total = 0L;
        long free = 0L;
        try {
            total = (Long)this.mbsc.getAttribute(this.osMBeanName, "TotalPhysicalMemorySize");
            free = (Long)this.mbsc.getAttribute(this.osMBeanName, "FreePhysicalMemorySize");
        }
        catch (IOException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
            return 0;
        }
        int used = (int)((double)(total - free) / (double)total * 100.0);
        return used;
    }

    public static void getServer() throws Exception {
        System.out.println("Starting lookup ...");
        ObjectName mBeanName = new ObjectName("java.lang:type=Runtime");
        String attributeName = "StartTime";
        String host = "localhost";
        int port = 9999;
        String urlString = System.getProperty("jmx.service.url", "service:jmx:remoting-jmx://" + host + ":" + port);
        JMXServiceURL serviceURL = new JMXServiceURL(urlString);
        JMXConnector jmxConnector = JMXConnectorFactory.connect(serviceURL, null);
        MBeanServerConnection connection = jmxConnector.getMBeanServerConnection();
        Object attrVal = connection.getAttribute(mBeanName, attributeName);
        System.err.println("Value via JMX: " + new Date((Long)attrVal));
    }

    public static void main(String[] argv) throws InstanceNotFoundException {
        Provider m = null;
        try {
            m = new Provider();
        }
        catch (IOException | IntrospectionException | MalformedObjectNameException | ReflectionException e1) {
            e1.printStackTrace();
        }
        m.getConnectors();
        System.err.println("CPU " + m.getCPULoadAverage());
        System.err.println("MEM " + m.getMemoryUsage());
        try {
            m.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        LOG.info((Object)("Notification " + notification + " callback " + handback));
    }

    public void onKeepAliveTimeout(SipConnector arg0, String arg1, int arg2) {
    }

    public void sipConnectorAdded(SipConnector arg0) {
        LOG.info((Object)("ADDED " + arg0));
    }

    public void sipConnectorRemoved(SipConnector arg0) {
        LOG.info((Object)("REMOVED " + arg0));
    }

    public static interface InterfaceMBean {
        public void setInetAddress(String var1);

        public void setName(String var1);
    }

    static class Interface
    implements InterfaceMBean {
        String inetAddress;
        String name;

        Interface() {
        }

        @Override
        public void setInetAddress(String ip) {
            this.inetAddress = ip;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }
    }

    public static interface SipConnectorProxy {
        public void addConnector(String var1, int var2, boolean var3, String var4, int var5, String var6, String var7, String var8, String var9, boolean var10, String var11, String var12, boolean var13, String var14, int var15, int var16, boolean var17);

        public void setTransport(String var1);

        public void setPort(int var1);
    }
}

