/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import org.apache.log4j.Logger;
import org.mobicents.media.io.ice.IceAuthenticator;
import org.mobicents.media.io.ice.IceAuthenticatorImpl;
import org.mobicents.media.server.impl.rtp.SsrcGenerator;
import org.mobicents.media.server.io.sdp.format.RTPFormats;
import org.mobicents.media.server.spi.ConnectionMode;
import org.restcomm.sbc.media.RtcpChannel;
import org.restcomm.sbc.media.RtpChannel;

public abstract class MediaChannel {
    private static final Logger logger = Logger.getLogger(MediaChannel.class);
    protected final String mediaType;
    protected long ssrc;
    protected String cname;
    protected boolean rtcpMux;
    protected boolean open;
    private boolean ice;
    private boolean dtls;
    protected RTPFormats supportedFormats;
    protected RTPFormats offeredFormats;
    protected RTPFormats negotiatedFormats;
    protected boolean negotiated;
    protected RtpChannel rtpChannel;
    protected RtcpChannel rtcpChannel;
    private final IceAuthenticatorImpl iceAuthenticator;
    private String originalHost;
    private int originalPort;

    protected MediaChannel(String mediaType, String originalHost, int originalPort) {
        this.mediaType = mediaType;
        this.ssrc = 0L;
        this.cname = "";
        this.rtcpMux = false;
        this.open = false;
        this.ice = false;
        this.dtls = false;
        this.originalHost = originalHost;
        this.originalPort = originalPort;
        this.rtpChannel = this.createRtpChannel(originalHost, originalPort);
        this.supportedFormats = new RTPFormats();
        this.offeredFormats = new RTPFormats();
        this.negotiatedFormats = new RTPFormats();
        this.negotiated = true;
        this.setFormats(this.supportedFormats);
        this.iceAuthenticator = new IceAuthenticatorImpl();
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public long getSsrc() {
        return this.ssrc;
    }

    public void setSsrc(long ssrc) {
        this.ssrc = ssrc;
    }

    public String getCname() {
        return this.cname;
    }

    public void setCname(String cname) {
        this.cname = cname;
    }

    public String getExternalAddress() {
        if (this.rtpChannel.isBound()) {
            return this.rtpChannel.getExternalAddress();
        }
        return "";
    }

    public String getRtpAddress() {
        if (this.rtpChannel.isBound()) {
            return this.rtpChannel.getLocalHost();
        }
        return "";
    }

    public int getRtpPort() {
        if (this.rtpChannel.isBound()) {
            return this.rtpChannel.getLocalPort();
        }
        return 0;
    }

    public String getRtcpAddress() {
        if (this.rtcpMux) {
            return this.getRtpAddress();
        }
        return "";
    }

    public int getRtcpPort() {
        if (this.rtcpMux) {
            return this.getRtpPort();
        }
        return 0;
    }

    public void open() {
        this.ssrc = SsrcGenerator.generateSsrc();
        this.open = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " is open"));
        }
    }

    public void close() throws IllegalStateException {
        if (this.open) {
            this.rtpChannel.close();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " is closed"));
            }
        } else {
            throw new IllegalStateException("Channel is already inactive");
        }
        this.reset();
        this.open = false;
    }

    private void reset() {
        if (this.rtcpMux) {
            this.rtcpMux = false;
        }
        if (this.ice) {
            this.disableICE();
        }
        if (this.dtls) {
            this.disableDTLS();
        }
        this.cname = "";
        this.ssrc = 0L;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isAvailable() {
        boolean available = this.rtpChannel.isAvailable();
        return available;
    }

    public void setConnectionMode(ConnectionMode mode) {
        this.rtpChannel.updateMode(mode);
    }

    public void bind(DatagramChannel localChannel, boolean rtcpMux) throws IOException, IllegalStateException {
        this.rtpChannel.setRtcpMux(rtcpMux);
        this.rtcpMux = rtcpMux;
        this.rtpChannel.bind(localChannel);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.mediaType + " RTP channel " + this.ssrc + " is bound to " + this.rtpChannel.getLocalHost() + ":" + this.rtpChannel.getLocalPort()));
            if (rtcpMux) {
                logger.debug((Object)(this.mediaType + " is multiplexing RTCP"));
            }
        }
    }

    public boolean isRtcpMux() {
        return this.rtcpMux;
    }

    public void connectRtp(SocketAddress address) {
        this.rtpChannel.setRemotePeer(address);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.mediaType + " RTP channel " + this.ssrc + " connected to remote peer " + address.toString()));
        }
    }

    public void connectRtp(String address, int port) {
        this.connectRtp(new InetSocketAddress(address, port));
    }

    public void bindRtcp(boolean isLocal, int port) throws IOException, IllegalStateException {
        if (this.ice) {
            throw new IllegalStateException("Cannot bind when ICE is enabled");
        }
        this.rtcpMux = port == this.rtpChannel.getLocalPort();
    }

    public void connectRtcp(SocketAddress remoteAddress) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.mediaType + " RTCP channel " + this.ssrc + " has connected to remote peer " + remoteAddress.toString()));
        }
    }

    public void connectRtcp(String address, int port) {
        this.connectRtcp(new InetSocketAddress(address, port));
    }

    public void setFormats(RTPFormats formats) {
        this.negotiatedFormats = formats;
        this.rtpChannel.setFormatMap(formats);
    }

    public RTPFormats getFormats() {
        if (this.negotiated) {
            return this.negotiatedFormats;
        }
        return this.supportedFormats;
    }

    public RTPFormats getFormatMap() {
        return this.rtpChannel.getFormatMap();
    }

    public void enableICE(String externalAddress, boolean rtcpMux) {
        if (!this.ice) {
            this.ice = true;
            this.rtcpMux = rtcpMux;
            this.iceAuthenticator.generateIceCredentials();
            this.rtpChannel.enableIce((IceAuthenticator)this.iceAuthenticator);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " enabled ICE"));
            }
        }
    }

    public void disableICE() {
        if (this.ice) {
            this.ice = false;
            this.iceAuthenticator.reset();
            this.rtpChannel.disableIce();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " disabled ICE"));
            }
        }
    }

    public boolean isIceEnabled() {
        return this.ice;
    }

    public String getIceUfrag() {
        return this.ice ? this.iceAuthenticator.getUfrag() : "";
    }

    public String getIcePwd() {
        return this.ice ? this.iceAuthenticator.getPassword() : "";
    }

    public void enableDTLS(String hashFunction, String remoteFingerprint) {
        if (!this.dtls) {
            this.rtpChannel.enableSRTP(hashFunction, remoteFingerprint);
            this.rtcpChannel.enableSRTCP(hashFunction, remoteFingerprint);
            this.dtls = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " enabled DTLS"));
            }
        }
    }

    public void enableDTLS() {
        if (!this.dtls) {
            this.rtpChannel.enableSRTP();
            this.dtls = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " enabled DTLS"));
            }
        }
    }

    public void setRemoteFingerprint(String hashFunction, String fingerprint) {
        if (this.dtls) {
            this.rtpChannel.setRemoteFingerprint(hashFunction, fingerprint);
        }
    }

    public void disableDTLS() {
        if (this.dtls) {
            this.rtpChannel.disableSRTP();
            this.dtls = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " disabled DTLS"));
            }
        }
    }

    public boolean isDtlsEnabled() {
        return this.dtls;
    }

    public String getDtlsFingerprint() {
        if (this.dtls) {
            return this.rtpChannel.getWebRtcLocalFingerprint().toString();
        }
        return "";
    }

    public RtpChannel createRtpChannel(String originalHost, int originalPort) {
        this.rtcpChannel = new RtcpChannel();
        return new RtpChannel(originalHost, originalPort);
    }

    public RtcpChannel getRtcpChannel() {
        return this.rtcpChannel;
    }

    public RtpChannel getRtpChannel() {
        return this.rtpChannel;
    }

    public IceAuthenticator getIceAuthenticator() {
        return this.iceAuthenticator;
    }
}

