/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtcp.RtcpPacket;
import org.mobicents.media.server.impl.rtcp.RtcpPacketType;
import org.mobicents.media.server.io.network.channel.PacketHandlerException;
import org.restcomm.sbc.media.PacketHandler;
import org.restcomm.sbc.media.dtls.DtlsHandler;

public class RtcpHandler
implements PacketHandler {
    private static final Logger logger = Logger.getLogger(RtcpHandler.class);
    private static final long SSRC_TASK_DELAY = 7000L;
    private DatagramChannel channel;
    private ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8192);
    private long tp = 0L;
    private long tn = -1L;
    private AtomicBoolean initial = new AtomicBoolean(true);
    private AtomicBoolean joined = new AtomicBoolean(false);
    private boolean secure = false;
    private DtlsHandler dtlsHandler = null;

    public void setChannel(DatagramChannel channel) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Setting Channel connected? " + channel.isConnected()));
        }
        this.channel = channel;
    }

    public boolean isInitial() {
        return this.initial.get();
    }

    public boolean isJoined() {
        return this.joined.get();
    }

    public void enableSRTCP(DtlsHandler dtlsHandler) {
        this.dtlsHandler = dtlsHandler;
        this.secure = true;
    }

    public void disableSRTCP() {
        this.dtlsHandler = null;
        this.secure = false;
    }

    @Override
    public boolean canHandle(byte[] packet) {
        return this.canHandle(packet, packet.length, 0);
    }

    @Override
    public boolean canHandle(byte[] packet, int dataLength, int offset) {
        int padding;
        int type;
        int version;
        byte b0 = packet[offset];
        int b0Int = b0 & 0xFF;
        return b0Int > 127 && b0Int < 192 && (version = (b0 & 0xC0) >> 6) == 2 && ((type = packet[offset + 1] & 0xFF) == 200 || type == 201) && (padding = (packet[offset] & 0x20) >> 5) == 0;
    }

    @Override
    public byte[] handle(byte[] packet, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        return this.handle(packet, packet.length, 0, localPeer, remotePeer);
    }

    @Override
    public byte[] handle(byte[] packet, int dataLength, int offset, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        if (!this.joined.get()) {
            return null;
        }
        if (this.secure && !this.dtlsHandler.isHandshakeComplete()) {
            return null;
        }
        if (!this.canHandle(packet, dataLength, offset)) {
            logger.warn((Object)"Cannot handle incoming packet!");
            throw new PacketHandlerException("Cannot handle incoming packet");
        }
        RtcpPacket rtcpPacket = new RtcpPacket();
        if (this.secure) {
            byte[] decoded = this.dtlsHandler.decodeRTCP(packet, offset, dataLength);
            if (decoded == null || decoded.length == 0) {
                logger.warn((Object)"Could not decode incoming SRTCP packet. Packet will be dropped.");
                return null;
            }
            rtcpPacket.decode(decoded, 0);
        } else {
            rtcpPacket.decode(packet, offset);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\nRECEIVED " + rtcpPacket.toString()));
        }
        return null;
    }

    private void sendRtcpPacket(RtcpPacket packet) throws IOException {
        RtcpPacketType type;
        if (this.joined.get()) {
            return;
        }
        if (this.secure && !this.dtlsHandler.isHandshakeComplete()) {
            return;
        }
        RtcpPacketType rtcpPacketType = type = packet.hasBye() ? RtcpPacketType.RTCP_BYE : RtcpPacketType.RTCP_REPORT;
        if (this.channel != null && this.channel.isOpen() && this.channel.isConnected()) {
            byte[] data = new byte[8192];
            packet.encode(data, 0);
            int dataLength = packet.getSize();
            if (this.secure) {
                data = this.dtlsHandler.encodeRTCP(data, 0, dataLength);
                dataLength = data.length;
            }
            this.byteBuffer.clear();
            this.byteBuffer.rewind();
            this.byteBuffer.put(data, 0, dataLength);
            this.byteBuffer.flip();
            this.byteBuffer.rewind();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\nSENDING " + packet.toString()));
            }
            if (!this.channel.isOpen() || !this.channel.isConnected()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not send " + type + " packet because channel is closed or disconnected."));
                }
                return;
            }
            this.channel.send(this.byteBuffer, this.channel.getRemoteAddress());
            this.initial.set(false);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Could not send " + type + " packet because channel is closed or disconnected."));
        }
    }

    public synchronized void reset() {
        if (this.joined.get()) {
            throw new IllegalStateException("Cannot reset handler while is part of active RTP session.");
        }
        this.tp = 0L;
        this.tn = -1L;
        this.initial.set(true);
        this.joined.set(false);
        if (this.secure) {
            this.disableSRTCP();
        }
    }

    private void closeChannel() {
        if (this.channel != null) {
            if (this.channel.isConnected()) {
                try {
                    this.channel.disconnect();
                }
                catch (IOException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (this.channel.isOpen()) {
                try {
                    this.channel.close();
                }
                catch (IOException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public int compareTo(PacketHandler o) {
        if (o == null) {
            return 1;
        }
        return 0;
    }
}

