/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.Configuration;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.NotThreadSafe;
import org.restcomm.sbc.bo.Account;
import org.restcomm.sbc.bo.Connector;
import org.restcomm.sbc.bo.NetworkPoint;
import org.restcomm.sbc.bo.NetworkPointList;
import org.restcomm.sbc.bo.RestCommResponse;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.configuration.RestcommConfiguration;
import org.restcomm.sbc.dao.AccountsDao;
import org.restcomm.sbc.dao.ConnectorsDao;
import org.restcomm.sbc.dao.DaoManager;
import org.restcomm.sbc.dao.NetworkPointsDao;
import org.restcomm.sbc.managers.NetworkManager;
import org.restcomm.sbc.rest.SecuredEndpoint;
import org.restcomm.sbc.rest.converter.NetworkPointConverter;
import org.restcomm.sbc.rest.converter.NetworkPointListConverter;
import org.restcomm.sbc.rest.converter.RestCommResponseConverter;

@NotThreadSafe
public abstract class NetworkPointsEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected DaoManager daos;
    protected Gson gson;
    protected GsonBuilder builder;
    protected XStream xstream;
    protected AccountsDao accountsDao;
    protected String instanceId;
    protected NetworkPointListConverter listConverter;
    private static transient Logger LOG = Logger.getLogger(NetworkPointsEndpoint.class);

    @PostConstruct
    public void init() {
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        this.daos = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.accountsDao = this.daos.getAccountsDao();
        super.init(this.configuration);
        this.listConverter = new NetworkPointListConverter(this.configuration);
        NetworkPointConverter converter = new NetworkPointConverter(this.configuration);
        this.builder = new GsonBuilder();
        this.builder.registerTypeAdapter(NetworkPoint.class, (Object)converter);
        this.builder.registerTypeAdapter(NetworkPointList.class, (Object)this.listConverter);
        this.builder.setPrettyPrinting();
        this.gson = this.builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        this.xstream.registerConverter((Converter)this.listConverter);
        this.instanceId = RestcommConfiguration.getInstance().getMain().getInstanceId();
    }

    protected Response getNetworkPoint(String id, MediaType responseType) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Read:NetworkPoints");
        NetworkPointsDao dao = this.daos.getNetworkPointDao();
        NetworkPoint point = dao.getNetworkPoint(id);
        NetworkPoint realPoint = NetworkManager.getNetworkPoint(id);
        if (realPoint != null && point != null) {
            point.setMacAddress(realPoint.getMacAddress());
            point.setDescription(realPoint.getDescription());
        }
        if (point == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(account, account.getSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse(point);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)point), (String)"application/json").build();
        }
        return null;
    }

    protected Response deleteNetworkPoint(String id) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Delete:NetworkPoints", SecuredEndpoint.SecuredType.SECURED_ACCOUNT);
        NetworkPointsDao dao = this.daos.getNetworkPointDao();
        NetworkPoint point = dao.getNetworkPoint(id);
        if (point == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        dao.removeNetworkPoint(id);
        return Response.ok().build();
    }

    private NetworkPoint update(NetworkPoint point, MultivaluedMap<String, String> data) {
        NetworkPoint result = point;
        if (data.containsKey((Object)"Tag")) {
            result = result.setTag(NetworkPoint.Tag.getValueOf((String)data.getFirst((Object)"Tag")));
        }
        return result;
    }

    protected Response updateNetworkPoint(String id) {
        this.checkPermission("RestComm:Delete:NetworkPoints");
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Delete:NetworkPoints", SecuredEndpoint.SecuredType.SECURED_ACCOUNT);
        NetworkPointsDao dao = this.daos.getNetworkPointDao();
        NetworkPoint point = dao.getNetworkPoint(id);
        if (point == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        dao.updateNetworkPoint(point);
        return Response.ok().build();
    }

    protected Response updateNetworkPoint(String id, MultivaluedMap<String, String> data, MediaType responseType) {
        this.checkPermission("RestComm:Modify:NetworkPoints");
        Account account = this.userIdentityContext.getEffectiveAccount();
        if (account == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(account, "RestComm:Modify:NetworkPoints", SecuredEndpoint.SecuredType.SECURED_ACCOUNT);
        NetworkPointsDao dao = this.daos.getNetworkPointDao();
        NetworkPoint point = dao.getNetworkPoint(id);
        ConnectorsDao cdao = this.daos.getConnectorsDao();
        List<Connector> connectors = cdao.getConnectorsByNetworkPoint(point.getId());
        if (connectors.size() > 0) {
            LOG.error((Object)"Connector dependancies exists!, cannot update");
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        point = this.update(point, data);
        dao.updateNetworkPoint(point);
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)point), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse(point);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    protected Response getNetworkPoints(UriInfo info, MediaType responseType) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Read:NetworkPoints");
        List<NetworkPoint> points = NetworkManager.getPersistentNetworkPoints();
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse(new NetworkPointList(points));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)new NetworkPointList(points)), (String)"application/json").build();
        }
        return null;
    }

    private NetworkPoint createFrom(String accountSid, MultivaluedMap<String, String> data) {
        NetworkPoint.Builder builder = NetworkPoint.builder();
        builder.setAccountSid(new Sid(accountSid));
        String tag = (String)data.getFirst((Object)"Tag");
        builder.setTag(NetworkPoint.Tag.valueOf(tag));
        String id = (String)data.getFirst((Object)"Id");
        builder.setId(id);
        return builder.build();
    }

    protected Response putNetworkPoint(MultivaluedMap<String, String> data, MediaType responseType) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Modify:NetworkPoints");
        NetworkPointsDao dao = this.daos.getNetworkPointDao();
        try {
            this.validate(data);
        }
        catch (RuntimeException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        NetworkPoint point = this.createFrom(account.getSid().toString(), data);
        dao.addNetworkPoint(point);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse(point);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)point), (String)"application/json").build();
        }
        return null;
    }

    private void validate(MultivaluedMap<String, String> data) {
        if (!data.containsKey((Object)"Id")) {
            throw new NullPointerException("Id can not be null.");
        }
        if (!data.containsKey((Object)"Tag")) {
            throw new NullPointerException("Tag can not be null.");
        }
        String id = (String)data.getFirst((Object)"Id");
        if (!NetworkManager.exists(id)) {
            throw new NullPointerException("Real ID does not exist.");
        }
        NetworkPointsDao dao = this.daos.getNetworkPointDao();
        if (dao.getNetworkPoint(id) != null) {
            throw new PersistenceException("Id is yet taged");
        }
    }
}

