/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest;

import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleRole;
import org.apache.shiro.authz.permission.WildcardPermissionResolver;
import org.restcomm.sbc.bo.Account;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.dao.AccountsDao;
import org.restcomm.sbc.dao.DaoManager;
import org.restcomm.sbc.identity.AuthOutcome;
import org.restcomm.sbc.identity.IdentityContext;
import org.restcomm.sbc.identity.UserIdentityContext;
import org.restcomm.sbc.identity.shiro.RestcommRoles;
import org.restcomm.sbc.rest.AbstractEndpoint;
import org.restcomm.sbc.rest.exceptions.AuthorizationException;
import org.restcomm.sbc.rest.exceptions.InsufficientPermission;
import org.restcomm.sbc.rest.exceptions.NotAuthenticated;

public abstract class SecuredEndpoint
extends AbstractEndpoint {
    protected Logger logger = Logger.getLogger(SecuredEndpoint.class);
    protected UserIdentityContext userIdentityContext;
    protected AccountsDao accountsDao;
    protected IdentityContext identityContext;
    @Context
    protected ServletContext context;
    @Context
    HttpServletRequest request;

    @Override
    protected void init(Configuration configuration) {
        super.init(configuration);
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.accountsDao = storage.getAccountsDao();
        this.identityContext = (IdentityContext)this.context.getAttribute(IdentityContext.class.getName());
        this.userIdentityContext = new UserIdentityContext(this.request, this.accountsDao);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Request: " + this.request + " AC: " + this.accountsDao));
        }
    }

    protected void checkAuthenticatedAccount() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("UIC: " + this.userIdentityContext));
        }
        if (this.userIdentityContext.getEffectiveAccount() == null) {
            throw new NotAuthenticated();
        }
    }

    protected void checkPermission(String permission) {
        if (this.checkPermission(permission, this.userIdentityContext.getEffectiveAccountRoles()) != AuthOutcome.OK) {
            throw new InsufficientPermission();
        }
    }

    protected boolean isSecuredByPermission(String permission) {
        try {
            this.checkPermission(permission);
            return true;
        }
        catch (AuthorizationException e) {
            return false;
        }
    }

    protected void secure(Account operatedAccount, String permission) throws AuthorizationException {
        this.secure(operatedAccount, permission, SecuredType.SECURED_STANDARD);
    }

    protected void secure(Account operatedAccount, String permission, SecuredType type) throws AuthorizationException {
        this.checkAuthenticatedAccount();
        this.checkPermission(permission);
        if (operatedAccount == null) {
            throw new AuthorizationException();
        }
        if (type == SecuredType.SECURED_STANDARD ? this.secureLevelControl(this.userIdentityContext.getEffectiveAccount(), operatedAccount, null) != AuthOutcome.OK : (type == SecuredType.SECURED_APP ? this.secureLevelControlApplications(this.userIdentityContext.getEffectiveAccount(), operatedAccount, null) != AuthOutcome.OK : type == SecuredType.SECURED_ACCOUNT && this.secureLevelControlAccounts(this.userIdentityContext.getEffectiveAccount(), operatedAccount) != AuthOutcome.OK)) {
            throw new InsufficientPermission();
        }
    }

    protected void secure(Account operatedAccount, Sid resourceAccountSid, SecuredType type) throws AuthorizationException {
        String resourceAccountSidString;
        this.checkAuthenticatedAccount();
        String string = resourceAccountSidString = resourceAccountSid == null ? null : resourceAccountSid.toString();
        if (type == SecuredType.SECURED_APP) {
            if (this.secureLevelControlApplications(this.userIdentityContext.getEffectiveAccount(), operatedAccount, resourceAccountSidString) != AuthOutcome.OK) {
                throw new InsufficientPermission();
            }
        } else if (type == SecuredType.SECURED_STANDARD) {
            if (this.secureLevelControl(this.userIdentityContext.getEffectiveAccount(), operatedAccount, resourceAccountSidString) != AuthOutcome.OK) {
                throw new InsufficientPermission();
            }
        } else {
            if (type == SecuredType.SECURED_ACCOUNT) {
                throw new IllegalStateException("Account security is not supported when using sub-resources");
            }
            throw new NotImplementedException();
        }
    }

    protected boolean hasAccountRole(String role) {
        if (this.userIdentityContext.getEffectiveAccount() != null) {
            return this.userIdentityContext.getEffectiveAccountRoles().contains(role);
        }
        return false;
    }

    private AuthOutcome checkPermission(String neededPermissionString, Set<String> roleNames) {
        if (roleNames.contains(this.getAdministratorRole())) {
            return AuthOutcome.OK;
        }
        WildcardPermissionResolver resolver = new WildcardPermissionResolver();
        Permission neededPermission = resolver.resolvePermission(neededPermissionString);
        RestcommRoles restcommRoles = this.identityContext.getRestcommRoles();
        for (String roleName : roleNames) {
            SimpleRole simpleRole = restcommRoles.getRole(roleName);
            if (simpleRole == null) {
                return AuthOutcome.FAILED;
            }
            Set permissions = simpleRole.getPermissions();
            for (Permission permission : permissions) {
                if (!permission.implies(neededPermission)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Granted access by permission " + permission.toString()));
                }
                return AuthOutcome.OK;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Role " + roleName + " does not allow " + neededPermissionString));
        }
        return AuthOutcome.FAILED;
    }

    private AuthOutcome secureLevelControl(Account operatingAccount, Account operatedAccount, String resourceAccountSid) {
        String operatingAccountSid = null;
        if (operatingAccount != null) {
            operatingAccountSid = operatingAccount.getSid().toString();
        }
        String operatedAccountSid = null;
        if (operatedAccount != null) {
            operatedAccountSid = operatedAccount.getSid().toString();
        }
        if (!operatingAccountSid.equals(operatedAccountSid)) {
            Account account = this.accountsDao.getAccount(new Sid(operatedAccountSid));
            if (!operatingAccountSid.equals(String.valueOf(account.getAccountSid()))) {
                return AuthOutcome.FAILED;
            }
            if (resourceAccountSid != null && !operatedAccountSid.equals(resourceAccountSid)) {
                return AuthOutcome.FAILED;
            }
        } else if (resourceAccountSid != null && !operatingAccountSid.equals(resourceAccountSid)) {
            return AuthOutcome.FAILED;
        }
        return AuthOutcome.OK;
    }

    private AuthOutcome secureLevelControlApplications(Account operatingAccount, Account operatedAccount, String applicationAccountSid) {
        String operatingAccountSid = null;
        if (operatingAccount != null) {
            operatingAccountSid = operatingAccount.getSid().toString();
        }
        String operatedAccountSid = null;
        if (operatedAccount != null) {
            operatedAccountSid = operatedAccount.getSid().toString();
        }
        if (!operatingAccountSid.equals(String.valueOf(operatedAccountSid))) {
            return AuthOutcome.FAILED;
        }
        if (applicationAccountSid != null && !operatingAccountSid.equals(applicationAccountSid)) {
            return AuthOutcome.FAILED;
        }
        return AuthOutcome.OK;
    }

    private AuthOutcome secureLevelControlAccounts(Account operatingAccount, Account operatedAccount) {
        if (operatingAccount == null || operatedAccount == null) {
            return AuthOutcome.FAILED;
        }
        if (this.getAdministratorRole().equals(operatingAccount.getRole())) {
            if (!String.valueOf(operatingAccount.getSid()).equals(String.valueOf(operatedAccount.getSid())) && !String.valueOf(operatingAccount.getSid()).equals(String.valueOf(operatedAccount.getAccountSid()))) {
                return AuthOutcome.FAILED;
            }
        } else {
            if (operatingAccount.getSid().equals(operatedAccount.getSid())) {
                return AuthOutcome.OK;
            }
            return AuthOutcome.FAILED;
        }
        return AuthOutcome.OK;
    }

    protected String getAdministratorRole() {
        return "Administrator";
    }

    public static enum SecuredType {
        SECURED_APP,
        SECURED_ACCOUNT,
        SECURED_STANDARD;

    }
}

