/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.util.Template;

public class Redirector
extends Restlet {
    public static final int MODE_CLIENT_PERMANENT = 1;
    public static final int MODE_CLIENT_FOUND = 2;
    public static final int MODE_CLIENT_SEE_OTHER = 3;
    public static final int MODE_CLIENT_TEMPORARY = 4;
    public static final int MODE_DISPATCHER = 5;
    protected String targetTemplate;
    protected int mode;

    public Redirector(Context context, String targetTemplate) {
        this(context, targetTemplate, 5);
    }

    public Redirector(Context context, String targetPattern, int mode) {
        super(context);
        this.targetTemplate = targetPattern;
        this.mode = mode;
    }

    public void handle(Request request, Response response) {
        Reference targetRef = this.getTargetRef(request, response);
        switch (this.mode) {
            case 1: {
                this.getLogger().log(Level.INFO, "Permanently redirecting client to: " + targetRef);
                response.redirectPermanent(targetRef);
                break;
            }
            case 2: {
                this.getLogger().log(Level.INFO, "Redirecting client to found location: " + targetRef);
                response.setRedirectRef(targetRef);
                response.setStatus(Status.REDIRECTION_FOUND);
                break;
            }
            case 4: {
                this.getLogger().log(Level.INFO, "Temporarily redirecting client to: " + targetRef);
                response.redirectTemporary(targetRef);
                break;
            }
            case 5: {
                this.getLogger().log(Level.INFO, "Redirecting via client connector to: " + targetRef);
                this.redirectDispatcher(targetRef, request, response);
            }
        }
    }

    protected void redirectDispatcher(Reference targetRef, Request request, Response response) {
        request.setResourceRef(targetRef);
        request.getAttributes().remove("org.restlet.http.headers");
        this.getContext().getDispatcher().handle(request, response);
        response.setEntity(this.rewrite(response.getEntity()));
        response.getAttributes().remove("org.restlet.http.headers");
    }

    protected Reference getTargetRef(Request request, Response response) {
        Template rt = new Template(this.getLogger(), this.targetTemplate);
        return new Reference(rt.format(request, response));
    }

    protected Representation rewrite(Representation initialEntity) {
        return initialEntity;
    }
}

