/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ChallengeScheme {
    public static final ChallengeScheme CUSTOM = new ChallengeScheme("CUSTOM", "Custom", "Custom authentication");
    public static final ChallengeScheme FTP_PLAIN = new ChallengeScheme("FTP_PLAIN", "PLAIN", "Plain FTP authentication");
    public static final ChallengeScheme HTTP_AWS_IAM = new ChallengeScheme("HTTP_AWS_IAM", "AWS3", "Amazon IAM-based authentication");
    public static final ChallengeScheme HTTP_AWS_QUERY = new ChallengeScheme("HTTP_AWS_QUERY", "AWS_QUERY", "Amazon Query String authentication");
    public static final ChallengeScheme HTTP_AWS_S3 = new ChallengeScheme("HTTP_AWS_S3", "AWS", "Amazon S3 HTTP authentication");
    public static final ChallengeScheme HTTP_AZURE_SHAREDKEY = new ChallengeScheme("HTTP_AZURE_SHAREDKEY", "SharedKey", "Microsoft Azure Shared Key authorization (authentication)");
    public static final ChallengeScheme HTTP_AZURE_SHAREDKEY_LITE = new ChallengeScheme("HTTP_AZURE_SHAREDKEY_LITE", "SharedKeyLite", "Microsoft Azure Shared Key lite authorization (authentication)");
    public static final ChallengeScheme HTTP_BASIC = new ChallengeScheme("HTTP_BASIC", "Basic", "Basic HTTP authentication");
    public static final ChallengeScheme HTTP_COOKIE = new ChallengeScheme("HTTP_Cookie", "Cookie", "Cookie HTTP authentication");
    public static final ChallengeScheme HTTP_DIGEST = new ChallengeScheme("HTTP_DIGEST", "Digest", "Digest HTTP authentication");
    public static final ChallengeScheme HTTP_NTLM = new ChallengeScheme("HTTP_NTLM", "NTLM", "Microsoft NTLM HTTP authentication");
    public static final ChallengeScheme HTTP_OAUTH = new ChallengeScheme("HTTP_OAuth", "OAuth", "OAuth 1.0 authentication");
    public static final ChallengeScheme HTTP_OAUTH_BEARER = new ChallengeScheme("HTTP_Bearer", "Bearer", "OAuth 2.0 bearer token authentication");
    public static final ChallengeScheme HTTP_OAUTH_MAC = new ChallengeScheme("HTTP_MAC", "Mac", "OAuth 2.0 message authentication code authentication");
    private static Map<String, ChallengeScheme> SCHEMES;
    private final String description;
    private final String name;
    private volatile String technicalName;

    public static ChallengeScheme valueOf(String name) {
        if (name == null) {
            throw new IllegalArgumentException("ChallengeScheme.valueOf(name) name must not be null");
        }
        ChallengeScheme result = SCHEMES.get(name.toLowerCase());
        if (result == null) {
            result = new ChallengeScheme(name, null, null);
        }
        return result;
    }

    public ChallengeScheme(String name, String technicalName) {
        this(name, technicalName, null);
    }

    public ChallengeScheme(String name, String technicalName, String description) {
        this.name = name;
        this.description = description;
        this.technicalName = technicalName;
    }

    public boolean equals(Object object) {
        return object instanceof ChallengeScheme && ((ChallengeScheme)object).getName().equalsIgnoreCase(this.getName());
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getTechnicalName() {
        return this.technicalName;
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().toLowerCase().hashCode();
    }

    private void setTechnicalName(String technicalName) {
        this.technicalName = technicalName;
    }

    public String toString() {
        return this.getName();
    }

    static {
        HashMap<String, ChallengeScheme> schemes = new HashMap<String, ChallengeScheme>();
        schemes.put(CUSTOM.getName().toLowerCase(), CUSTOM);
        schemes.put(FTP_PLAIN.getName().toLowerCase(), FTP_PLAIN);
        schemes.put(HTTP_AWS_IAM.getName().toLowerCase(), HTTP_AWS_S3);
        schemes.put(HTTP_AWS_QUERY.getName().toLowerCase(), HTTP_AWS_S3);
        schemes.put(HTTP_AWS_S3.getName().toLowerCase(), HTTP_AWS_S3);
        schemes.put(HTTP_AZURE_SHAREDKEY.getName().toLowerCase(), HTTP_AZURE_SHAREDKEY);
        schemes.put(HTTP_AZURE_SHAREDKEY_LITE.getName().toLowerCase(), HTTP_AZURE_SHAREDKEY_LITE);
        schemes.put(HTTP_BASIC.getName().toLowerCase(), HTTP_BASIC);
        schemes.put(HTTP_COOKIE.getName().toLowerCase(), HTTP_COOKIE);
        schemes.put(HTTP_DIGEST.getName().toLowerCase(), HTTP_DIGEST);
        schemes.put(HTTP_NTLM.getName().toLowerCase(), HTTP_NTLM);
        schemes.put(HTTP_OAUTH.getName().toLowerCase(), HTTP_OAUTH);
        schemes.put(HTTP_OAUTH_BEARER.getName().toLowerCase(), HTTP_OAUTH);
        schemes.put(HTTP_OAUTH_MAC.getName().toLowerCase(), HTTP_OAUTH);
        SCHEMES = Collections.unmodifiableMap(schemes);
    }
}

