/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.converter;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.Engine;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;

public class ConverterUtils {
    public static ConverterHelper getBestHelper(Object source, Variant target, Resource resource) {
        ConverterHelper result = null;
        float bestScore = -1.0f;
        for (ConverterHelper ch : Engine.getInstance().getRegisteredConverters()) {
            if (ch == null) continue;
            try {
                float currentScore = ch.score(source, target, resource);
                if (!(currentScore > bestScore)) continue;
                bestScore = currentScore;
                result = ch;
            }
            catch (Exception e) {
                Context.getCurrentLogger().log(Level.SEVERE, "Unable get the score of the " + String.valueOf(ch) + " converter helper.", e);
            }
        }
        return result;
    }

    public static <T> ConverterHelper getBestHelper(Representation source, Class<T> target, Resource resource) {
        ConverterHelper result = null;
        float bestScore = -1.0f;
        for (ConverterHelper ch : Engine.getInstance().getRegisteredConverters()) {
            float currentScore;
            if (ch == null || !((currentScore = ch.score(source, target, resource)) > bestScore)) continue;
            bestScore = currentScore;
            result = ch;
        }
        return result;
    }

    public static List<VariantInfo> getVariants(Class<?> sourceClass, Variant targetVariant) {
        List<VariantInfo> result = null;
        for (ConverterHelper ch : Engine.getInstance().getRegisteredConverters()) {
            if (ch == null) continue;
            try {
                result = ch.addVariants(sourceClass, targetVariant, result);
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.FINE, "Unable get the variants of the " + String.valueOf(ch) + " converter helper.", e);
            }
        }
        return result;
    }

    private ConverterUtils() {
    }
}

