/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.local;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.restlet.data.MediaType;
import org.restlet.engine.local.Entity;
import org.restlet.engine.local.ZipEntryRepresentation;
import org.restlet.representation.Representation;
import org.restlet.service.MetadataService;

public class ZipEntryEntity
extends Entity {
    protected final ZipEntry entry;
    protected final ZipFile zipFile;

    public ZipEntryEntity(ZipFile zipFile, String entryName, MetadataService metadataService) {
        super(metadataService);
        ZipEntry entryDir;
        this.zipFile = zipFile;
        ZipEntry entry = zipFile.getEntry(entryName);
        this.entry = entry == null ? new ZipEntry(entryName) : ((entryDir = zipFile.getEntry(entryName + "/")) != null ? entryDir : entry);
    }

    public ZipEntryEntity(ZipFile zipFile, ZipEntry entry, MetadataService metadataService) {
        super(metadataService);
        this.zipFile = zipFile;
        this.entry = entry;
    }

    @Override
    public boolean exists() {
        if ("".equals(this.getName())) {
            return true;
        }
        return this.entry.getSize() != -1L;
    }

    @Override
    public List<Entity> getChildren() {
        ArrayList<ZipEntryEntity> result = null;
        if (this.isDirectory()) {
            result = new ArrayList<ZipEntryEntity>();
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            String n = this.entry.getName();
            while (entries.hasMoreElements()) {
                ZipEntry e = entries.nextElement();
                if (!e.getName().startsWith(n) || e.getName().length() == n.length()) continue;
                result.add(new ZipEntryEntity(this.zipFile, e, this.getMetadataService()));
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return this.entry.getName();
    }

    @Override
    public Entity getParent() {
        if (this.entry.getName().isEmpty()) {
            return null;
        }
        String n = this.entry.getName();
        String pn = n.substring(0, n.lastIndexOf(47) + 1);
        return new ZipEntryEntity(this.zipFile, this.zipFile.getEntry(pn), this.getMetadataService());
    }

    @Override
    public Representation getRepresentation(MediaType defaultMediaType, int timeToLive) {
        return new ZipEntryRepresentation(defaultMediaType, this.zipFile, this.entry, timeToLive);
    }

    @Override
    public boolean isDirectory() {
        if (this.entry.getName().isEmpty()) {
            return true;
        }
        return this.entry.isDirectory();
    }

    @Override
    public boolean isNormal() {
        return !this.entry.isDirectory();
    }
}

