/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.CacheDirective;
import org.restlet.data.Header;
import org.restlet.data.MediaType;
import org.restlet.data.RecipientInfo;
import org.restlet.data.Warning;
import org.restlet.representation.BufferingRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.util.Series;

public abstract class Message {
    private volatile ConcurrentMap<String, Object> attributes = null;
    private volatile List<CacheDirective> cacheDirectives = null;
    private volatile Date date = null;
    private volatile Representation entity;
    private volatile String entityText;
    private volatile Uniform onError;
    private volatile Uniform onSent;
    private volatile List<RecipientInfo> recipientsInfo;
    private volatile List<Warning> warnings;

    public Message() {
        this(null);
    }

    public Message(Representation entity) {
        this.entity = entity;
        this.entityText = null;
        this.onSent = null;
        this.recipientsInfo = null;
        this.warnings = null;
    }

    public void bufferEntity() {
        if (this.getEntity() != null && (this.getEntity().isTransient() || this.getEntity().getSize() == -1L) && this.getEntity().isAvailable()) {
            this.setEntity(new BufferingRepresentation(this.getEntity()));
        }
    }

    public void flushBuffers() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentMap<String, Object> getAttributes() {
        ConcurrentMap<String, Object> r = this.attributes;
        if (r == null) {
            Message message = this;
            synchronized (message) {
                r = this.attributes;
                if (r == null) {
                    this.attributes = r = new ConcurrentHashMap<String, Object>();
                }
            }
        }
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CacheDirective> getCacheDirectives() {
        List<CacheDirective> r = this.cacheDirectives;
        if (r == null) {
            Message message = this;
            synchronized (message) {
                r = this.cacheDirectives;
                if (r == null) {
                    this.cacheDirectives = r = new CopyOnWriteArrayList<CacheDirective>();
                }
            }
        }
        return r;
    }

    public Date getDate() {
        return this.date;
    }

    public Representation getEntity() {
        return this.entity;
    }

    public String getEntityAsText() {
        if (this.entityText == null) {
            try {
                this.entityText = this.getEntity() == null ? null : this.getEntity().getText();
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.FINE, "Unable to get the entity text.", e);
            }
        }
        return this.entityText;
    }

    public Series<Header> getHeaders() {
        Series<Header> headers = (Series<Header>)this.getAttributes().get("org.restlet.http.headers");
        if (headers == null) {
            headers = new Series<Header>(Header.class);
            this.getAttributes().put("org.restlet.http.headers", headers);
        }
        return headers;
    }

    public Uniform getOnError() {
        return this.onError;
    }

    public Uniform getOnSent() {
        return this.onSent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecipientInfo> getRecipientsInfo() {
        List<RecipientInfo> r = this.recipientsInfo;
        if (r == null) {
            Message message = this;
            synchronized (message) {
                r = this.recipientsInfo;
                if (r == null) {
                    this.recipientsInfo = r = new CopyOnWriteArrayList<RecipientInfo>();
                }
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Warning> getWarnings() {
        List<Warning> r = this.warnings;
        if (r == null) {
            Message message = this;
            synchronized (message) {
                r = this.warnings;
                if (r == null) {
                    this.warnings = r = new CopyOnWriteArrayList<Warning>();
                }
            }
        }
        return r;
    }

    public abstract boolean isConfidential();

    public boolean isEntityAvailable() {
        return this.getEntity() != null && this.getEntity().isAvailable();
    }

    public void release() {
        if (this.getEntity() != null) {
            this.getEntity().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Map<String, Object> attributes) {
        ConcurrentMap<String, Object> concurrentMap = this.getAttributes();
        synchronized (concurrentMap) {
            if (attributes != this.getAttributes()) {
                this.getAttributes().clear();
                if (attributes != null) {
                    this.getAttributes().putAll(attributes);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheDirectives(List<CacheDirective> cacheDirectives) {
        List<CacheDirective> list = this.getCacheDirectives();
        synchronized (list) {
            if (cacheDirectives != this.getCacheDirectives()) {
                this.getCacheDirectives().clear();
                if (cacheDirectives != null) {
                    this.getCacheDirectives().addAll(cacheDirectives);
                }
            }
        }
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setEntity(Representation entity) {
        this.entity = entity;
    }

    public void setEntity(String value, MediaType mediaType) {
        this.setEntity(new StringRepresentation((CharSequence)value, mediaType));
    }

    public void setOnError(Uniform onError) {
        this.onError = onError;
    }

    public void setOnSent(Uniform onSentCallback) {
        this.onSent = onSentCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecipientsInfo(List<RecipientInfo> recipientsInfo) {
        List<RecipientInfo> list = this.getRecipientsInfo();
        synchronized (list) {
            if (recipientsInfo != this.getRecipientsInfo()) {
                this.getRecipientsInfo().clear();
                if (recipientsInfo != null) {
                    this.getRecipientsInfo().addAll(recipientsInfo);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWarnings(List<Warning> warnings) {
        List<Warning> list = this.getWarnings();
        synchronized (list) {
            if (warnings != this.getWarnings()) {
                this.getWarnings().clear();
                if (warnings != null) {
                    this.getWarnings().addAll(warnings);
                }
            }
        }
    }
}

