/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.art;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.roaringbitmap.art.Node;
import org.roaringbitmap.art.Node48;
import org.roaringbitmap.art.NodeType;

public class Node256
extends Node {
    Node[] children = new Node[256];
    long[] bitmapMask = new long[4];
    private static final long LONG_MASK = -1L;

    public Node256(int compressedPrefixSize) {
        super(NodeType.NODE256, compressedPrefixSize);
    }

    @Override
    public int getChildPos(byte k) {
        int pos = Byte.toUnsignedInt(k);
        if (this.children[pos] != null) {
            return pos;
        }
        return -1;
    }

    @Override
    public byte getChildKey(int pos) {
        return (byte)pos;
    }

    @Override
    public Node getChild(int pos) {
        return this.children[pos];
    }

    @Override
    public void replaceNode(int pos, Node freshOne) {
        this.children[pos] = freshOne;
    }

    @Override
    public int getMinPos() {
        for (int i = 0; i < 4; ++i) {
            long longVal = this.bitmapMask[i];
            int v = Long.numberOfTrailingZeros(longVal);
            if (v == 64) continue;
            int res = i * 64 + v;
            return res;
        }
        return -1;
    }

    @Override
    public int getNextLargerPos(int pos) {
        pos = pos == -1 ? 0 : ++pos;
        int longPos = pos >> 6;
        if (longPos >= 4) {
            return -1;
        }
        long longVal = this.bitmapMask[longPos] & -1L << pos;
        while (longVal == 0L) {
            if (++longPos == 4) {
                return -1;
            }
            longVal = this.bitmapMask[longPos];
        }
        return longPos * 64 + Long.numberOfTrailingZeros(longVal);
    }

    @Override
    public int getMaxPos() {
        for (int i = 3; i >= 0; --i) {
            long longVal = this.bitmapMask[i];
            int v = Long.numberOfLeadingZeros(longVal);
            if (v == 64) continue;
            int res = i * 64 + (63 - v);
            return res;
        }
        return -1;
    }

    @Override
    public int getNextSmallerPos(int pos) {
        if (pos == -1) {
            pos = 256;
        }
        if (pos == 0) {
            return -1;
        }
        int longPos = --pos >>> 6;
        long longVal = this.bitmapMask[longPos] & -1L >>> -(pos + 1);
        while (longVal == 0L) {
            if (longPos-- == 0) {
                return -1;
            }
            longVal = this.bitmapMask[longPos];
        }
        return (longPos + 1) * 64 - 1 - Long.numberOfLeadingZeros(longVal);
    }

    public static Node256 insert(Node currentNode, Node child, byte key) {
        Node256 node256 = (Node256)currentNode;
        node256.count = (short)(node256.count + 1);
        int i = Byte.toUnsignedInt(key);
        node256.children[i] = child;
        Node256.setBit(key, node256.bitmapMask);
        return node256;
    }

    static void setBit(byte key, long[] bitmapMask) {
        long newVal;
        int i = Byte.toUnsignedInt(key);
        int longIdx = i >>> 6;
        long previous = bitmapMask[longIdx];
        bitmapMask[longIdx] = newVal = previous | 1L << i;
    }

    @Override
    public Node remove(int pos) {
        int longPos;
        this.children[pos] = null;
        int n = longPos = pos >>> 6;
        this.bitmapMask[n] = this.bitmapMask[n] & (1L << pos ^ 0xFFFFFFFFFFFFFFFFL);
        this.count = (short)(this.count - 1);
        if (this.count <= 36) {
            Node48 node48 = new Node48(this.prefixLength);
            int j = 0;
            int currentPos = -1;
            while ((currentPos = this.getNextLargerPos(currentPos)) != -1) {
                Node child;
                node48.children[j] = child = this.getChild(currentPos);
                Node48.setOneByte(currentPos, (byte)j, node48.childIndex);
                ++j;
            }
            node48.count = (short)j;
            Node256.copyPrefix(this, node48);
            return node48;
        }
        return this;
    }

    @Override
    public void replaceChildren(Node[] children) {
        if (children.length == this.children.length) {
            this.children = children;
            return;
        }
        int offset = 0;
        int x = 0;
        for (long longv : this.bitmapMask) {
            int w = Long.bitCount(longv);
            for (int i = 0; i < w; ++i) {
                int pos = x * 64 + Long.numberOfTrailingZeros(longv);
                this.children[pos] = children[offset + i];
                longv &= longv - 1L;
            }
            offset += w;
            ++x;
        }
    }

    @Override
    public void serializeNodeBody(DataOutput dataOutput) throws IOException {
        for (long longv : this.bitmapMask) {
            dataOutput.writeLong(Long.reverseBytes(longv));
        }
    }

    @Override
    public void serializeNodeBody(ByteBuffer byteBuffer) throws IOException {
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        longBuffer.put(this.bitmapMask);
        byteBuffer.position(byteBuffer.position() + 32);
    }

    @Override
    public void deserializeNodeBody(DataInput dataInput) throws IOException {
        for (int i = 0; i < 4; ++i) {
            long longv;
            this.bitmapMask[i] = longv = Long.reverseBytes(dataInput.readLong());
        }
    }

    @Override
    public void deserializeNodeBody(ByteBuffer byteBuffer) throws IOException {
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        longBuffer.get(this.bitmapMask);
        byteBuffer.position(byteBuffer.position() + 32);
    }

    @Override
    public int serializeNodeBodySizeInBytes() {
        return 32;
    }
}

