/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationRegistry {
    public static ConfigurationRegistry instance;
    private final Map<String, Object> configurations = new HashMap<String, Object>();

    public static <T> T get(Class<T> configClass) {
        return instance.getInSandboxClassLoader(configClass);
    }

    public ConfigurationRegistry(Map<Class<?>, Object> configClassMap) {
        for (Class<?> classInParentLoader : configClassMap.keySet()) {
            Object configInParentLoader = configClassMap.get(classInParentLoader);
            this.configurations.put(classInParentLoader.getName(), configInParentLoader);
        }
    }

    private <T> T getInSandboxClassLoader(Class<T> someConfigClass) {
        Object configInParentLoader = this.configurations.get(someConfigClass.getName());
        Object configInSandboxLoader = ConfigurationRegistry.reloadInSandboxClassLoader(configInParentLoader);
        return someConfigClass.cast(configInSandboxLoader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object reloadInSandboxClassLoader(Object configInParentLoader) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(buf);){
            out.writeObject(configInParentLoader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] bytes = buf.toByteArray();
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Object object = in.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

