/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.storage.conf;

import java.util.Set;
import org.rundeck.storage.api.ContentMeta;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.api.PathSelector;
import org.rundeck.storage.api.Resource;
import org.rundeck.storage.api.ResourceSelector;
import org.rundeck.storage.api.Tree;
import org.rundeck.storage.conf.Listener;
import org.rundeck.storage.conf.MatcherUtil;
import org.rundeck.storage.impl.DelegateTree;

public class ListenerTree<T extends ContentMeta>
extends DelegateTree<T> {
    Listener<T> listener;
    PathSelector pathSelector;
    ResourceSelector<T> resourceSelector;

    public ListenerTree(Tree<T> delegate, Listener<T> listener, PathSelector pathSelector) {
        super(delegate);
        this.listener = listener;
        this.pathSelector = pathSelector;
    }

    public ListenerTree(Tree<T> delegate, Listener<T> listener, ResourceSelector<T> resourceSelector) {
        super(delegate);
        this.listener = listener;
        this.resourceSelector = resourceSelector;
    }

    public ListenerTree(Tree<T> delegate, Listener<T> listener, PathSelector pathSelector, ResourceSelector<T> resourceSelector) {
        super(delegate);
        this.listener = listener;
        this.pathSelector = pathSelector;
        this.resourceSelector = resourceSelector;
    }

    public Resource<T> getPath(Path path) {
        Resource path1 = super.getPath(path);
        if (this.matches(path, null != path1 ? path1.getContents() : null)) {
            this.listener.didGetPath(path, path1);
        }
        return path1;
    }

    private boolean matches(Path path, T content) {
        return MatcherUtil.matches(path, content, this.pathSelector, true, this.resourceSelector, true);
    }

    public Resource<T> getResource(Path path) {
        Resource resource = super.getResource(path);
        if (this.matches(path, resource.getContents())) {
            this.listener.didGetResource(path, resource);
        }
        return resource;
    }

    public Set<Resource<T>> listDirectorySubdirs(Path path) {
        Set resources = super.listDirectorySubdirs(path);
        if (this.matches(path, null)) {
            this.listener.didListDirectorySubdirs(path, resources);
        }
        return resources;
    }

    public Set<Resource<T>> listDirectoryResources(Path path) {
        Set resources = super.listDirectoryResources(path);
        if (this.matches(path, null)) {
            this.listener.didListDirectoryResources(path, resources);
        }
        return resources;
    }

    public Set<Resource<T>> listDirectory(Path path) {
        Set resources = super.listDirectory(path);
        if (this.matches(path, null)) {
            this.listener.didListDirectory(path, resources);
        }
        return resources;
    }

    public boolean deleteResource(Path path) {
        boolean b = super.deleteResource(path);
        if (this.matches(path, null)) {
            this.listener.didDeleteResource(path, b);
        }
        return b;
    }

    public Resource<T> createResource(Path path, T content) {
        Resource resource = super.createResource(path, content);
        if (this.matches(path, content)) {
            this.listener.didCreateResource(path, content, resource);
        }
        return resource;
    }

    public Resource<T> updateResource(Path path, T content) {
        Resource tResource = super.updateResource(path, content);
        if (this.matches(path, content)) {
            this.listener.didUpdateResource(path, content, tResource);
        }
        return tResource;
    }
}

