/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.nio;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import sbt.internal.io.NewWatchState;
import sbt.internal.nio.FileCache;
import sbt.internal.nio.FileEvent;
import sbt.internal.nio.FileEvent$Creation$;
import sbt.internal.nio.FileEvent$Deletion$;
import sbt.internal.nio.Observable;
import sbt.internal.nio.Observer;
import sbt.internal.nio.Observers;
import sbt.internal.nio.Registerable;
import sbt.internal.nio.TimeSource$default$;
import sbt.internal.nio.WatchLogger;
import sbt.internal.nio.WatchServiceBackedObservable$;
import sbt.nio.file.AnyPath$;
import sbt.nio.file.FileAttributes;
import sbt.nio.file.FileAttributes$;
import sbt.nio.file.FileAttributes$NonExistent$;
import sbt.nio.file.FileTreeView;
import sbt.nio.file.FileTreeView$;
import sbt.nio.file.FileTreeView$Ops$;
import sbt.nio.file.Glob;
import sbt.nio.file.Glob$;
import sbt.nio.file.Glob$GlobOps$;
import sbt.nio.file.Glob$RelativeGlobViewOption$;
import sbt.nio.file.RecursiveGlob$;
import sbt.nio.file.RelativeGlob;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005]sA\u0002\u000b\u0016\u0011\u0003I2D\u0002\u0004\u001e+!\u0005\u0011D\b\u0005\u0006K\u0005!\ta\n\u0005\bQ\u0005\u0011\r\u0011\"\u0003*\u0011\u00191\u0014\u0001)A\u0005U\u0019)Q$\u0006\u0001\u001ao!Aa*\u0002B\u0001B\u0003%q\n\u0003\u0005V\u000b\t\u0005\t\u0015!\u0003W\u0011!iVA!A!\u0002\u0013q\u0006\u0002C1\u0006\u0005\u0003\u0005\u000b\u0011\u00022\t\u000b\u0015*A\u0011A3\u0006\r-,\u0001\u0015!\u0003B\u0011\u0019aW\u0001)A\u0005[\"1\u0001/\u0002Q\u0001\nEDa\u0001^\u0003!\u0002\u0013)\bB\u0002=\u0006A\u0003%\u0011\u0010\u0003\u0005\u0002\u0002\u0015\u0001\u000b\u0011BA\u0002\u0011\u001d\tI!\u0002C!\u0003\u0017Aq!!\b\u0006\t\u0003\ny\u0002C\u0004\u0002(\u0015!\t%!\u000b\u00029]\u000bGo\u00195TKJ4\u0018nY3CC\u000e\\W\rZ(cg\u0016\u0014h/\u00192mK*\u0011acF\u0001\u0004]&|'B\u0001\r\u001a\u0003!Ig\u000e^3s]\u0006d'\"\u0001\u000e\u0002\u0007M\u0014G\u000f\u0005\u0002\u001d\u00035\tQC\u0001\u000fXCR\u001c\u0007nU3sm&\u001cWMQ1dW\u0016$wJY:feZ\f'\r\\3\u0014\u0005\u0005y\u0002C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005Y\u0012!D3wK:$H\u000b\u001b:fC\u0012LE-F\u0001+!\tYC'D\u0001-\u0015\tic&\u0001\u0004bi>l\u0017n\u0019\u0006\u0003_A\n!bY8oGV\u0014(/\u001a8u\u0015\t\t$'\u0001\u0003vi&d'\"A\u001a\u0002\t)\fg/Y\u0005\u0003k1\u0012Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018AD3wK:$H\u000b\u001b:fC\u0012LE\rI\n\u0005\u000bar4\n\u0005\u0002:y5\t!H\u0003\u0002<e\u0005!A.\u00198h\u0013\ti$H\u0001\u0004PE*,7\r\u001e\t\u00049}\n\u0015B\u0001!\u0016\u00051\u0011VmZ5ti\u0016\u0014\u0018M\u00197f!\ra\"\tR\u0005\u0003\u0007V\u0011\u0011BR5mK\u00163XM\u001c;\u0011\u0005\u0015KU\"\u0001$\u000b\u0005\u001dC\u0015\u0001\u00024jY\u0016T!AF\r\n\u0005)3%A\u0004$jY\u0016\fE\u000f\u001e:jEV$Xm\u001d\t\u000491\u000b\u0015BA'\u0016\u0005)y%m]3sm\u0006\u0014G.Z\u0001\u0002gB\u0011\u0001kU\u0007\u0002#*\u0011!kF\u0001\u0003S>L!\u0001V)\u0003\u001b9+woV1uG\"\u001cF/\u0019;f\u0003\u0015!W\r\\1z!\t96,D\u0001Y\u0015\tI&,\u0001\u0005ekJ\fG/[8o\u0015\ty\u0013%\u0003\u0002]1\nqa)\u001b8ji\u0016$UO]1uS>t\u0017\u0001D2m_N,7+\u001a:wS\u000e,\u0007C\u0001\u0011`\u0013\t\u0001\u0017EA\u0004C_>dW-\u00198\u0002\r1|wmZ3s!\ta2-\u0003\u0002e+\tYq+\u0019;dQ2{wmZ3s)\u00151w\r[5k!\taR\u0001C\u0003O\u0015\u0001\u0007q\nC\u0003V\u0015\u0001\u0007a\u000bC\u0003^\u0015\u0001\u0007a\fC\u0003b\u0015\u0001\u0007!MA\u0003Fm\u0016tG/\u0001\u0004dY>\u001cX\r\u001a\t\u0003W9L!a\u001c\u0017\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003%y'm]3sm\u0016\u00148\u000fE\u0002\u001de\u0006K!a]\u000b\u0003\u0013=\u00137/\u001a:wKJ\u001c\u0018!\u00034jY\u0016\u001c\u0015m\u00195f!\rab\u000fR\u0005\u0003oV\u0011\u0011BR5mK\u000e\u000b7\r[3\u0002\tYLWm\u001e\t\u0004uv$eBA#|\u0013\tah)\u0001\u0007GS2,GK]3f-&,w/\u0003\u0002\u007f\u007f\n\u0019a*[8\u000b\u0005q4\u0015A\u0002;ie\u0016\fG\rE\u0002:\u0003\u000bI1!a\u0002;\u0005\u0019!\u0006N]3bI\u0006Y\u0011\r\u001a3PEN,'O^3s)\u0011\ti!a\u0005\u0011\u0007e\ny!C\u0002\u0002\u0012i\u0012Q\"Q;u_\u000ecwn]3bE2,\u0007bBA\u000b#\u0001\u0007\u0011qC\u0001\t_\n\u001cXM\u001d<feB!A$!\u0007B\u0013\r\tY\"\u0006\u0002\t\u001f\n\u001cXM\u001d<fe\u0006)1\r\\8tKR\u0011\u0011\u0011\u0005\t\u0004A\u0005\r\u0012bAA\u0013C\t!QK\\5u\u0003!\u0011XmZ5ti\u0016\u0014H\u0003BA\u0016\u0003\u001b\u0002r!!\f\u0002>\u0005\r3J\u0004\u0003\u00020\u0005eb\u0002BA\u0019\u0003oi!!a\r\u000b\u0007\u0005Ub%\u0001\u0004=e>|GOP\u0005\u0002E%\u0019\u00111H\u0011\u0002\u000fA\f7m[1hK&!\u0011qHA!\u0005\u0019)\u0015\u000e\u001e5fe*\u0019\u00111H\u0011\u0011\t\u0005\u0015\u0013\u0011J\u0007\u0003\u0003\u000fR!A\u0015\u001a\n\t\u0005-\u0013q\t\u0002\f\u0013>+\u0005pY3qi&|g\u000eC\u0004\u0002PM\u0001\r!!\u0015\u0002\t\u001ddwN\u0019\t\u0004\u000b\u0006M\u0013bAA+\r\n!q\t\\8c\u0001")
public class WatchServiceBackedObservable
implements Registerable<FileEvent<FileAttributes>>,
Observable<FileEvent<FileAttributes>> {
    public final NewWatchState sbt$internal$nio$WatchServiceBackedObservable$$s;
    public final FiniteDuration sbt$internal$nio$WatchServiceBackedObservable$$delay;
    private final boolean closeService;
    public final WatchLogger sbt$internal$nio$WatchServiceBackedObservable$$logger;
    public final AtomicBoolean sbt$internal$nio$WatchServiceBackedObservable$$closed;
    public final Observers<FileEvent<FileAttributes>> sbt$internal$nio$WatchServiceBackedObservable$$observers;
    public final FileCache<FileAttributes> sbt$internal$nio$WatchServiceBackedObservable$$fileCache;
    public final FileTreeView<Tuple2<Path, FileAttributes>> sbt$internal$nio$WatchServiceBackedObservable$$view;
    private final Thread thread;

    @Override
    public AutoCloseable addObserver(Observer<FileEvent<FileAttributes>> observer) {
        return this.sbt$internal$nio$WatchServiceBackedObservable$$observers.addObserver(observer);
    }

    @Override
    public void close() {
        block1: {
            if (!this.sbt$internal$nio$WatchServiceBackedObservable$$closed.compareAndSet(false, true)) break block1;
            this.thread.interrupt();
            this.thread.join(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds().toMillis());
            if (this.closeService) {
                this.sbt$internal$nio$WatchServiceBackedObservable$$s.service().close();
            }
            this.sbt$internal$nio$WatchServiceBackedObservable$$logger.debug("Closed WatchServiceBackedObservable");
        }
    }

    @Override
    public Either<IOException, Observable<FileEvent<FileAttributes>>> register(Glob glob) {
        Left left;
        try {
            Glob glob2;
            this.sbt$internal$nio$WatchServiceBackedObservable$$fileCache.register(glob);
            int n = Glob$GlobOps$.MODULE$.range$extension(Glob$.MODULE$.GlobOps(glob))._2$mcI$sp();
            switch (n) {
                case 0x7FFFFFFF: {
                    glob2 = Glob$.MODULE$.apply(Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(glob), Glob$RelativeGlobViewOption$.MODULE$.default()), (RelativeGlob)RecursiveGlob$.MODULE$);
                    break;
                }
                default: {
                    glob2 = (Glob)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), n).foldLeft((Object)Glob$.MODULE$.apply(Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(glob), Glob$RelativeGlobViewOption$.MODULE$.default())), (Function2 & Serializable)(x0$1, x1$1) -> WatchServiceBackedObservable.$anonfun$register$1(x0$1, BoxesRunTime.unboxToInt((Object)x1$1)));
                    break;
                }
            }
            Glob updatedGlob = glob2;
            this.sbt$internal$nio$WatchServiceBackedObservable$$fileCache.list(updatedGlob).foreach((Function1 & Serializable)x0$2 -> {
                void var2_7;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    Path path = (Path)tuple2._1();
                    FileAttributes attrs = (FileAttributes)tuple2._2();
                    if (attrs.isDirectory()) {
                        WatchKey watchKey = $this.sbt$internal$nio$WatchServiceBackedObservable$$s.register(path);
                        return var2_7;
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return var2_7;
            });
            Observers<FileEvent<FileAttributes>> observable = new Observers<FileEvent<FileAttributes>>(null, glob){
                private final Glob glob$1;

                public void onNext(FileEvent<FileAttributes> t) {
                    block0: {
                        if (!this.glob$1.matches(t.path())) break block0;
                        super.onNext(t);
                    }
                }
                {
                    this.glob$1 = glob$1;
                }
            };
            AutoCloseable handle = this.sbt$internal$nio$WatchServiceBackedObservable$$observers.addObserver((Observer<FileEvent<FileAttributes>>)observable);
            left = package$.MODULE$.Right().apply((Object)new Observable<FileEvent<FileAttributes>>(null, (Observers)observable, handle, glob){
                private final Observers observable$1;
                private final AutoCloseable handle$1;
                private final Glob glob$1;

                public AutoCloseable addObserver(Observer<FileEvent<FileAttributes>> observer) {
                    return this.observable$1.addObserver(observer);
                }

                public void close() {
                    this.handle$1.close();
                }

                public String toString() {
                    return new StringBuilder(12).append("Observable(").append(this.glob$1).append(")").toString();
                }
                {
                    this.observable$1 = observable$1;
                    this.handle$1 = handle$1;
                    this.glob$1 = glob$1;
                }
            });
        }
        catch (IOException e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        return left;
    }

    public static final /* synthetic */ Glob $anonfun$register$1(Glob x0$1, int x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToInteger((int)x1$1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Glob g = (Glob)tuple2._1();
        Glob glob = Glob$GlobOps$.MODULE$.$div$extension(Glob$.MODULE$.GlobOps(g), AnyPath$.MODULE$);
        return glob;
    }

    public WatchServiceBackedObservable(NewWatchState s, FiniteDuration delay, boolean closeService, WatchLogger logger) {
        this.sbt$internal$nio$WatchServiceBackedObservable$$s = s;
        this.sbt$internal$nio$WatchServiceBackedObservable$$delay = delay;
        this.closeService = closeService;
        this.sbt$internal$nio$WatchServiceBackedObservable$$logger = logger;
        this.sbt$internal$nio$WatchServiceBackedObservable$$closed = new AtomicBoolean(false);
        this.sbt$internal$nio$WatchServiceBackedObservable$$observers = new Observers();
        this.sbt$internal$nio$WatchServiceBackedObservable$$fileCache = new FileCache((Function1 & Serializable)p -> (FileAttributes)FileAttributes$.MODULE$.apply((Path)p).getOrElse((Function0 & Serializable)() -> FileAttributes$NonExistent$.MODULE$));
        this.sbt$internal$nio$WatchServiceBackedObservable$$view = FileTreeView$.MODULE$.default();
        CountDownLatch latch = new CountDownLatch(1);
        this.thread = new Thread(this, latch){
            private final /* synthetic */ WatchServiceBackedObservable $outer;
            private final CountDownLatch latch$1;

            private final void loopImpl() {
                do {
                    try {
                        if (this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$closed.get()) continue;
                        this.getFilesForKey(this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$s.service().poll((Duration)this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$delay)).foreach((Function1 & Serializable)event -> {
                            $anon$1.$anonfun$loopImpl$1(this, event);
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$logger.debug(new StringBuilder(28).append("Error getting files from ").append(this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$s.service()).append(": ").append(e).append("\n").append(Predef$.MODULE$.wrapRefArray((Object[])e.getStackTrace()).mkString("\n")).toString());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        throw throwable;
                    }
                } while (!this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$closed.get());
            }

            public void run() {
                this.latch$1.countDown();
                try {
                    this.loopImpl();
                }
                catch (InterruptedException interruptedException) {}
            }

            private Seq<FileEvent<FileAttributes>> getFilesForKey(WatchKey key) {
                Vector vector;
                WatchKey watchKey = key;
                if (watchKey == null) {
                    vector = package$.MODULE$.Vector().empty();
                } else {
                    Vector vector2;
                    WatchKey watchKey2 = watchKey;
                    synchronized (watchKey2) {
                        Vector events = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(watchKey.pollEvents()).asScala()).toVector();
                        watchKey.reset();
                        vector2 = events;
                    }
                    Vector rawEvents = vector2;
                    Path keyPath = (Path)watchKey.watchable();
                    Seq allEvents = (Seq)rawEvents.flatMap((Function1 & Serializable)x0$1 -> {
                        Nil$ nil$;
                        WatchEvent watchEvent = x0$1;
                        if (watchEvent.kind().equals(StandardWatchEventKinds.OVERFLOW)) {
                            nil$ = $this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$fileCache.refresh(Glob$.MODULE$.apply(keyPath, (RelativeGlob)RecursiveGlob$.MODULE$));
                        } else if (!watchEvent.kind().equals(StandardWatchEventKinds.OVERFLOW) && watchEvent.context() != null) {
                            Seq<FileEvent<FileAttributes>> seq;
                            Path path = keyPath.resolve((Path)watchEvent.context());
                            Either<IOException, FileAttributes> either = FileAttributes$.MODULE$.apply(path);
                            if (either instanceof Right) {
                                Right right = (Right)either;
                                FileAttributes attrs = (FileAttributes)right.value();
                                seq = $this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$fileCache.update(path, attrs);
                            } else {
                                seq = package$.MODULE$.Nil();
                            }
                            nil$ = seq;
                        } else {
                            nil$ = package$.MODULE$.Nil();
                        }
                        return nil$;
                    });
                    this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$logger.debug(new StringBuilder(17).append("Received events:\n").append(allEvents.mkString("\n")).toString());
                    vector = (Seq)allEvents.flatMap((Function1 & Serializable)event -> this.process$1((FileEvent)event));
                }
                return vector;
            }

            public static final /* synthetic */ void $anonfun$loopImpl$1($anon$1 $this, FileEvent event) {
                $this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$observers.onNext(event);
            }

            public static final /* synthetic */ boolean $anonfun$getFilesForKey$3(FileEvent x$1) {
                return ((FileAttributes)x$1.attributes()).isDirectory();
            }

            public static final /* synthetic */ void $anonfun$getFilesForKey$4($anon$1 $this, FileEvent e) {
                $this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$s.unregister(e.path());
            }

            /*
             * Enabled aggressive block sorting
             */
            private final Seq process$1(FileEvent event) {
                Seq seq;
                FileEvent fileEvent = event;
                if (fileEvent instanceof FileEvent.Creation) {
                    FileEvent.Creation creation = (FileEvent.Creation)fileEvent;
                    Path path = creation.path();
                    FileAttributes attrs = (FileAttributes)creation.attributes();
                    if (attrs.isDirectory()) {
                        this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$s.register(path);
                        FileEvent fileEvent2 = event;
                        seq = (Seq)((SeqOps)FileTreeView$Ops$.MODULE$.list$extension(FileTreeView$.MODULE$.Ops(this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$view), Glob$.MODULE$.apply(path, (RelativeGlob)RecursiveGlob$.MODULE$)).flatMap((Function1 & Serializable)x0$1 -> {
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Path p = (Path)tuple2._1();
                            FileAttributes a = (FileAttributes)tuple2._2();
                            Seq seq = this.process$1(FileEvent$Creation$.MODULE$.apply(p, a, TimeSource$default$.MODULE$));
                            return seq;
                        })).$plus$colon((Object)fileEvent2);
                        return (Seq)seq.map((Function1 & Serializable)x0$2 -> {
                            FileEvent.Deletion<FileAttributes> deletion;
                            FileEvent.Deletion<FileAttributes> deletion2 = x0$2;
                            if (deletion2 instanceof FileEvent.Deletion) {
                                FileEvent.Deletion deletion3 = deletion2;
                                Path path = deletion3.path();
                                FileAttributes attributes = (FileAttributes)deletion3.attributes();
                                FileAttributes newAttrs = FileAttributes$.MODULE$.apply(attributes.isDirectory(), false, attributes.isRegularFile(), attributes.isSymbolicLink());
                                deletion = FileEvent$Deletion$.MODULE$.apply(path, newAttrs, deletion3.occurredAt());
                            } else {
                                deletion = deletion2;
                            }
                            return deletion;
                        });
                    }
                }
                if (fileEvent instanceof FileEvent.Deletion) {
                    FileEvent.Deletion deletion = (FileEvent.Deletion)fileEvent;
                    Path p = deletion.path();
                    FileAttributes attrs = (FileAttributes)deletion.attributes();
                    if (attrs.isDirectory()) {
                        Seq events = this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$fileCache.refresh(Glob$.MODULE$.apply(p, (RelativeGlob)RecursiveGlob$.MODULE$));
                        ((IterableOnceOps)events.view().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$getFilesForKey$3(x$1)))).foreach((Function1 & Serializable)e -> {
                            $anon$1.$anonfun$getFilesForKey$4(this, e);
                            return BoxedUnit.UNIT;
                        });
                        seq = events;
                        return (Seq)seq.map((Function1 & Serializable)x0$2 -> {
                            FileEvent.Deletion<FileAttributes> deletion;
                            FileEvent.Deletion<FileAttributes> deletion2 = x0$2;
                            if (deletion2 instanceof FileEvent.Deletion) {
                                FileEvent.Deletion deletion3 = deletion2;
                                Path path = deletion3.path();
                                FileAttributes attributes = (FileAttributes)deletion3.attributes();
                                FileAttributes newAttrs = FileAttributes$.MODULE$.apply(attributes.isDirectory(), false, attributes.isRegularFile(), attributes.isSymbolicLink());
                                deletion = FileEvent$Deletion$.MODULE$.apply(path, newAttrs, deletion3.occurredAt());
                            } else {
                                deletion = deletion2;
                            }
                            return deletion;
                        });
                    }
                }
                FileEvent fileEvent3 = fileEvent;
                seq = package$.MODULE$.Nil().$colon$colon((Object)fileEvent3);
                return (Seq)seq.map((Function1 & Serializable)x0$2 -> {
                    FileEvent.Deletion<FileAttributes> deletion;
                    FileEvent.Deletion<FileAttributes> deletion2 = x0$2;
                    if (deletion2 instanceof FileEvent.Deletion) {
                        FileEvent.Deletion deletion3 = deletion2;
                        Path path = deletion3.path();
                        FileAttributes attributes = (FileAttributes)deletion3.attributes();
                        FileAttributes newAttrs = FileAttributes$.MODULE$.apply(attributes.isDirectory(), false, attributes.isRegularFile(), attributes.isSymbolicLink());
                        deletion = FileEvent$Deletion$.MODULE$.apply(path, newAttrs, deletion3.occurredAt());
                    } else {
                        deletion = deletion2;
                    }
                    return deletion;
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
                super(new StringBuilder(25).append("watch-state-event-thread-").append(WatchServiceBackedObservable$.MODULE$.sbt$internal$nio$WatchServiceBackedObservable$$eventThreadId().incrementAndGet()).toString());
                this.setDaemon(true);
                this.start();
                if (!latch$1.await(5L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Couldn't start event thread");
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getFilesForKey$1(sbt.internal.nio.WatchServiceBackedObservable$$anon$1 java.nio.file.Path java.nio.file.WatchEvent ), $anonfun$getFilesForKey$2(sbt.internal.nio.WatchServiceBackedObservable$$anon$1 scala.Tuple2 ), $anonfun$getFilesForKey$3$adapted(sbt.internal.nio.FileEvent ), $anonfun$getFilesForKey$4$adapted(sbt.internal.nio.WatchServiceBackedObservable$$anon$1 sbt.internal.nio.FileEvent ), $anonfun$getFilesForKey$5(sbt.internal.nio.FileEvent ), $anonfun$getFilesForKey$6(sbt.internal.nio.WatchServiceBackedObservable$$anon$1 sbt.internal.nio.FileEvent ), $anonfun$loopImpl$1$adapted(sbt.internal.nio.WatchServiceBackedObservable$$anon$1 sbt.internal.nio.FileEvent )}, serializedLambda);
            }
        };
    }
}

