/*
 * Decompiled with CFR 0.152.
 */
package xsbt.api;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try$;
import xsbti.api.Access;
import xsbti.api.Annotated;
import xsbti.api.Annotation;
import xsbti.api.ClassDefinition;
import xsbti.api.ClassLike;
import xsbti.api.ClassLikeDef;
import xsbti.api.Constant;
import xsbti.api.Def;
import xsbti.api.Definition;
import xsbti.api.DefinitionType;
import xsbti.api.EmptyType;
import xsbti.api.Existential;
import xsbti.api.Id;
import xsbti.api.IdQualifier;
import xsbti.api.Modifiers;
import xsbti.api.ParameterList;
import xsbti.api.ParameterModifier;
import xsbti.api.ParameterRef;
import xsbti.api.Parameterized;
import xsbti.api.ParameterizedDefinition;
import xsbti.api.Path;
import xsbti.api.PathComponent;
import xsbti.api.Polymorphic;
import xsbti.api.Private;
import xsbti.api.Projection;
import xsbti.api.Protected;
import xsbti.api.Public;
import xsbti.api.Qualifier;
import xsbti.api.Singleton;
import xsbti.api.Structure;
import xsbti.api.Super;
import xsbti.api.This;
import xsbti.api.ThisQualifier;
import xsbti.api.Type;
import xsbti.api.TypeAlias;
import xsbti.api.TypeDeclaration;
import xsbti.api.TypeParameter;
import xsbti.api.Unqualified;
import xsbti.api.Val;
import xsbti.api.Var;
import xsbti.api.Variance;

public final class ShowAPI$ {
    public static final ShowAPI$ MODULE$ = new ShowAPI$();
    private static int numDecls;
    private static volatile boolean bitmap$0;

    private int numDecls$lzycompute() {
        ShowAPI$ showAPI$ = this;
        synchronized (showAPI$) {
            if (!bitmap$0) {
                numDecls = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> Integer.parseInt((String)package$.MODULE$.props().get("sbt.inc.apidiff.decls").get())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
                bitmap$0 = true;
            }
        }
        return numDecls;
    }

    private int numDecls() {
        if (!bitmap$0) {
            return this.numDecls$lzycompute();
        }
        return numDecls;
    }

    private ClassDefinition[] truncateDecls(ClassDefinition[] decls) {
        if (this.numDecls() <= 0) {
            return decls;
        }
        return (ClassDefinition[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])decls), this.numDecls());
    }

    private String lines(Seq<String> ls) {
        return ls.mkString("\n", "\n", "\n");
    }

    public String showApi(ClassLike c, int nesting) {
        return this.showDefinition((Definition)c, nesting);
    }

    public String showDefinition(Definition d, int nesting) {
        Definition definition = d;
        if (definition instanceof Val) {
            Val val = (Val)definition;
            return new StringBuilder(2).append(this.showMonoDef((Definition)val, "val", nesting)).append(": ").append(this.showType(val.tpe(), nesting)).toString();
        }
        if (definition instanceof Var) {
            Var var = (Var)definition;
            return new StringBuilder(2).append(this.showMonoDef((Definition)var, "var", nesting)).append(": ").append(this.showType(var.tpe(), nesting)).toString();
        }
        if (definition instanceof Def) {
            Def def = (Def)definition;
            return new StringBuilder(2).append(this.showPolyDef((ParameterizedDefinition)def, "def", nesting)).append(this.showValueParams((Seq<ParameterList>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)def.valueParameters()), nesting)).append(": ").append(this.showType(def.returnType(), nesting)).toString();
        }
        if (definition instanceof TypeAlias) {
            TypeAlias typeAlias = (TypeAlias)definition;
            return new StringBuilder(3).append(this.showPolyDef((ParameterizedDefinition)typeAlias, "type", nesting)).append(" = ").append(this.showType(typeAlias.tpe(), nesting)).toString();
        }
        if (definition instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)definition;
            return new StringBuilder(0).append(this.showPolyDef((ParameterizedDefinition)typeDeclaration, "type", nesting)).append(this.showBounds(typeDeclaration.lowerBound(), typeDeclaration.upperBound(), nesting)).toString();
        }
        if (definition instanceof ClassLike) {
            ClassLike classLike = (ClassLike)definition;
            return new StringBuilder(9).append(this.showMonoDef(d, this.showDefinitionType(classLike.definitionType()), nesting)).append(this.showTypeParameters((Seq<TypeParameter>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)classLike.typeParameters()), nesting)).append(" extends ").append(this.showTemplate(classLike, nesting)).toString();
        }
        if (definition instanceof ClassLikeDef) {
            ClassLikeDef classLikeDef = (ClassLikeDef)definition;
            return this.showPolyDef((ParameterizedDefinition)classLikeDef, this.showDefinitionType(classLikeDef.definitionType()), nesting);
        }
        throw new MatchError((Object)definition);
    }

    private String showTemplate(ClassLike cl, int nesting) {
        if (nesting <= 0) {
            return "<nesting level reached>";
        }
        String showSelf = cl.selfType() instanceof EmptyType ? "" : new StringBuilder(10).append(" self: ").append(this.showNestedType(cl.selfType(), nesting)).append(" =>").toString();
        return new StringBuilder(1).append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])cl.structure().parents()), (Function1 & Serializable)tp -> MODULE$.showNestedType((Type)tp, nesting), ClassTag$.MODULE$.apply(String.class))).mkString("", " with ", " {")).append(showSelf).append(this.lines((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.truncateDecls(cl.structure().inherited())), (Function1 & Serializable)d -> new StringBuilder(12).append("^inherited^ ").append(MODULE$.showNestedDefinition((Definition)d, nesting)).toString(), ClassTag$.MODULE$.apply(String.class))))).append(this.lines((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.truncateDecls(cl.structure().declared())), (Function1 & Serializable)d -> MODULE$.showNestedDefinition((Definition)d, nesting), ClassTag$.MODULE$.apply(String.class))))).append("}").toString();
    }

    public String showType(Type t2, int nesting) {
        Type type = t2;
        if (type instanceof Projection) {
            Projection projection = (Projection)type;
            return new StringBuilder(1).append(this.showType(projection.prefix(), nesting)).append("#").append(projection.id()).toString();
        }
        if (type instanceof ParameterRef) {
            ParameterRef parameterRef = (ParameterRef)type;
            return new StringBuilder(2).append("<").append(parameterRef.id()).append(">").toString();
        }
        if (type instanceof Singleton) {
            Singleton singleton = (Singleton)type;
            return this.showPath(singleton.path());
        }
        if (type instanceof EmptyType) {
            return "<empty>";
        }
        if (type instanceof Parameterized) {
            Parameterized parameterized = (Parameterized)type;
            return new StringBuilder(0).append(this.showType(parameterized.baseType(), nesting)).append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])parameterized.typeArguments()), (Function1 & Serializable)t -> MODULE$.showType((Type)t, nesting), ClassTag$.MODULE$.apply(String.class))).mkString("[", ", ", "]")).toString();
        }
        if (type instanceof Constant) {
            Constant constant = (Constant)type;
            return new StringBuilder(2).append(this.showType(constant.baseType(), nesting)).append("(").append(constant.value()).append(")").toString();
        }
        if (type instanceof Annotated) {
            Annotated annotated = (Annotated)type;
            return new StringBuilder(1).append(this.showAnnotations((Seq<Annotation>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)annotated.annotations()), nesting)).append(" ").append(this.showType(annotated.baseType(), nesting)).toString();
        }
        if (type instanceof Structure) {
            Structure structure2 = (Structure)type;
            return new StringBuilder(0).append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])structure2.parents()), (Function1 & Serializable)t -> MODULE$.showType((Type)t, nesting), ClassTag$.MODULE$.apply(String.class))).mkString(" with ")).append((Object)(nesting <= 0 ? "{ <nesting level reached> }" : Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.truncateDecls(structure2.declared())), (Function1 & Serializable)d -> MODULE$.showNestedDefinition((Definition)d, nesting), ClassTag$.MODULE$.apply(String.class))).mkString(" {", "\n", "}"))).toString();
        }
        if (type instanceof Existential) {
            Existential existential = (Existential)type;
            return new StringBuilder(0).append(this.showType(existential.baseType(), nesting)).append((Object)(nesting <= 0 ? " forSome { <nesting level reached> }" : Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])existential.clause()), (Function1 & Serializable)t -> new StringBuilder(5).append("type ").append(MODULE$.showNestedTypeParameter((TypeParameter)t, nesting)).toString(), ClassTag$.MODULE$.apply(String.class))).mkString(" forSome { ", "; ", " }"))).toString();
        }
        if (type instanceof Polymorphic) {
            Polymorphic polymorphic = (Polymorphic)type;
            return new StringBuilder(0).append(this.showType(polymorphic.baseType(), nesting)).append((Object)(nesting <= 0 ? " [ <nesting level reached> ]" : this.showNestedTypeParameters((Seq<TypeParameter>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)polymorphic.parameters()), nesting))).toString();
        }
        throw new MatchError((Object)type);
    }

    private String showPath(Path p) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])p.components()), (Function1 & Serializable)pc -> MODULE$.showPathComponent((PathComponent)pc), ClassTag$.MODULE$.apply(String.class))).mkString(".");
    }

    private String showPathComponent(PathComponent pc) {
        PathComponent pathComponent = pc;
        if (pathComponent instanceof Super) {
            Super super_ = (Super)pathComponent;
            return new StringBuilder(7).append("super[").append(this.showPath(super_.qualifier())).append("]").toString();
        }
        if (pathComponent instanceof This) {
            return "this";
        }
        if (pathComponent instanceof Id) {
            Id id = (Id)pathComponent;
            return id.id();
        }
        throw new MatchError((Object)pathComponent);
    }

    private String space(String s) {
        if (s.isEmpty()) {
            return s;
        }
        return new StringBuilder(1).append(s).append(" ").toString();
    }

    private String showMonoDef(Definition d, String label, int nesting) {
        return new StringBuilder(0).append(this.space(this.showAnnotations((Seq<Annotation>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)d.annotations()), nesting))).append(this.space(this.showAccess(d.access()))).append(this.space(this.showModifiers(d.modifiers()))).append(this.space(label)).append(d.name()).toString();
    }

    private String showPolyDef(ParameterizedDefinition d, String label, int nesting) {
        return new StringBuilder(0).append(this.showMonoDef((Definition)d, label, nesting)).append(this.showTypeParameters((Seq<TypeParameter>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)d.typeParameters()), nesting)).toString();
    }

    private String showTypeParameters(Seq<TypeParameter> tps, int nesting) {
        if (tps.isEmpty()) {
            return "";
        }
        return ((IterableOnceOps)tps.map((Function1 & Serializable)tp -> MODULE$.showTypeParameter((TypeParameter)tp, nesting))).mkString("[", ", ", "]");
    }

    private String showTypeParameter(TypeParameter tp, int nesting) {
        return new StringBuilder(2).append(this.showAnnotations((Seq<Annotation>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)tp.annotations()), nesting)).append(" ").append(this.showVariance(tp.variance())).append(tp.id()).append(this.showTypeParameters((Seq<TypeParameter>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)tp.typeParameters()), nesting)).append(" ").append(this.showBounds(tp.lowerBound(), tp.upperBound(), nesting)).toString();
    }

    private String showAnnotations(Seq<Annotation> as, int nesting) {
        return ((IterableOnceOps)as.map((Function1 & Serializable)a -> MODULE$.showAnnotation((Annotation)a, nesting))).mkString(" ");
    }

    private String showAnnotation(Annotation a2, int nesting) {
        return new StringBuilder(1).append("@").append(this.showType(a2.base(), nesting)).append((Object)(ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])a2.arguments())) ? "" : Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])a2.arguments()), (Function1 & Serializable)a -> new StringBuilder(3).append(a.name()).append(" = ").append(a.value()).toString(), ClassTag$.MODULE$.apply(String.class))).mkString("(", ", ", ")"))).toString();
    }

    private String showBounds(Type lower, Type upper, int nesting) {
        return new StringBuilder(7).append(">: ").append(this.showType(lower, nesting)).append(" <: ").append(this.showType(upper, nesting)).toString();
    }

    private String showValueParams(Seq<ParameterList> ps, int nesting) {
        return ((IterableOnceOps)ps.map((Function1 & Serializable)pl -> Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])pl.parameters()), (Function1 & Serializable)mp -> new StringBuilder(2).append(mp.name()).append(": ").append(MODULE$.showParameterModifier(MODULE$.showType(mp.tpe(), nesting), mp.modifier())).append((Object)(mp.hasDefault() ? "= ..." : "")).toString(), ClassTag$.MODULE$.apply(String.class))).mkString(pl.isImplicit() ? "(implicit " : "(", ", ", ")"))).mkString("");
    }

    private String showParameterModifier(String base, ParameterModifier pm) {
        ParameterModifier parameterModifier = pm;
        if (ParameterModifier.Plain.equals(parameterModifier)) {
            return base;
        }
        if (ParameterModifier.Repeated.equals(parameterModifier)) {
            return new StringBuilder(1).append(base).append("*").toString();
        }
        if (ParameterModifier.ByName.equals(parameterModifier)) {
            return new StringBuilder(3).append("=> ").append(base).toString();
        }
        throw new MatchError((Object)parameterModifier);
    }

    private String showDefinitionType(DefinitionType d) {
        DefinitionType definitionType = d;
        if (DefinitionType.Trait.equals(definitionType)) {
            return "trait";
        }
        if (DefinitionType.ClassDef.equals(definitionType)) {
            return "class";
        }
        if (DefinitionType.Module.equals(definitionType)) {
            return "object";
        }
        if (DefinitionType.PackageModule.equals(definitionType)) {
            return "package object";
        }
        throw new MatchError((Object)definitionType);
    }

    private String showAccess(Access a) {
        Access access = a;
        if (access instanceof Public) {
            return "";
        }
        if (access instanceof Protected) {
            Protected protected_ = (Protected)access;
            return new StringBuilder(9).append("protected").append(this.showQualifier(protected_.qualifier())).toString();
        }
        if (access instanceof Private) {
            Private private_ = (Private)access;
            return new StringBuilder(7).append("private").append(this.showQualifier(private_.qualifier())).toString();
        }
        throw new MatchError((Object)access);
    }

    private String showQualifier(Qualifier q) {
        Qualifier qualifier = q;
        if (qualifier instanceof Unqualified) {
            return "";
        }
        if (qualifier instanceof ThisQualifier) {
            return "[this]";
        }
        if (qualifier instanceof IdQualifier) {
            IdQualifier idQualifier = (IdQualifier)qualifier;
            return new StringBuilder(2).append("[").append(idQualifier.value()).append("]").toString();
        }
        throw new MatchError((Object)qualifier);
    }

    private String showModifiers(Modifiers m) {
        return new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isOverride()), (Object)"override"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isFinal()), (Object)"final"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isSealed()), (Object)"sealed"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isImplicit()), (Object)"implicit"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isAbstract()), (Object)"abstract"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isLazy()), (Object)"lazy"), (List)Nil$.MODULE$)))))).collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Object, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    boolean bl = A1._1$mcZ$sp();
                    String mod = (String)A1._2();
                    if (bl) {
                        return (B1)mod;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, String> x1) {
                boolean bl;
                Tuple2<Object, String> tuple2 = x1;
                return tuple2 != null && true == (bl = tuple2._1$mcZ$sp());
            }
        }).mkString(" ");
    }

    private String showVariance(Variance v) {
        Variance variance = v;
        if (Variance.Invariant.equals(variance)) {
            return "";
        }
        if (Variance.Covariant.equals(variance)) {
            return "+";
        }
        if (Variance.Contravariant.equals(variance)) {
            return "-";
        }
        throw new MatchError((Object)variance);
    }

    private String showNestedType(Type tp, int nesting) {
        return this.showType(tp, nesting - 1);
    }

    private String showNestedTypeParameter(TypeParameter tp, int nesting) {
        return this.showTypeParameter(tp, nesting - 1);
    }

    private String showNestedTypeParameters(Seq<TypeParameter> tps, int nesting) {
        return this.showTypeParameters(tps, nesting - 1);
    }

    private String showNestedDefinition(Definition d, int nesting) {
        return this.showDefinition(d, nesting - 1);
    }

    private ShowAPI$() {
    }
}

