/*
 * Decompiled with CFR 0.152.
 */
package scoverage;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.io.Writer;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Utility$;
import scala.xml.XML$;
import scoverage.ClassType;
import scoverage.ClassType$Class$;
import scoverage.ClassType$Object$;
import scoverage.ClassType$Trait$;
import scoverage.Constants$;
import scoverage.Coverage;
import scoverage.Location;
import scoverage.Statement;

public final class Serializer$ {
    public static Serializer$ MODULE$;

    static {
        new Serializer$();
    }

    public void serialize(Coverage coverage, String dataDir) {
        this.serialize(coverage, this.coverageFile(dataDir));
    }

    public void serialize(Coverage coverage, File file) {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        this.serialize(coverage, writer);
        writer.close();
    }

    public void serialize(Coverage coverage, Writer writer) {
        writer.write("<statements>\n");
        coverage.statements().foreach((Function1 & Serializable & scala.Serializable)stmt -> {
            this.writeStatement$1(stmt, writer);
            return BoxedUnit.UNIT;
        });
        writer.write("</statements>");
    }

    public File coverageFile(File dataDir) {
        return this.coverageFile(dataDir.getAbsolutePath());
    }

    public File coverageFile(String dataDir) {
        return new File(dataDir, Constants$.MODULE$.CoverageFileName());
    }

    public Coverage deserialize(String str) {
        Elem xml = (Elem)XML$.MODULE$.loadString(str);
        scala.collection.immutable.Seq statements = (scala.collection.immutable.Seq)xml.$bslash("statement").map((Function1 & Serializable & scala.Serializable)node -> {
            String source = node.$bslash("source").text();
            int count = new StringOps(Predef$.MODULE$.augmentString(node.$bslash("count").text())).toInt();
            boolean ignored = new StringOps(Predef$.MODULE$.augmentString(node.$bslash("ignored").text())).toBoolean();
            boolean branch = new StringOps(Predef$.MODULE$.augmentString(node.$bslash("branch").text())).toBoolean();
            String _package = node.$bslash("package").text();
            String _class = node.$bslash("class").text();
            String fullClassName = node.$bslash("fullClassName").text();
            String method = node.$bslash("method").text();
            String path = node.$bslash("path").text();
            String treeName = node.$bslash("treeName").text();
            String symbolName = node.$bslash("symbolName").text();
            int id = new StringOps(Predef$.MODULE$.augmentString(node.$bslash("id").text())).toInt();
            int line = new StringOps(Predef$.MODULE$.augmentString(node.$bslash("line").text())).toInt();
            String desc = node.$bslash("description").text();
            int start = new StringOps(Predef$.MODULE$.augmentString(node.$bslash("start").text())).toInt();
            int end = new StringOps(Predef$.MODULE$.augmentString(node.$bslash("end").text())).toInt();
            String string = node.$bslash("classType").text();
            ClassType classType = "Trait".equals(string) ? ClassType$Trait$.MODULE$ : ("Object".equals(string) ? ClassType$Object$.MODULE$ : ClassType$Class$.MODULE$);
            ClassType$Trait$ classType2 = classType;
            return new Statement(source, new Location(_package, _class, fullClassName, classType2, method, path), id, start, end, line, desc, symbolName, treeName, branch, count, ignored);
        }, Seq$.MODULE$.canBuildFrom());
        Coverage coverage = new Coverage();
        statements.foreach((Function1 & Serializable & scala.Serializable)statement -> {
            Serializer$.$anonfun$deserialize$2(coverage, statement);
            return BoxedUnit.UNIT;
        });
        return coverage;
    }

    public Coverage deserialize(File file) {
        String str = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec()).mkString();
        return this.deserialize(str);
    }

    public String escape(String in) {
        StringBuilder out = new StringBuilder();
        new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(((String)Option$.MODULE$.apply((Object)in).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toCharArray())).foreach((Function1 & Serializable & scala.Serializable)current -> Serializer$.$anonfun$escape$2(out, BoxesRunTime.unboxToChar((Object)current)));
        return out.mkString();
    }

    private final void writeStatement$1(Statement stmt, Writer writer) {
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n            "));
        $buf2.$amp$plus((Object)stmt.source());
        $buf2.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "source", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n            "));
        $buf3.$amp$plus((Object)stmt.location().packageName());
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "package", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n            "));
        $buf4.$amp$plus((Object)stmt.location().className());
        $buf4.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "class", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)stmt.location().classType().toString());
        $buf5.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "classType", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n            "));
        $buf6.$amp$plus((Object)stmt.location().fullClassName());
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "fullClassName", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            "));
        $buf7.$amp$plus((Object)stmt.location().method());
        $buf7.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "method", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n            "));
        $buf8.$amp$plus((Object)stmt.location().sourcePath());
        $buf8.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "path", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n            "));
        $buf9.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)stmt.id())).toString());
        $buf9.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "id", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n            "));
        $buf10.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)stmt.start())).toString());
        $buf10.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "start", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n            "));
        $buf11.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)stmt.end())).toString());
        $buf11.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "end", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n            "));
        $buf12.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)stmt.line())).toString());
        $buf12.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "line", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n            "));
        $buf13.$amp$plus((Object)this.escape(stmt.desc()));
        $buf13.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "description", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n            "));
        $buf14.$amp$plus((Object)this.escape(stmt.symbolName()));
        $buf14.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "symbolName", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("\n            "));
        $buf15.$amp$plus((Object)this.escape(stmt.treeName()));
        $buf15.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "treeName", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf15));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("\n            "));
        $buf16.$amp$plus((Object)((Object)BoxesRunTime.boxToBoolean((boolean)stmt.branch())).toString());
        $buf16.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "branch", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf16));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf17 = new NodeBuffer();
        $buf17.$amp$plus((Object)new Text("\n            "));
        $buf17.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)stmt.count())).toString());
        $buf17.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "count", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf17));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf18 = new NodeBuffer();
        $buf18.$amp$plus((Object)new Text("\n            "));
        $buf18.$amp$plus((Object)((Object)BoxesRunTime.boxToBoolean((boolean)stmt.ignored())).toString());
        $buf18.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "ignored", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf18));
        $buf.$amp$plus((Object)new Text("\n        "));
        Elem xml = new Elem(null, "statement", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        writer.write(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Utility$.MODULE$.trim((Node)xml)), "\n"));
    }

    public static final /* synthetic */ void $anonfun$deserialize$2(Coverage coverage$1, Statement statement) {
        if (statement.ignored()) {
            coverage$1.addIgnoredStatement(statement);
        } else {
            coverage$1.add(statement);
        }
    }

    public static final /* synthetic */ Object $anonfun$escape$2(StringBuilder out$1, char current) {
        return current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff' ? out$1.append(current) : BoxedUnit.UNIT;
    }

    private Serializer$() {
        MODULE$ = this;
    }
}

