/*
 * Decompiled with CFR 0.152.
 */
package scoverage.report;

import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PrettyPrinter;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;
import scoverage.Coverage;
import scoverage.IOUtils$;
import scoverage.MeasuredClass;
import scoverage.MeasuredMethod;
import scoverage.MeasuredPackage;
import scoverage.Statement;
import scoverage.report.BaseReportWriter;

@ScalaSignature(bytes="\u0006\u0005a4A!\u0004\b\u0001'!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004\u0003\u00050\u0001\t\u0005\t\u0015!\u0003(\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0004\"B\u001b\u0001\t\u00031\u0004\"B\u001b\u0001\t\u0003Y\u0004\"\u0002!\u0001\t\u0003\t\u0005\"B&\u0001\t\u0013a\u0005\"B*\u0001\t\u0013!\u0006\"\u0002.\u0001\t\u0013Y\u0006\"\u00021\u0001\t\u0013\t\u0007\"\u00024\u0001\t\u00139\u0007\"\u00027\u0001\t\u0003i'AE*d_Z,'/Y4f16dwK]5uKJT!a\u0004\t\u0002\rI,\u0007o\u001c:u\u0015\u0005\t\u0012!C:d_Z,'/Y4f\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005U1R\"\u0001\b\n\u0005]q!\u0001\u0005\"bg\u0016\u0014V\r]8si^\u0013\u0018\u000e^3s\u0003E\u0019x.\u001e:dK\u0012K'/Z2u_JLWm\u001d\t\u00045\u0011:cBA\u000e\"\u001d\tar$D\u0001\u001e\u0015\tq\"#\u0001\u0004=e>|GOP\u0005\u0002A\u0005)1oY1mC&\u0011!eI\u0001\ba\u0006\u001c7.Y4f\u0015\u0005\u0001\u0013BA\u0013'\u0005\r\u0019V-\u001d\u0006\u0003E\r\u0002\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\u0005%|'\"\u0001\u0017\u0002\t)\fg/Y\u0005\u0003]%\u0012AAR5mK\u0006Iq.\u001e;qkR$\u0015N]\u0001\u0006I\u0016\u0014Wo\u001a\t\u0003eMj\u0011aI\u0005\u0003i\r\u0012qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0005oaJ$\b\u0005\u0002\u0016\u0001!)\u0001\u0004\u0002a\u00013!)q\u0006\u0002a\u0001O!)\u0001\u0007\u0002a\u0001cQ!q\u0007\u0010 @\u0011\u0015iT\u00011\u0001(\u0003%\u0019x.\u001e:dK\u0012K'\u000fC\u00030\u000b\u0001\u0007q\u0005C\u00031\u000b\u0001\u0007\u0011'A\u0003xe&$X\r\u0006\u0002C\u000bB\u0011!gQ\u0005\u0003\t\u000e\u0012A!\u00168ji\")aI\u0002a\u0001\u000f\u0006A1m\u001c<fe\u0006<W\r\u0005\u0002I\u00136\t\u0001#\u0003\u0002K!\tA1i\u001c<fe\u0006<W-A\u0002y[2$\"!\u0014*\u0011\u00059\u0003V\"A(\u000b\u0005-\u001b\u0013BA)P\u0005\u0011qu\u000eZ3\t\u000b\u0019;\u0001\u0019A$\u0002\u0013M$\u0018\r^3nK:$HCA'V\u0011\u00151\u0006\u00021\u0001X\u0003\u0011\u0019H/\u001c;\u0011\u0005!C\u0016BA-\u0011\u0005%\u0019F/\u0019;f[\u0016tG/\u0001\u0004nKRDw\u000e\u001a\u000b\u0003\u001brCQAW\u0005A\u0002u\u0003\"\u0001\u00130\n\u0005}\u0003\"AD'fCN,(/\u001a3NKRDw\u000eZ\u0001\u0006W2\f7o\u001d\u000b\u0003\u001b\nDQ\u0001\u0019\u0006A\u0002\r\u0004\"\u0001\u00133\n\u0005\u0015\u0004\"!D'fCN,(/\u001a3DY\u0006\u001c8/\u0001\u0003qC\u000e\\GCA'i\u0011\u001517\u00021\u0001j!\tA%.\u0003\u0002l!\tyQ*Z1tkJ,G\rU1dW\u0006<W-\u0001\u0004fg\u000e\f\u0007/\u001a\u000b\u0003]Z\u0004\"a\\:\u000f\u0005A\f\bC\u0001\u000f$\u0013\t\u00118%\u0001\u0004Qe\u0016$WMZ\u0005\u0003iV\u0014aa\u0015;sS:<'B\u0001:$\u0011\u00159H\u00021\u0001o\u0003\tIg\u000e")
public class ScoverageXmlWriter
extends BaseReportWriter {
    private final File outputDir;
    private final boolean debug;

    public void write(Coverage coverage) {
        File file = IOUtils$.MODULE$.reportFile(this.outputDir, this.debug);
        PrettyPrinter qual$1 = new PrettyPrinter(120, 4);
        Node x$1 = this.xml(coverage);
        NamespaceBinding x$2 = qual$1.format$default$2();
        IOUtils$.MODULE$.writeToFile(file, qual$1.format(x$1, x$2));
    }

    /*
     * WARNING - void declaration
     */
    private Node xml(Coverage coverage) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("timestamp", Long.toString(System.currentTimeMillis()), (MetaData)$md);
        $md = new UnprefixedAttribute("version", (Seq)new Text("1.0"), (MetaData)$md);
        $md = new UnprefixedAttribute("branch-rate", coverage.branchCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-rate", coverage.statementCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statements-invoked", Integer.toString(coverage.invokedStatementCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-count", Integer.toString(coverage.statementCount()), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(coverage.packages().map((Function1 & Serializable)pack -> this.pack((MeasuredPackage)pack)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "packages", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "scoverage", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    private Node statement(Statement stmt) {
        Elem elem;
        boolean bl = this.debug;
        if (bl) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("ignored", Boolean.toString(stmt.ignored()), (MetaData)$md);
            $md = new UnprefixedAttribute("invocation-count", Integer.toString(stmt.count()), (MetaData)$md);
            $md = new UnprefixedAttribute("branch", Boolean.toString(stmt.branch()), (MetaData)$md);
            $md = new UnprefixedAttribute("tree", this.escape(stmt.treeName()), (MetaData)$md);
            $md = new UnprefixedAttribute("symbol", this.escape(stmt.symbolName()), (MetaData)$md);
            $md = new UnprefixedAttribute("line", Integer.toString(stmt.line()), (MetaData)$md);
            $md = new UnprefixedAttribute("end", Integer.toString(stmt.end()), (MetaData)$md);
            $md = new UnprefixedAttribute("start", Integer.toString(stmt.start()), (MetaData)$md);
            $md = new UnprefixedAttribute("method", stmt.location().method(), (MetaData)$md);
            $md = new UnprefixedAttribute("source", stmt.source(), (MetaData)$md);
            $md = new UnprefixedAttribute("full-class-name", stmt.location().fullClassName(), (MetaData)$md);
            $md = new UnprefixedAttribute("class-type", stmt.location().classType().toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("class", stmt.location().className(), (MetaData)$md);
            $md = new UnprefixedAttribute("package", stmt.location().packageName(), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)this.escape(stmt.desc()));
            $buf.$amp$plus((Object)new Text("\n        "));
            elem = new Elem(null, "statement", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        } else if (!bl) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("ignored", Boolean.toString(stmt.ignored()), (MetaData)$md);
            $md = new UnprefixedAttribute("invocation-count", Integer.toString(stmt.count()), (MetaData)$md);
            $md = new UnprefixedAttribute("branch", Boolean.toString(stmt.branch()), (MetaData)$md);
            $md = new UnprefixedAttribute("line", Integer.toString(stmt.line()), (MetaData)$md);
            $md = new UnprefixedAttribute("end", Integer.toString(stmt.end()), (MetaData)$md);
            $md = new UnprefixedAttribute("start", Integer.toString(stmt.start()), (MetaData)$md);
            $md = new UnprefixedAttribute("method", stmt.location().method(), (MetaData)$md);
            $md = new UnprefixedAttribute("source", stmt.source(), (MetaData)$md);
            $md = new UnprefixedAttribute("full-class-name", stmt.location().fullClassName(), (MetaData)$md);
            $md = new UnprefixedAttribute("class-type", stmt.location().classType().toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("class", stmt.location().className(), (MetaData)$md);
            $md = new UnprefixedAttribute("package", stmt.location().packageName(), (MetaData)$md);
            elem = new Elem(null, "statement", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$);
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return elem;
    }

    /*
     * WARNING - void declaration
     */
    private Node method(MeasuredMethod method) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("branch-rate", method.branchCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-rate", method.statementCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statements-invoked", Integer.toString(method.invokedStatementCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-count", Integer.toString(method.statementCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("name", method.name(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(method.statements().map((Function1 & Serializable)stmt -> this.statement((Statement)stmt)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "statements", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "method", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private Node klass(MeasuredClass klass) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("branch-rate", klass.branchCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-rate", klass.statementCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statements-invoked", Integer.toString(klass.invokedStatementCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-count", Integer.toString(klass.statementCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("filename", this.relativeSource(klass.source()), (MetaData)$md);
        $md = new UnprefixedAttribute("name", klass.fullClassName(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(klass.methods().map((Function1 & Serializable)method -> this.method((MeasuredMethod)method)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "methods", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "class", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private Node pack(MeasuredPackage pack) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("statement-rate", pack.statementCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statements-invoked", Integer.toString(pack.invokedStatementCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-count", Integer.toString(pack.statementCount()), (MetaData)$md);
        $md = new UnprefixedAttribute("name", pack.name(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(pack.classes().map((Function1 & Serializable)klass -> this.klass((MeasuredClass)klass)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "classes", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "package", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    public String escape(String in) {
        StringBuilder out = new StringBuilder();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.charArrayOps(((String)Option$.MODULE$.apply((Object)in).getOrElse((Function0 & Serializable)() -> "")).toCharArray()), (Function1 & Serializable)current -> ScoverageXmlWriter.$anonfun$escape$2(out, BoxesRunTime.unboxToChar((Object)current)));
        return out.mkString();
    }

    public static final /* synthetic */ Object $anonfun$escape$2(StringBuilder out$1, char current) {
        return current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff' ? out$1.append(current) : BoxedUnit.UNIT;
    }

    public ScoverageXmlWriter(scala.collection.immutable.Seq<File> sourceDirectories, File outputDir, boolean debug) {
        this.outputDir = outputDir;
        this.debug = debug;
        super(sourceDirectories, outputDir);
    }

    public ScoverageXmlWriter(File sourceDir, File outputDir, boolean debug) {
        this((scala.collection.immutable.Seq<File>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{sourceDir}))), outputDir, debug);
    }
}

