package org.openqa.selenium.devtools.v109.target.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Issued when detached from target for any reason (including `detachFromTarget` command). Can be
 * issued multiple times per target if multiple sessions have been attached to it.
 */
@org.openqa.selenium.Beta()
public class DetachedFromTarget {

    private final org.openqa.selenium.devtools.v109.target.model.SessionID sessionId;

    private final java.util.Optional<org.openqa.selenium.devtools.v109.target.model.TargetID> targetId;

    public DetachedFromTarget(org.openqa.selenium.devtools.v109.target.model.SessionID sessionId, java.util.Optional<org.openqa.selenium.devtools.v109.target.model.TargetID> targetId) {
        this.sessionId = java.util.Objects.requireNonNull(sessionId, "sessionId is required");
        this.targetId = targetId;
    }

    /**
     * Detached session identifier.
     */
    public org.openqa.selenium.devtools.v109.target.model.SessionID getSessionId() {
        return sessionId;
    }

    /**
     * Deprecated.
     */
    @Deprecated()
    public java.util.Optional<org.openqa.selenium.devtools.v109.target.model.TargetID> getTargetId() {
        return targetId;
    }

    private static DetachedFromTarget fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v109.target.model.SessionID sessionId = null;
        java.util.Optional<org.openqa.selenium.devtools.v109.target.model.TargetID> targetId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "sessionId":
                    sessionId = input.read(org.openqa.selenium.devtools.v109.target.model.SessionID.class);
                    break;
                case "targetId":
                    targetId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v109.target.model.TargetID.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DetachedFromTarget(sessionId, targetId);
    }
}
