package org.openqa.selenium.devtools.v110.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when a prerender attempt is completed.
 */
@org.openqa.selenium.Beta()
public class PrerenderAttemptCompleted {

    private final org.openqa.selenium.devtools.v110.page.model.FrameId initiatingFrameId;

    private final java.lang.String prerenderingUrl;

    private final org.openqa.selenium.devtools.v110.page.model.PrerenderFinalStatus finalStatus;

    private final java.util.Optional<java.lang.String> disallowedApiMethod;

    public PrerenderAttemptCompleted(org.openqa.selenium.devtools.v110.page.model.FrameId initiatingFrameId, java.lang.String prerenderingUrl, org.openqa.selenium.devtools.v110.page.model.PrerenderFinalStatus finalStatus, java.util.Optional<java.lang.String> disallowedApiMethod) {
        this.initiatingFrameId = java.util.Objects.requireNonNull(initiatingFrameId, "initiatingFrameId is required");
        this.prerenderingUrl = java.util.Objects.requireNonNull(prerenderingUrl, "prerenderingUrl is required");
        this.finalStatus = java.util.Objects.requireNonNull(finalStatus, "finalStatus is required");
        this.disallowedApiMethod = disallowedApiMethod;
    }

    /**
     * The frame id of the frame initiating prerendering.
     */
    public org.openqa.selenium.devtools.v110.page.model.FrameId getInitiatingFrameId() {
        return initiatingFrameId;
    }

    public java.lang.String getPrerenderingUrl() {
        return prerenderingUrl;
    }

    public org.openqa.selenium.devtools.v110.page.model.PrerenderFinalStatus getFinalStatus() {
        return finalStatus;
    }

    /**
     * This is used to give users more information about the name of the API call
     * that is incompatible with prerender and has caused the cancellation of the attempt
     */
    public java.util.Optional<java.lang.String> getDisallowedApiMethod() {
        return disallowedApiMethod;
    }

    private static PrerenderAttemptCompleted fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v110.page.model.FrameId initiatingFrameId = null;
        java.lang.String prerenderingUrl = null;
        org.openqa.selenium.devtools.v110.page.model.PrerenderFinalStatus finalStatus = null;
        java.util.Optional<java.lang.String> disallowedApiMethod = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "initiatingFrameId":
                    initiatingFrameId = input.read(org.openqa.selenium.devtools.v110.page.model.FrameId.class);
                    break;
                case "prerenderingUrl":
                    prerenderingUrl = input.nextString();
                    break;
                case "finalStatus":
                    finalStatus = input.read(org.openqa.selenium.devtools.v110.page.model.PrerenderFinalStatus.class);
                    break;
                case "disallowedApiMethod":
                    disallowedApiMethod = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PrerenderAttemptCompleted(initiatingFrameId, prerenderingUrl, finalStatus, disallowedApiMethod);
    }
}
