/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v122.preload.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.json.JsonInput;

public class PrerenderMismatchedHeaders {
    private final String headerName;
    private final Optional<String> initialValue;
    private final Optional<String> activationValue;

    public PrerenderMismatchedHeaders(String headerName, Optional<String> initialValue, Optional<String> activationValue) {
        this.headerName = Objects.requireNonNull(headerName, "headerName is required");
        this.initialValue = initialValue;
        this.activationValue = activationValue;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public Optional<String> getInitialValue() {
        return this.initialValue;
    }

    public Optional<String> getActivationValue() {
        return this.activationValue;
    }

    private static PrerenderMismatchedHeaders fromJson(JsonInput input) {
        String headerName = null;
        Optional<String> initialValue = Optional.empty();
        Optional<String> activationValue = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "headerName": {
                    headerName = input.nextString();
                    continue block10;
                }
                case "initialValue": {
                    initialValue = Optional.ofNullable(input.nextString());
                    continue block10;
                }
                case "activationValue": {
                    activationValue = Optional.ofNullable(input.nextString());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PrerenderMismatchedHeaders(headerName, initialValue, activationValue);
    }
}

