package org.openqa.selenium.devtools.v134.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * HTTP request data.
 */
public class Request {

    public enum ReferrerPolicy {

        UNSAFE_URL("unsafe-url"),
        NO_REFERRER_WHEN_DOWNGRADE("no-referrer-when-downgrade"),
        NO_REFERRER("no-referrer"),
        ORIGIN("origin"),
        ORIGIN_WHEN_CROSS_ORIGIN("origin-when-cross-origin"),
        SAME_ORIGIN("same-origin"),
        STRICT_ORIGIN("strict-origin"),
        STRICT_ORIGIN_WHEN_CROSS_ORIGIN("strict-origin-when-cross-origin");

        private String value;

        ReferrerPolicy(String value) {
            this.value = value;
        }

        public static ReferrerPolicy fromString(String s) {
            return java.util.Arrays.stream(ReferrerPolicy.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within ReferrerPolicy "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static ReferrerPolicy fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final java.lang.String url;

    private final java.util.Optional<java.lang.String> urlFragment;

    private final java.lang.String method;

    private final org.openqa.selenium.devtools.v134.network.model.Headers headers;

    private final java.util.Optional<java.lang.String> postData;

    private final java.util.Optional<java.lang.Boolean> hasPostData;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v134.network.model.PostDataEntry>> postDataEntries;

    private final java.util.Optional<org.openqa.selenium.devtools.v134.security.model.MixedContentType> mixedContentType;

    private final org.openqa.selenium.devtools.v134.network.model.ResourcePriority initialPriority;

    private final ReferrerPolicy referrerPolicy;

    private final java.util.Optional<java.lang.Boolean> isLinkPreload;

    private final java.util.Optional<org.openqa.selenium.devtools.v134.network.model.TrustTokenParams> trustTokenParams;

    private final java.util.Optional<java.lang.Boolean> isSameSite;

    public Request(java.lang.String url, java.util.Optional<java.lang.String> urlFragment, java.lang.String method, org.openqa.selenium.devtools.v134.network.model.Headers headers, java.util.Optional<java.lang.String> postData, java.util.Optional<java.lang.Boolean> hasPostData, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v134.network.model.PostDataEntry>> postDataEntries, java.util.Optional<org.openqa.selenium.devtools.v134.security.model.MixedContentType> mixedContentType, org.openqa.selenium.devtools.v134.network.model.ResourcePriority initialPriority, ReferrerPolicy referrerPolicy, java.util.Optional<java.lang.Boolean> isLinkPreload, java.util.Optional<org.openqa.selenium.devtools.v134.network.model.TrustTokenParams> trustTokenParams, java.util.Optional<java.lang.Boolean> isSameSite) {
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.urlFragment = urlFragment;
        this.method = java.util.Objects.requireNonNull(method, "method is required");
        this.headers = java.util.Objects.requireNonNull(headers, "headers is required");
        this.postData = postData;
        this.hasPostData = hasPostData;
        this.postDataEntries = postDataEntries;
        this.mixedContentType = mixedContentType;
        this.initialPriority = java.util.Objects.requireNonNull(initialPriority, "initialPriority is required");
        this.referrerPolicy = java.util.Objects.requireNonNull(referrerPolicy, "referrerPolicy is required");
        this.isLinkPreload = isLinkPreload;
        this.trustTokenParams = trustTokenParams;
        this.isSameSite = isSameSite;
    }

    /**
     * Request URL (without fragment).
     */
    public java.lang.String getUrl() {
        return url;
    }

    /**
     * Fragment of the requested URL starting with hash, if present.
     */
    public java.util.Optional<java.lang.String> getUrlFragment() {
        return urlFragment;
    }

    /**
     * HTTP request method.
     */
    public java.lang.String getMethod() {
        return method;
    }

    /**
     * HTTP request headers.
     */
    public org.openqa.selenium.devtools.v134.network.model.Headers getHeaders() {
        return headers;
    }

    /**
     * HTTP POST request data.
     * Use postDataEntries instead.
     */
    @Deprecated()
    public java.util.Optional<java.lang.String> getPostData() {
        return postData;
    }

    /**
     * True when the request has POST data. Note that postData might still be omitted when this flag is true when the data is too long.
     */
    public java.util.Optional<java.lang.Boolean> getHasPostData() {
        return hasPostData;
    }

    /**
     * Request body elements (post data broken into individual entries).
     */
    @Beta()
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v134.network.model.PostDataEntry>> getPostDataEntries() {
        return postDataEntries;
    }

    /**
     * The mixed content type of the request.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v134.security.model.MixedContentType> getMixedContentType() {
        return mixedContentType;
    }

    /**
     * Priority of the resource request at the time request is sent.
     */
    public org.openqa.selenium.devtools.v134.network.model.ResourcePriority getInitialPriority() {
        return initialPriority;
    }

    /**
     * The referrer policy of the request, as defined in https://www.w3.org/TR/referrer-policy/
     */
    public ReferrerPolicy getReferrerPolicy() {
        return referrerPolicy;
    }

    /**
     * Whether is loaded via link preload.
     */
    public java.util.Optional<java.lang.Boolean> getIsLinkPreload() {
        return isLinkPreload;
    }

    /**
     * Set for requests when the TrustToken API is used. Contains the parameters
     * passed by the developer (e.g. via "fetch") as understood by the backend.
     */
    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v134.network.model.TrustTokenParams> getTrustTokenParams() {
        return trustTokenParams;
    }

    /**
     * True if this resource request is considered to be the 'same site' as the
     * request corresponding to the main frame.
     */
    @Beta()
    public java.util.Optional<java.lang.Boolean> getIsSameSite() {
        return isSameSite;
    }

    private static Request fromJson(JsonInput input) {
        java.lang.String url = null;
        java.util.Optional<java.lang.String> urlFragment = java.util.Optional.empty();
        java.lang.String method = null;
        org.openqa.selenium.devtools.v134.network.model.Headers headers = null;
        java.util.Optional<java.lang.String> postData = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> hasPostData = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v134.network.model.PostDataEntry>> postDataEntries = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v134.security.model.MixedContentType> mixedContentType = java.util.Optional.empty();
        org.openqa.selenium.devtools.v134.network.model.ResourcePriority initialPriority = null;
        ReferrerPolicy referrerPolicy = null;
        java.util.Optional<java.lang.Boolean> isLinkPreload = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v134.network.model.TrustTokenParams> trustTokenParams = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> isSameSite = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "url":
                    url = input.nextString();
                    break;
                case "urlFragment":
                    urlFragment = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "method":
                    method = input.nextString();
                    break;
                case "headers":
                    headers = input.read(org.openqa.selenium.devtools.v134.network.model.Headers.class);
                    break;
                case "postData":
                    postData = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "hasPostData":
                    hasPostData = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "postDataEntries":
                    postDataEntries = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v134.network.model.PostDataEntry.class));
                    break;
                case "mixedContentType":
                    mixedContentType = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v134.security.model.MixedContentType.class));
                    break;
                case "initialPriority":
                    initialPriority = input.read(org.openqa.selenium.devtools.v134.network.model.ResourcePriority.class);
                    break;
                case "referrerPolicy":
                    referrerPolicy = ReferrerPolicy.fromString(input.nextString());
                    break;
                case "isLinkPreload":
                    isLinkPreload = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "trustTokenParams":
                    trustTokenParams = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v134.network.model.TrustTokenParams.class));
                    break;
                case "isSameSite":
                    isSameSite = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new Request(url, urlFragment, method, headers, postData, hasPostData, postDataEntries, mixedContentType, initialPriority, referrerPolicy, isLinkPreload, trustTokenParams, isSameSite);
    }
}
