/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v134.network.model;

import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v134.network.model.ReportId;
import org.openqa.selenium.devtools.v134.network.model.ReportStatus;
import org.openqa.selenium.devtools.v134.network.model.TimeSinceEpoch;
import org.openqa.selenium.json.JsonInput;

@Beta
public class ReportingApiReport {
    private final ReportId id;
    private final String initiatorUrl;
    private final String destination;
    private final String type;
    private final TimeSinceEpoch timestamp;
    private final Integer depth;
    private final Integer completedAttempts;
    private final Map<String, Object> body;
    private final ReportStatus status;

    public ReportingApiReport(ReportId id, String initiatorUrl, String destination, String type, TimeSinceEpoch timestamp, Integer depth, Integer completedAttempts, Map<String, Object> body, ReportStatus status) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.initiatorUrl = Objects.requireNonNull(initiatorUrl, "initiatorUrl is required");
        this.destination = Objects.requireNonNull(destination, "destination is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.depth = Objects.requireNonNull(depth, "depth is required");
        this.completedAttempts = Objects.requireNonNull(completedAttempts, "completedAttempts is required");
        this.body = Objects.requireNonNull(body, "body is required");
        this.status = Objects.requireNonNull(status, "status is required");
    }

    public ReportId getId() {
        return this.id;
    }

    public String getInitiatorUrl() {
        return this.initiatorUrl;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getType() {
        return this.type;
    }

    public TimeSinceEpoch getTimestamp() {
        return this.timestamp;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public Integer getCompletedAttempts() {
        return this.completedAttempts;
    }

    public Map<String, Object> getBody() {
        return this.body;
    }

    public ReportStatus getStatus() {
        return this.status;
    }

    private static ReportingApiReport fromJson(JsonInput input) {
        ReportId id = null;
        String initiatorUrl = null;
        String destination = null;
        String type = null;
        TimeSinceEpoch timestamp = null;
        Integer depth = 0;
        Integer completedAttempts = 0;
        Map body = null;
        ReportStatus status = null;
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = (ReportId)input.read(ReportId.class);
                    continue block22;
                }
                case "initiatorUrl": {
                    initiatorUrl = input.nextString();
                    continue block22;
                }
                case "destination": {
                    destination = input.nextString();
                    continue block22;
                }
                case "type": {
                    type = input.nextString();
                    continue block22;
                }
                case "timestamp": {
                    timestamp = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block22;
                }
                case "depth": {
                    depth = input.nextNumber().intValue();
                    continue block22;
                }
                case "completedAttempts": {
                    completedAttempts = input.nextNumber().intValue();
                    continue block22;
                }
                case "body": {
                    body = (Map)input.read(Map.class);
                    continue block22;
                }
                case "status": {
                    status = (ReportStatus)((Object)input.read(ReportStatus.class));
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ReportingApiReport(id, initiatorUrl, destination, type, timestamp, depth, completedAttempts, body, status);
    }
}

