/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v136.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v136.audits.model.InsightType;
import org.openqa.selenium.json.JsonInput;

public class CookieIssueInsight {
    private final InsightType type;
    private final Optional<String> tableEntryUrl;

    public CookieIssueInsight(InsightType type, Optional<String> tableEntryUrl) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.tableEntryUrl = tableEntryUrl;
    }

    public InsightType getType() {
        return this.type;
    }

    public Optional<String> getTableEntryUrl() {
        return this.tableEntryUrl;
    }

    private static CookieIssueInsight fromJson(JsonInput input) {
        InsightType type = null;
        Optional<String> tableEntryUrl = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = (InsightType)((Object)input.read(InsightType.class));
                    continue block8;
                }
                case "tableEntryUrl": {
                    tableEntryUrl = Optional.ofNullable(input.nextString());
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CookieIssueInsight(type, tableEntryUrl);
    }
}

