/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v138.storage.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v138.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v138.page.model.FrameId;
import org.openqa.selenium.devtools.v138.storage.model.SharedStorageAccessMethod;
import org.openqa.selenium.devtools.v138.target.model.TargetID;
import org.openqa.selenium.json.JsonInput;

public class SharedStorageWorkletOperationExecutionFinished {
    private final TimeSinceEpoch finishedTime;
    private final Integer executionTime;
    private final SharedStorageAccessMethod method;
    private final String operationId;
    private final TargetID workletTargetId;
    private final FrameId mainFrameId;
    private final String ownerOrigin;

    public SharedStorageWorkletOperationExecutionFinished(TimeSinceEpoch finishedTime, Integer executionTime, SharedStorageAccessMethod method, String operationId, TargetID workletTargetId, FrameId mainFrameId, String ownerOrigin) {
        this.finishedTime = Objects.requireNonNull(finishedTime, "finishedTime is required");
        this.executionTime = Objects.requireNonNull(executionTime, "executionTime is required");
        this.method = Objects.requireNonNull(method, "method is required");
        this.operationId = Objects.requireNonNull(operationId, "operationId is required");
        this.workletTargetId = Objects.requireNonNull(workletTargetId, "workletTargetId is required");
        this.mainFrameId = Objects.requireNonNull(mainFrameId, "mainFrameId is required");
        this.ownerOrigin = Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
    }

    public TimeSinceEpoch getFinishedTime() {
        return this.finishedTime;
    }

    public Integer getExecutionTime() {
        return this.executionTime;
    }

    public SharedStorageAccessMethod getMethod() {
        return this.method;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public TargetID getWorkletTargetId() {
        return this.workletTargetId;
    }

    public FrameId getMainFrameId() {
        return this.mainFrameId;
    }

    public String getOwnerOrigin() {
        return this.ownerOrigin;
    }

    private static SharedStorageWorkletOperationExecutionFinished fromJson(JsonInput input) {
        TimeSinceEpoch finishedTime = null;
        Integer executionTime = 0;
        SharedStorageAccessMethod method = null;
        String operationId = null;
        TargetID workletTargetId = null;
        FrameId mainFrameId = null;
        String ownerOrigin = null;
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "finishedTime": {
                    finishedTime = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block18;
                }
                case "executionTime": {
                    executionTime = input.nextNumber().intValue();
                    continue block18;
                }
                case "method": {
                    method = (SharedStorageAccessMethod)((Object)input.read(SharedStorageAccessMethod.class));
                    continue block18;
                }
                case "operationId": {
                    operationId = input.nextString();
                    continue block18;
                }
                case "workletTargetId": {
                    workletTargetId = (TargetID)input.read(TargetID.class);
                    continue block18;
                }
                case "mainFrameId": {
                    mainFrameId = (FrameId)input.read(FrameId.class);
                    continue block18;
                }
                case "ownerOrigin": {
                    ownerOrigin = input.nextString();
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SharedStorageWorkletOperationExecutionFinished(finishedTime, executionTime, method, operationId, workletTargetId, mainFrameId, ownerOrigin);
    }
}

