/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;

class Preferences {
    private static final String MAX_SCRIPT_RUN_TIME_KEY = "dom.max_script_run_time";
    private static final int DEFAULT_MAX_SCRIPT_RUN_TIME = 30;
    private static final Pattern PREFERENCE_PATTERN = Pattern.compile("user_pref\\(\"([^\"]+)\", (\"?.+?\"?)\\);");
    private final Map<String, Object> immutablePrefs = new HashMap<String, Object>();
    private final Map<String, Object> allPrefs = new HashMap<String, Object>();

    public Preferences() {
    }

    public Preferences(Reader defaults) {
        this.readDefaultPreferences(defaults);
    }

    public Preferences(Reader defaults, File userPrefs) {
        this.readDefaultPreferences(defaults);
        try (BufferedReader reader = Files.newBufferedReader(userPrefs.toPath(), Charset.defaultCharset());){
            this.readPreferences(reader);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public Preferences(File userPrefs) {
        this.readUserPrefs(userPrefs);
    }

    public Preferences(Reader defaults, Reader reader) {
        this.readDefaultPreferences(defaults);
        try (Reader reader2 = reader;){
            this.readPreferences(reader);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private void readUserPrefs(File userPrefs) {
        try (BufferedReader reader = Files.newBufferedReader(userPrefs.toPath(), Charset.defaultCharset());){
            this.readPreferences(reader);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private void readDefaultPreferences(Reader defaultsReader) {
        try {
            String rawJson;
            try (StringWriter writer = new StringWriter();){
                defaultsReader.transferTo(writer);
                rawJson = writer.getBuffer().toString();
            }
            Map map = (Map)new Json().toType(rawJson, Json.MAP_TYPE);
            Map frozen = (Map)map.get("frozen");
            frozen.forEach((key, value) -> {
                if (value instanceof Long) {
                    value = ((Long)value).intValue();
                }
                this.setPreference((String)key, value);
                this.immutablePrefs.put((String)key, value);
            });
            Map mutable = (Map)map.get("mutable");
            mutable.forEach(this::setPreference);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public void setPreference(String key, Object value) {
        if (value instanceof String) {
            if (this.isStringified((String)value)) {
                throw new IllegalArgumentException(String.format("Preference values must be plain strings: %s: %s", key, value));
            }
            this.allPrefs.put(key, value);
        } else if (value instanceof Number) {
            this.allPrefs.put(key, ((Number)value).intValue());
        } else {
            this.allPrefs.put(key, value);
        }
    }

    private void readPreferences(Reader reader) throws IOException {
        BufferedReader allLines = new BufferedReader(reader);
        String line = allLines.readLine();
        while (line != null) {
            Matcher matcher = PREFERENCE_PATTERN.matcher(line);
            if (matcher.matches()) {
                this.allPrefs.put(matcher.group(1), this.preferenceAsValue(matcher.group(2)));
            }
            line = allLines.readLine();
        }
    }

    public void addTo(Preferences prefs) {
        prefs.allPrefs.putAll(this.allPrefs);
    }

    public void writeTo(Writer writer) throws IOException {
        for (Map.Entry<String, Object> pref : this.allPrefs.entrySet()) {
            writer.append("user_pref(\"").append(pref.getKey()).append("\", ");
            writer.append(this.valueAsPreference(pref.getValue()));
            writer.append(");\n");
        }
    }

    private String valueAsPreference(Object value) {
        if (value instanceof String) {
            return "\"" + this.escapeValueAsPreference((String)value) + "\"";
        }
        return this.escapeValueAsPreference(String.valueOf(value));
    }

    private String escapeValueAsPreference(String value) {
        return value.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"");
    }

    private Object preferenceAsValue(String toConvert) {
        if (toConvert.startsWith("\"") && toConvert.endsWith("\"")) {
            return toConvert.substring(1, toConvert.length() - 1).replaceAll("\\\\\\\\", "\\\\");
        }
        if ("false".equals(toConvert) || "true".equals(toConvert)) {
            return Boolean.parseBoolean(toConvert);
        }
        try {
            return Integer.parseInt(toConvert);
        }
        catch (NumberFormatException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    Object getPreference(String key) {
        return this.allPrefs.get(key);
    }

    private boolean isStringified(String value) {
        return value.startsWith("\"") && value.endsWith("\"");
    }

    private void checkPreference(String key, Object value) {
        Require.nonNull((String)"Key", (Object)key);
        Require.nonNull((String)"Value", (Object)value);
        Require.stateCondition((!this.immutablePrefs.containsKey(key) || this.immutablePrefs.containsKey(key) && value.equals(this.immutablePrefs.get(key)) ? 1 : 0) != 0, (String)"Preference %s may not be overridden: frozen value=%s, requested value=%s", (Object[])new Object[]{key, this.immutablePrefs.get(key), value});
        if (MAX_SCRIPT_RUN_TIME_KEY.equals(key)) {
            int n;
            if (value instanceof String) {
                n = Integer.parseInt((String)value);
            } else if (value instanceof Integer) {
                n = (Integer)value;
            } else {
                throw new IllegalStateException(String.format("%s value must be a number: %s", MAX_SCRIPT_RUN_TIME_KEY, value.getClass().getName()));
            }
            Require.stateCondition((n == 0 || n >= 30 ? 1 : 0) != 0, (String)"%s must be == 0 || >= %s", (Object[])new Object[]{MAX_SCRIPT_RUN_TIME_KEY, 30});
        }
    }
}

