/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browsingcontext;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WindowType;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.browsingcontext.BrowsingContextInfo;
import org.openqa.selenium.bidi.browsingcontext.NavigationResult;
import org.openqa.selenium.bidi.browsingcontext.ReadinessState;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;
import org.openqa.selenium.print.PrintOptions;

public class BrowsingContext {
    private final String id;
    private final BiDi bidi;
    private static final String CONTEXT = "context";
    private static final String RELOAD = "browsingContext.reload";
    private static final String HANDLE_USER_PROMPT = "browsingContext.handleUserPrompt";
    protected static final Type LIST_OF_BROWSING_CONTEXT_INFO = new TypeToken<List<BrowsingContextInfo>>(){}.getType();
    private final Function<JsonInput, String> browsingContextIdMapper = jsonInput -> {
        Map result = (Map)jsonInput.read(Map.class);
        return result.getOrDefault(CONTEXT, "").toString();
    };
    private final Function<JsonInput, NavigationResult> navigationInfoMapper = jsonInput -> (NavigationResult)jsonInput.read(NavigationResult.class);
    private final Function<JsonInput, List<BrowsingContextInfo>> browsingContextInfoListMapper = jsonInput -> {
        Map result = (Map)jsonInput.read(Map.class);
        List contexts = result.getOrDefault("contexts", new ArrayList());
        if (contexts.isEmpty()) {
            return new ArrayList();
        }
        Json json = new Json();
        String dtr = json.toJson((Object)contexts);
        return (List)json.toType(dtr, LIST_OF_BROWSING_CONTEXT_INFO);
    };

    public BrowsingContext(WebDriver driver, String id) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        Require.nonNull((String)"Browsing Context id", (Object)id);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        Require.precondition((!id.isEmpty() ? 1 : 0) != 0, (String)"Browsing Context id cannot be empty", (Object[])new Object[0]);
        this.bidi = ((HasBiDi)driver).getBiDi();
        this.id = id;
    }

    public BrowsingContext(WebDriver driver, WindowType type) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)driver).getBiDi();
        this.id = this.create(type);
    }

    public BrowsingContext(WebDriver driver, WindowType type, String referenceContextId) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        Require.nonNull((String)"Reference browsing context id", (Object)referenceContextId);
        Require.precondition((!referenceContextId.isEmpty() ? 1 : 0) != 0, (String)"Reference Context id cannot be empty", (Object[])new Object[0]);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)driver).getBiDi();
        this.id = this.create(type, referenceContextId);
    }

    public String getId() {
        return this.id;
    }

    private String create(WindowType type) {
        return this.bidi.send(new Command<String>("browsingContext.create", Map.of("type", type.toString()), this.browsingContextIdMapper));
    }

    private String create(WindowType type, String referenceContext) {
        return this.bidi.send(new Command<String>("browsingContext.create", Map.of("type", type.toString(), "referenceContext", referenceContext), this.browsingContextIdMapper));
    }

    public NavigationResult navigate(String url) {
        return this.bidi.send(new Command<NavigationResult>("browsingContext.navigate", Map.of(CONTEXT, this.id, "url", url), this.navigationInfoMapper));
    }

    public NavigationResult navigate(String url, ReadinessState readinessState) {
        return this.bidi.send(new Command<NavigationResult>("browsingContext.navigate", Map.of(CONTEXT, this.id, "url", url, "wait", readinessState.toString()), this.navigationInfoMapper));
    }

    public List<BrowsingContextInfo> getTree() {
        return this.bidi.send(new Command<List<BrowsingContextInfo>>("browsingContext.getTree", Map.of("root", this.id), this.browsingContextInfoListMapper));
    }

    public List<BrowsingContextInfo> getTree(int maxDepth) {
        return this.bidi.send(new Command<List<BrowsingContextInfo>>("browsingContext.getTree", Map.of("root", this.id, "maxDepth", maxDepth), this.browsingContextInfoListMapper));
    }

    public List<BrowsingContextInfo> getTopLevelContexts() {
        return this.bidi.send(new Command<List<BrowsingContextInfo>>("browsingContext.getTree", new HashMap<String, Object>(), this.browsingContextInfoListMapper));
    }

    public NavigationResult reload() {
        return this.bidi.send(new Command<NavigationResult>(RELOAD, Map.of(CONTEXT, this.id), this.navigationInfoMapper));
    }

    private NavigationResult reload(boolean ignoreCache) {
        return this.bidi.send(new Command<NavigationResult>(RELOAD, Map.of(CONTEXT, this.id, "ignoreCache", ignoreCache), this.navigationInfoMapper));
    }

    public NavigationResult reload(ReadinessState readinessState) {
        return this.bidi.send(new Command<NavigationResult>(RELOAD, Map.of(CONTEXT, this.id, "wait", readinessState.toString()), this.navigationInfoMapper));
    }

    private NavigationResult reload(boolean ignoreCache, ReadinessState readinessState) {
        return this.bidi.send(new Command<NavigationResult>(RELOAD, Map.of(CONTEXT, this.id, "ignoreCache", ignoreCache, "wait", readinessState.toString()), this.navigationInfoMapper));
    }

    public void handleUserPrompt() {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, Map.of(CONTEXT, this.id)));
    }

    public void handleUserPrompt(boolean accept) {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, Map.of(CONTEXT, this.id, "accept", accept)));
    }

    public void handleUserPrompt(String userText) {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, Map.of(CONTEXT, this.id, "userText", userText)));
    }

    public void handleUserPrompt(boolean accept, String userText) {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, Map.of(CONTEXT, this.id, "accept", accept, "userText", userText)));
    }

    public String captureScreenshot() {
        return this.bidi.send(new Command<String>("browsingContext.captureScreenshot", Map.of(CONTEXT, this.id), jsonInput -> {
            Map result = (Map)jsonInput.read(Map.class);
            return (String)result.get("data");
        }));
    }

    public String captureBoxScreenshot(double x, double y, double width, double height) {
        return this.bidi.send(new Command<String>("browsingContext.captureScreenshot", Map.of(CONTEXT, this.id, "clip", Map.of("type", "viewport", "x", x, "y", y, "width", width, "height", height)), jsonInput -> {
            Map result = (Map)jsonInput.read(Map.class);
            return (String)result.get("data");
        }));
    }

    public String captureElementScreenshot(String elementId) {
        return this.bidi.send(new Command<String>("browsingContext.captureScreenshot", Map.of(CONTEXT, this.id, "clip", Map.of("type", "element", "element", Map.of("sharedId", elementId), "scrollIntoView", false)), jsonInput -> {
            Map result = (Map)jsonInput.read(Map.class);
            return (String)result.get("data");
        }));
    }

    public String captureElementScreenshot(String elementId, boolean scrollIntoView) {
        return this.bidi.send(new Command<String>("browsingContext.captureScreenshot", Map.of(CONTEXT, this.id, "clip", Map.of("type", "element", "element", Map.of("sharedId", elementId), "scrollIntoView", scrollIntoView)), jsonInput -> {
            Map result = (Map)jsonInput.read(Map.class);
            return (String)result.get("data");
        }));
    }

    public void setViewport(double width, double height) {
        Require.positive((String)"Viewport width", (Double)width);
        Require.positive((String)"Viewport height", (Double)height);
        this.bidi.send(new Command("browsingContext.setViewport", Map.of(CONTEXT, this.id, "viewport", Map.of("width", width, "height", height))));
    }

    public void setViewport(double width, double height, double devicePixelRatio) {
        Require.positive((String)"Viewport width", (Double)width);
        Require.positive((String)"Viewport height", (Double)height);
        Require.positive((String)"Device pixel ratio.", (Double)devicePixelRatio);
        this.bidi.send(new Command("browsingContext.setViewport", Map.of(CONTEXT, this.id, "viewport", Map.of("width", width, "height", height), "devicePixelRatio", devicePixelRatio)));
    }

    public void activate() {
        this.bidi.send(new Command("browsingContext.activate", Map.of(CONTEXT, this.id)));
    }

    public String print(PrintOptions printOptions) {
        Map printOptionsParams = printOptions.toMap();
        printOptionsParams.put(CONTEXT, this.id);
        return this.bidi.send(new Command<String>("browsingContext.print", (Map<String, Object>)printOptionsParams, jsonInput -> {
            Map result = (Map)jsonInput.read(Map.class);
            return (String)result.get("data");
        }));
    }

    public void close() {
        this.bidi.send(new Command("browsingContext.close", Map.of(CONTEXT, this.id)));
    }
}

