/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.codec;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;

public abstract class AbstractHttpCommandCodec
implements CommandCodec<HttpRequest> {
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/').omitEmptyStrings();
    private static final String SESSION_ID_PARAM = "sessionId";
    private final ConcurrentHashMap<String, CommandSpec> nameToSpec = new ConcurrentHashMap();
    private final Map<String, String> aliases = new HashMap<String, String>();
    private final Json json = new Json();

    public AbstractHttpCommandCodec() {
        this.defineCommand("status", AbstractHttpCommandCodec.get("/status"));
        String sessionId = "/session/:sessionId";
        this.defineCommand("getAllSessions", AbstractHttpCommandCodec.get("/sessions"));
        this.defineCommand("newSession", AbstractHttpCommandCodec.post("/session"));
        this.defineCommand("getCapabilities", AbstractHttpCommandCodec.get(sessionId));
        this.defineCommand("quit", AbstractHttpCommandCodec.delete(sessionId));
        this.defineCommand("getSessionLogs", AbstractHttpCommandCodec.post("/logs"));
        this.defineCommand("getLog", AbstractHttpCommandCodec.post(sessionId + "/log"));
        this.defineCommand("getAvailableLogTypes", AbstractHttpCommandCodec.get(sessionId + "/log/types"));
        this.defineCommand("switchToFrame", AbstractHttpCommandCodec.post(sessionId + "/frame"));
        this.defineCommand("switchToParentFrame", AbstractHttpCommandCodec.post(sessionId + "/frame/parent"));
        String window = sessionId + "/window";
        this.defineCommand("close", AbstractHttpCommandCodec.delete(window));
        this.defineCommand("switchToWindow", AbstractHttpCommandCodec.post(window));
        this.defineCommand("newWindow", AbstractHttpCommandCodec.post(window + "/new"));
        this.defineCommand("fullscreenCurrentWindow", AbstractHttpCommandCodec.post(window + "/fullscreen"));
        this.defineCommand("getCurrentUrl", AbstractHttpCommandCodec.get(sessionId + "/url"));
        this.defineCommand("get", AbstractHttpCommandCodec.post(sessionId + "/url"));
        this.defineCommand("goBack", AbstractHttpCommandCodec.post(sessionId + "/back"));
        this.defineCommand("goForward", AbstractHttpCommandCodec.post(sessionId + "/forward"));
        this.defineCommand("refresh", AbstractHttpCommandCodec.post(sessionId + "/refresh"));
        this.defineCommand("setAlertCredentials", AbstractHttpCommandCodec.post(sessionId + "/alert/credentials"));
        this.defineCommand("screenshot", AbstractHttpCommandCodec.get(sessionId + "/screenshot"));
        this.defineCommand("elementScreenshot", AbstractHttpCommandCodec.get(sessionId + "/element/:id/screenshot"));
        this.defineCommand("getTitle", AbstractHttpCommandCodec.get(sessionId + "/title"));
        this.defineCommand("findElement", AbstractHttpCommandCodec.post(sessionId + "/element"));
        this.defineCommand("findElements", AbstractHttpCommandCodec.post(sessionId + "/elements"));
        String elementId = sessionId + "/element/:id";
        this.defineCommand("clickElement", AbstractHttpCommandCodec.post(elementId + "/click"));
        this.defineCommand("clearElement", AbstractHttpCommandCodec.post(elementId + "/clear"));
        this.defineCommand("getElementValueOfCssProperty", AbstractHttpCommandCodec.get(elementId + "/css/:propertyName"));
        this.defineCommand("findChildElement", AbstractHttpCommandCodec.post(elementId + "/element"));
        this.defineCommand("findChildElements", AbstractHttpCommandCodec.post(elementId + "/elements"));
        this.defineCommand("isElementEnabled", AbstractHttpCommandCodec.get(elementId + "/enabled"));
        this.defineCommand("elementEquals", AbstractHttpCommandCodec.get(elementId + "/equals/:other"));
        this.defineCommand("getElementRect", AbstractHttpCommandCodec.get(elementId + "/rect"));
        this.defineCommand("getElementLocation", AbstractHttpCommandCodec.get(elementId + "/location"));
        this.defineCommand("getElementTagName", AbstractHttpCommandCodec.get(elementId + "/name"));
        this.defineCommand("isElementSelected", AbstractHttpCommandCodec.get(elementId + "/selected"));
        this.defineCommand("getElementSize", AbstractHttpCommandCodec.get(elementId + "/size"));
        this.defineCommand("getElementText", AbstractHttpCommandCodec.get(elementId + "/text"));
        this.defineCommand("sendKeysToElement", AbstractHttpCommandCodec.post(elementId + "/value"));
        String cookie = sessionId + "/cookie";
        this.defineCommand("getCookies", AbstractHttpCommandCodec.get(cookie));
        this.defineCommand("getCookie", AbstractHttpCommandCodec.get(cookie + "/:name"));
        this.defineCommand("addCookie", AbstractHttpCommandCodec.post(cookie));
        this.defineCommand("deleteAllCookies", AbstractHttpCommandCodec.delete(cookie));
        this.defineCommand("deleteCookie", AbstractHttpCommandCodec.delete(cookie + "/:name"));
        String timeouts = sessionId + "/timeouts";
        this.defineCommand("getTimeouts", AbstractHttpCommandCodec.get(timeouts));
        this.defineCommand("setTimeout", AbstractHttpCommandCodec.post(timeouts));
        this.defineCommand("setScriptTimeout", AbstractHttpCommandCodec.post(timeouts + "/async_script"));
        this.defineCommand("implicitlyWait", AbstractHttpCommandCodec.post(timeouts + "/implicit_wait"));
        this.defineCommand("getStatus", AbstractHttpCommandCodec.get(sessionId + "/application_cache/status"));
        this.defineCommand("isBrowserOnline", AbstractHttpCommandCodec.get(sessionId + "/browser_connection"));
        this.defineCommand("setBrowserOnline", AbstractHttpCommandCodec.post(sessionId + "/browser_connection"));
        this.defineCommand("getLocation", AbstractHttpCommandCodec.get(sessionId + "/location"));
        this.defineCommand("setLocation", AbstractHttpCommandCodec.post(sessionId + "/location"));
        this.defineCommand("getScreenOrientation", AbstractHttpCommandCodec.get(sessionId + "/orientation"));
        this.defineCommand("setScreenOrientation", AbstractHttpCommandCodec.post(sessionId + "/orientation"));
        this.defineCommand("getScreenRotation", AbstractHttpCommandCodec.get(sessionId + "/rotation"));
        this.defineCommand("setScreenRotation", AbstractHttpCommandCodec.post(sessionId + "/rotation"));
        this.defineCommand("getNetworkConnection", AbstractHttpCommandCodec.get(sessionId + "/network_connection"));
        this.defineCommand("setNetworkConnection", AbstractHttpCommandCodec.post(sessionId + "/network_connection"));
        this.defineCommand("switchToContext", AbstractHttpCommandCodec.post(sessionId + "/context"));
        this.defineCommand("getCurrentContextHandle", AbstractHttpCommandCodec.get(sessionId + "/context"));
        this.defineCommand("getContextHandles", AbstractHttpCommandCodec.get(sessionId + "/contexts"));
        String webauthn = sessionId + "/webauthn/authenticator";
        String webauthnId = webauthn + "/:authenticatorId";
        this.defineCommand("addVirtualAuthenticator", AbstractHttpCommandCodec.post(webauthn));
        this.defineCommand("removeVirtualAuthenticator", AbstractHttpCommandCodec.delete(webauthnId));
        this.defineCommand("addCredential", AbstractHttpCommandCodec.post(webauthnId + "/credential"));
        this.defineCommand("getCredentials", AbstractHttpCommandCodec.get(webauthnId + "/credentials"));
        this.defineCommand("removeCredential", AbstractHttpCommandCodec.delete(webauthnId + "/credentials/:credentialId"));
        this.defineCommand("removeAllCredentials", AbstractHttpCommandCodec.delete(webauthnId + "/credentials"));
        this.defineCommand("setUserVerified", AbstractHttpCommandCodec.post(webauthnId + "/uv"));
        String fedcm = sessionId + "/fedcm";
        this.defineCommand("cancelDialog", AbstractHttpCommandCodec.post(fedcm + "/canceldialog"));
        this.defineCommand("selectAccount", AbstractHttpCommandCodec.post(fedcm + "/selectaccount"));
        this.defineCommand("getAccounts", AbstractHttpCommandCodec.get(fedcm + "/accountlist"));
        this.defineCommand("getFedCmTitle", AbstractHttpCommandCodec.get(fedcm + "/gettitle"));
        this.defineCommand("getFedCmDialogType", AbstractHttpCommandCodec.get(fedcm + "/getdialogtype"));
        this.defineCommand("setDelayEnabled", AbstractHttpCommandCodec.post(fedcm + "/setdelayenabled"));
        this.defineCommand("resetCooldown", AbstractHttpCommandCodec.post(fedcm + "/resetCooldown"));
    }

    protected static CommandSpec delete(String path) {
        return new CommandSpec(HttpMethod.DELETE, path);
    }

    protected static CommandSpec get(String path) {
        return new CommandSpec(HttpMethod.GET, path);
    }

    protected static CommandSpec post(String path) {
        return new CommandSpec(HttpMethod.POST, path);
    }

    @Override
    public boolean isSupported(String commandName) {
        Require.nonNull((String)"Command name", (Object)commandName);
        return this.nameToSpec.containsKey(commandName) || this.aliases.containsKey(commandName);
    }

    @Override
    public HttpRequest encode(Command command) {
        String name = this.aliases.getOrDefault(command.getName(), command.getName());
        CommandSpec spec = this.nameToSpec.get(name);
        if (spec == null) {
            throw new UnsupportedCommandException(command.getName());
        }
        Map<String, ?> parameters = this.amendParameters(command.getName(), command.getParameters());
        String uri = this.buildUri(name, command.getSessionId(), parameters, spec);
        HttpRequest request = new HttpRequest(spec.method, uri);
        if (HttpMethod.POST == spec.method) {
            String content = this.json.toJson(parameters);
            byte[] data = content.getBytes(StandardCharsets.UTF_8);
            request.setHeader("Content-Length", String.valueOf(data.length));
            request.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
            request.setContent(Contents.bytes((byte[])data));
        }
        if (HttpMethod.GET == spec.method) {
            request.setHeader("Cache-Control", "no-cache");
        }
        return request;
    }

    protected abstract Map<String, ?> amendParameters(String var1, Map<String, ?> var2);

    @Override
    public Command decode(HttpRequest encodedCommand) {
        String id;
        String path = Strings.isNullOrEmpty((String)encodedCommand.getUri()) ? "/" : encodedCommand.getUri();
        ImmutableList parts = ImmutableList.copyOf((Iterable)PATH_SPLITTER.split((CharSequence)path));
        int minPathLength = Integer.MAX_VALUE;
        CommandSpec spec = null;
        String name = null;
        for (Map.Entry<String, CommandSpec> nameValue : this.nameToSpec.entrySet()) {
            if (nameValue.getValue().pathSegments.size() >= minPathLength || !nameValue.getValue().isFor(encodedCommand.getMethod(), (ImmutableList<String>)parts)) continue;
            name = nameValue.getKey();
            spec = nameValue.getValue();
        }
        if (name == null) {
            throw new UnsupportedCommandException(encodedCommand.getMethod() + " " + encodedCommand.getUri());
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        spec.parsePathParameters((ImmutableList<String>)parts, parameters);
        String content = Contents.string((HttpMessage)encodedCommand);
        if (!content.isEmpty()) {
            Map tmp = (Map)this.json.toType(content, Json.MAP_TYPE);
            parameters.putAll(tmp);
        }
        SessionId sessionId = null;
        if (parameters.containsKey(SESSION_ID_PARAM) && (id = (String)parameters.remove(SESSION_ID_PARAM)) != null) {
            sessionId = new SessionId(id);
        }
        return new Command(sessionId, name, parameters);
    }

    @Override
    public void defineCommand(String name, HttpMethod method, String pathPattern) {
        this.defineCommand(name, new CommandSpec(method, pathPattern));
    }

    @Override
    public void alias(String commandName, String isAnAliasFor) {
        this.aliases.put(commandName, isAnAliasFor);
    }

    protected void defineCommand(String name, CommandSpec spec) {
        this.nameToSpec.put((String)Require.nonNull((String)"Name", (Object)name), spec);
    }

    private String buildUri(String commandName, SessionId sessionId, Map<String, ?> parameters, CommandSpec spec) {
        StringBuilder builder = new StringBuilder();
        for (String part : spec.pathSegments) {
            if (part.isEmpty()) continue;
            builder.append("/");
            if (part.startsWith(":")) {
                builder.append(this.getParameter(part.substring(1), commandName, sessionId, parameters));
                continue;
            }
            builder.append(part);
        }
        return builder.toString();
    }

    private String getParameter(String parameterName, String commandName, SessionId sessionId, Map<String, ?> parameters) {
        if (SESSION_ID_PARAM.equals(parameterName)) {
            Require.argument((String)"Session id", (Object)sessionId).nonNull("Session ID may not be null for command %s", new Object[]{commandName});
            return sessionId.toString();
        }
        Object value = parameters.get(parameterName);
        Require.argument((String)"Parameter", value).nonNull("Missing required parameter \"%s\" for command %s", new Object[]{parameterName, commandName});
        return Urls.urlEncode((String)String.valueOf(value));
    }

    protected static class CommandSpec {
        private final HttpMethod method;
        private final String path;
        private final ImmutableList<String> pathSegments;

        private CommandSpec(HttpMethod method, String path) {
            this.method = (HttpMethod)Require.nonNull((String)"HTTP method", (Object)method);
            this.path = path;
            this.pathSegments = ImmutableList.copyOf((Iterable)PATH_SPLITTER.split((CharSequence)path));
        }

        public boolean equals(Object o) {
            if (o instanceof CommandSpec) {
                CommandSpec that = (CommandSpec)o;
                return this.method.equals((Object)that.method) && this.path.equals(that.path);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.method, this.path});
        }

        boolean isFor(HttpMethod method, ImmutableList<String> parts) {
            if (!this.method.equals((Object)method)) {
                return false;
            }
            if (parts.size() != this.pathSegments.size()) {
                return false;
            }
            for (int i = 0; i < parts.size(); ++i) {
                String reqPart = (String)parts.get(i);
                String specPart = (String)this.pathSegments.get(i);
                if (specPart.startsWith(":") || specPart.equals(reqPart)) continue;
                return false;
            }
            return true;
        }

        void parsePathParameters(ImmutableList<String> parts, Map<String, Object> parameters) {
            for (int i = 0; i < parts.size(); ++i) {
                if (!((String)this.pathSegments.get(i)).startsWith(":")) continue;
                parameters.put(((String)this.pathSegments.get(i)).substring(1), parts.get(i));
            }
        }
    }
}

