/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browsingcontext;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.openqa.selenium.bidi.browsingcontext.DownloadCanceled;
import org.openqa.selenium.bidi.browsingcontext.DownloadCompleted;
import org.openqa.selenium.bidi.browsingcontext.NavigationInfo;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;

public class DownloadEnded {
    private static final String CANCELED = "canceled";
    private static final String COMPLETE = "complete";
    private final NavigationInfo downloadParams;

    public DownloadEnded(NavigationInfo downloadParams) {
        this.downloadParams = downloadParams;
    }

    public static DownloadEnded fromJson(JsonInput input) {
        Map jsonMap = (Map)input.read(Map.class);
        String status = (String)jsonMap.get("status");
        try (StringReader reader = new StringReader(new Json().toJson((Object)jsonMap));
             JsonInput jsonInput = new Json().newInput((Reader)reader);){
            if (CANCELED.equals(status)) {
                DownloadEnded downloadEnded = new DownloadEnded(DownloadCanceled.fromJson(jsonInput));
                return downloadEnded;
            }
            if (COMPLETE.equals(status)) {
                DownloadEnded downloadEnded = new DownloadEnded(DownloadCompleted.fromJson(jsonInput));
                return downloadEnded;
            }
            throw new IllegalArgumentException("status must be either 'canceled' or 'complete', but got: " + status);
        }
    }

    public NavigationInfo getDownloadParams() {
        return this.downloadParams;
    }

    public boolean isCanceled() {
        return this.downloadParams instanceof DownloadCanceled;
    }

    public boolean isCompleted() {
        return this.downloadParams instanceof DownloadCompleted;
    }
}

