/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store;

import java.io.Serializable;
import java.util.Map;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.shoal.ha.cache.api.DataStore;
import org.shoal.ha.cache.api.DataStoreConfigurator;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.api.DataStoreFactory;
import org.shoal.ha.cache.api.DefaultObjectInputOutputStreamFactory;
import org.shoal.ha.cache.api.ObjectInputOutputStreamFactory;

public class InMemoryBackingStore<K extends Serializable, V extends Serializable>
extends BackingStore<K, V> {
    DataStore<K, V> dataStore;

    protected void initialize(BackingStoreConfiguration<K, V> conf) throws BackingStoreException {
        ClassLoader cl;
        super.initialize(conf);
        DataStoreConfigurator dsConf = new DataStoreConfigurator();
        dsConf.setInstanceName(conf.getInstanceName()).setGroupName(conf.getClusterName()).setStoreName(conf.getStoreName()).setKeyClazz(conf.getKeyClazz()).setValueClazz(conf.getValueClazz());
        Map vendorSpecificMap = conf.getVendorSpecificSettings();
        Object stGMS = vendorSpecificMap.get("start.gms");
        boolean startGMS = false;
        if (stGMS != null) {
            if (stGMS instanceof String) {
                try {
                    startGMS = Boolean.valueOf((String)stGMS);
                }
                catch (Throwable th) {}
            } else if (stGMS instanceof Boolean) {
                startGMS = (Boolean)stGMS;
            }
        }
        Object cacheLocally = vendorSpecificMap.get("local.caching");
        boolean enableLocalCaching = false;
        if (cacheLocally != null) {
            if (cacheLocally instanceof String) {
                try {
                    enableLocalCaching = Boolean.valueOf((String)cacheLocally);
                }
                catch (Throwable th) {}
            } else if (cacheLocally instanceof Boolean) {
                enableLocalCaching = (Boolean)stGMS;
            }
        }
        if ((cl = (ClassLoader)vendorSpecificMap.get("class.loader")) == null) {
            cl = conf.getValueClazz().getClassLoader();
        }
        dsConf.setClassLoader(cl).setStartGMS(startGMS).setCacheLocally(enableLocalCaching);
        dsConf.setObjectInputOutputStreamFactory((ObjectInputOutputStreamFactory)new DefaultObjectInputOutputStreamFactory());
        this.dataStore = DataStoreFactory.createDataStore((DataStoreConfigurator)dsConf);
    }

    public V load(K key, String version) throws BackingStoreException {
        try {
            return (V)((Serializable)this.dataStore.get(key));
        }
        catch (DataStoreException dsEx) {
            throw new BackingStoreException("Error during load: " + key, (Throwable)dsEx);
        }
    }

    public String save(K key, V value, boolean isNew) throws BackingStoreException {
        try {
            return this.dataStore.put(key, value);
        }
        catch (DataStoreException dsEx) {
            throw new BackingStoreException("Error during save: " + key, (Throwable)dsEx);
        }
    }

    public void remove(K key) throws BackingStoreException {
        try {
            this.dataStore.remove(key);
        }
        catch (DataStoreException dsEx) {
            throw new BackingStoreException("Error during remove: " + key, (Throwable)dsEx);
        }
    }

    public int removeExpired(long idleTime) throws BackingStoreException {
        return this.dataStore.removeIdleEntries(idleTime);
    }

    public int size() throws BackingStoreException {
        return 0;
    }

    public void destroy() throws BackingStoreException {
        this.dataStore.close();
    }

    public void updateTimestamp(K key, long time) throws BackingStoreException {
        try {
            this.dataStore.touch(key, 0x7FFFFFFFFFFFFFFEL, time, 1800000L);
        }
        catch (DataStoreException dsEx) {
            throw new BackingStoreException("Error during load: " + key, (Throwable)dsEx);
        }
    }
}

