/*
 * Decompiled with CFR 0.152.
 */
package org.silpa.ngram;

import java.util.ArrayList;
import java.util.List;
import org.silpa.syllabifier.Syllabifier;

public class Ngram {
    public static final int NGRAM_TYPE_WORD = 0;
    public static final int NGRAM_TYPE_SYLLABLE = 1;
    public static final int NGRAM_TYPE_LETTER = 2;
    public static final int DEFAULT_NGRAMS_WINDOW_SIZE = 2;
    private Syllabifier syllabifier = new Syllabifier();
    private static final String MODULE_NAME = "Ngram Library";
    private static final String MODULE_INFORMATION = "Ngram Library for English and Indian languages";

    public List<String> syllableNgram(String text) {
        return this.syllableNgram(text, 2);
    }

    public List<String> syllableNgram(String text, int windowSize) {
        String[] words = text.split(" ");
        ArrayList<String> ngrams = new ArrayList<String>();
        for (String word : words) {
            List syllables = this.syllabifier.getSyllables(word);
            int syllableCount = syllables.size();
            int windowStart = 0;
            int windowEnd = 0;
            while (windowStart + windowSize <= syllableCount) {
                windowEnd = windowStart + windowSize < syllableCount ? windowStart + windowSize : syllableCount;
                String str = "";
                for (int i = windowStart; i < windowEnd; ++i) {
                    str = str + (String)syllables.get(i);
                }
                ngrams.add(str);
                ++windowStart;
            }
        }
        return ngrams;
    }

    public List<String> letterNgram(String word) {
        return this.letterNgram(word, 2);
    }

    public List<String> letterNgram(String word, int windowSize) {
        word = word.trim();
        ArrayList<String> ngrams = new ArrayList<String>();
        int letterCount = word.length();
        int windowStart = 0;
        int windowEnd = 0;
        while (windowStart + windowSize <= letterCount) {
            windowEnd = windowStart + windowSize < letterCount ? windowStart + windowSize : letterCount;
            ngrams.add(word.substring(windowStart, windowEnd));
            ++windowStart;
        }
        return ngrams;
    }

    public List<String> wordNgram(String text) {
        return this.wordNgram(text, 2);
    }

    public List<String> wordNgram(String text, int windowSize) {
        String[] words = text.split(" ");
        ArrayList<String> ngrams = new ArrayList<String>();
        int wordCount = words.length;
        int windowStart = 0;
        int windowEnd = 0;
        while (windowStart + windowSize <= wordCount) {
            windowEnd = windowStart + windowSize < wordCount ? windowStart + windowSize : wordCount;
            String str = "";
            for (int i = windowStart; i < windowEnd; ++i) {
                str = str + words[i] + " ";
            }
            ngrams.add(str.trim());
            ++windowStart;
        }
        return ngrams;
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleInformation() {
        return MODULE_INFORMATION;
    }
}

