/*
 * Decompiled with CFR 0.152.
 */
package org.silpa.ngram;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import java.util.List;
import org.silpa.ngram.Ngram;
import org.silpa.ngram.NgramInterface;
import org.silpa.ngram.R;
import org.silpa.render.IndicTextView;

public class NgramTextView
extends IndicTextView
implements NgramInterface {
    private Ngram ngram;
    private int mNgramType;
    private int mNgramNValue;
    private static final int DEFAULT_NGRAM_TYPE = 0;
    private static final String LOG_TAG = "Ngram edit text";

    public NgramTextView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public NgramTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public NgramTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        this.ngram = new Ngram();
        this.initAttrs(attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttrs(AttributeSet attrs, int defStyle) {
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.NgramTextView, defStyle, defStyle);
        try {
            this.mNgramNValue = a.getInteger(0, -1);
            this.mNgramType = a.getInteger(1, 0);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("Error : " + e.getMessage()));
        }
        finally {
            a.recycle();
        }
    }

    @Override
    public List<String> getNgram() {
        String str = this.getText().toString();
        if (this.mNgramNValue != -1) {
            switch (this.mNgramType) {
                case 0: {
                    return this.ngram.wordNgram(str, this.mNgramNValue);
                }
                case 1: {
                    return this.ngram.syllableNgram(str, this.mNgramNValue);
                }
                case 2: {
                    return this.ngram.letterNgram(str, this.mNgramNValue);
                }
            }
            return null;
        }
        switch (this.mNgramType) {
            case 0: {
                return this.ngram.wordNgram(str);
            }
            case 1: {
                return this.ngram.syllableNgram(str);
            }
            case 2: {
                return this.ngram.letterNgram(str);
            }
        }
        return null;
    }

    @Override
    public void setNgramType(int ngramType) {
        this.mNgramType = ngramType;
    }

    @Override
    public int getNgramType() {
        return this.mNgramType;
    }

    @Override
    public void setNgramNValue(int nValue) {
        this.mNgramNValue = nValue;
    }

    @Override
    public int getNgramNValue() {
        return this.mNgramNValue;
    }

    @Override
    public String getModuleName() {
        return this.ngram.getModuleName();
    }

    @Override
    public String getModuleInformation() {
        return this.ngram.getModuleInformation();
    }
}

