/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.simpleflatmapper.util.TypeHelper;

public class JdbcTypeHelper {
    private static final Map<String, Class<?>> javaTypeToSqlType = new HashMap();

    public static Class<?> toJavaType(int sqlType, Type propertyType) {
        switch (sqlType) {
            case 2003: {
                return Array.class;
            }
            case -16: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case -7: {
                return Boolean.TYPE;
            }
            case -6: {
                return Byte.TYPE;
            }
            case 5: {
                return Short.TYPE;
            }
            case 4: {
                return Integer.TYPE;
            }
            case -5: {
                return Long.TYPE;
            }
            case 7: {
                return Float.TYPE;
            }
            case 6: 
            case 8: {
                return Double.TYPE;
            }
            case -4: 
            case -3: 
            case -2: {
                return byte[].class;
            }
            case 91: {
                return Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 2005: {
                return Clob.class;
            }
            case 2004: {
                return Blob.class;
            }
            case 2002: {
                return Struct.class;
            }
            case 2006: {
                return Ref.class;
            }
        }
        Class<?> defaultSqlType = javaTypeToSqlType.get(TypeHelper.toClass((Type)propertyType).getName());
        if (defaultSqlType != null) {
            return defaultSqlType;
        }
        return Object.class;
    }

    static {
        javaTypeToSqlType.put("java.lang.Number", BigDecimal.class);
        javaTypeToSqlType.put("java.util.Date", Timestamp.class);
        javaTypeToSqlType.put("java.util.Calendar", Timestamp.class);
        javaTypeToSqlType.put("java.sql.Timestamp", Timestamp.class);
        javaTypeToSqlType.put("java.time.Instant", Timestamp.class);
        javaTypeToSqlType.put("java.time.LocalDateTime", Timestamp.class);
        javaTypeToSqlType.put("java.time.ZonedDateTime", Timestamp.class);
        javaTypeToSqlType.put("java.time.OffsetDateTime", Timestamp.class);
        javaTypeToSqlType.put("java.time.LocalTime", Time.class);
        javaTypeToSqlType.put("java.time.OffsetTime", Time.class);
        javaTypeToSqlType.put("java.sql.Time", Time.class);
        javaTypeToSqlType.put("java.time.LocalDate", Date.class);
        javaTypeToSqlType.put("java.time.YearMonth", Date.class);
        javaTypeToSqlType.put("java.time.Year", Date.class);
        javaTypeToSqlType.put("java.sql.Date", Date.class);
        javaTypeToSqlType.put("org.joda.time.Instant", Timestamp.class);
        javaTypeToSqlType.put("org.joda.time.LocalDateTime", Timestamp.class);
        javaTypeToSqlType.put("org.joda.time.DateTime", Timestamp.class);
        javaTypeToSqlType.put("org.joda.time.LocalTime", Time.class);
        javaTypeToSqlType.put("org.joda.time.LocalDate", Date.class);
    }
}

