/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbi;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.QueryPreparer;
import org.simpleflatmapper.jdbc.SqlTypeColumnProperty;
import org.simpleflatmapper.jdbc.named.NamedSqlQuery;
import org.simpleflatmapper.jdbi.SfmBind;
import org.simpleflatmapper.jdbi.SqlType;
import org.simpleflatmapper.util.ErrorHelper;
import org.skife.jdbi.v2.Binding;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.sqlobject.Binder;
import org.skife.jdbi.v2.sqlobject.BinderFactory;
import org.skife.jdbi.v2.tweak.RewrittenStatement;
import org.skife.jdbi.v2.tweak.StatementRewriter;

public class SfmBinderFactory
implements BinderFactory<SfmBind> {
    public Binder build(SfmBind annotation) {
        return new SfmBinder();
    }

    private static class SfmStatementRewriter<T>
    implements StatementRewriter {
        private final QueryPreparer<T> queryPreparer;
        private final T o;

        public SfmStatementRewriter(QueryPreparer<T> queryPreparer, T o) {
            this.queryPreparer = queryPreparer;
            this.o = o;
        }

        public RewrittenStatement rewrite(String s, Binding binding, StatementContext statementContext) {
            String sql = this.queryPreparer.toRewrittenSqlQuery(this.o);
            return new SfmRewrittenStatement(sql);
        }

        private class SfmRewrittenStatement
        implements RewrittenStatement {
            private final String sql;

            public SfmRewrittenStatement(String sql) {
                this.sql = sql;
            }

            public void bind(Binding binding, PreparedStatement preparedStatement) throws SQLException {
                try {
                    SfmStatementRewriter.this.queryPreparer.mapper().mapTo(SfmStatementRewriter.this.o, (Object)preparedStatement, null);
                }
                catch (Exception e) {
                    ErrorHelper.rethrow((Throwable)e);
                }
            }

            public String getSql() {
                return this.sql;
            }
        }
    }

    private static class QueryPreparerKey {
        private final String sql;
        private final Class<?> target;

        private QueryPreparerKey(String sql, Class<?> target) {
            this.sql = sql;
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryPreparerKey that = (QueryPreparerKey)o;
            if (!this.sql.equals(that.sql)) {
                return false;
            }
            return this.target.equals(that.target);
        }

        public int hashCode() {
            int result = this.sql.hashCode();
            result = 31 * result + this.target.hashCode();
            return result;
        }
    }

    private static class SfmBinder<T>
    implements Binder<SfmBind, T> {
        private final ConcurrentMap<QueryPreparerKey, QueryPreparer<T>> cache = new ConcurrentHashMap<QueryPreparerKey, QueryPreparer<T>>();

        private SfmBinder() {
        }

        public void bind(SQLStatement<?> sqlStatement, SfmBind annotation, T o) {
            QueryPreparer<T> queryPreparer = this.getQueryPreparer(sqlStatement, annotation, o.getClass());
            sqlStatement.setStatementRewriter(new SfmStatementRewriter<T>(queryPreparer, o));
        }

        private QueryPreparer<T> getQueryPreparer(SQLStatement<?> sqlStatement, SfmBind annotation, Class<?> aClass) {
            QueryPreparerKey key = new QueryPreparerKey(sqlStatement.getContext().getRawSql(), aClass);
            QueryPreparer queryPreparer = (QueryPreparer)this.cache.get(key);
            if (queryPreparer == null) {
                NamedSqlQuery parse = NamedSqlQuery.parse((CharSequence)sqlStatement.getContext().getRawSql());
                JdbcMapperFactory jdbcMapperFactory = JdbcMapperFactory.newInstance();
                for (SqlType col : annotation.sqlTypes()) {
                    jdbcMapperFactory.addColumnProperty(col.name(), new Object[]{SqlTypeColumnProperty.of((int)col.type())});
                }
                queryPreparer = jdbcMapperFactory.from(aClass).to(parse);
                QueryPreparer cachedQP = this.cache.putIfAbsent(key, queryPreparer);
                if (cachedQP != null) {
                    queryPreparer = cachedQP;
                }
            }
            return queryPreparer;
        }
    }
}

