/*
 * EmptyConsumer.java February 2007
 *
 * Copyright (C) 2001, Niall Gallagher <niallg@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General 
 * Public License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA  02111-1307  USA
 */

package org.simpleframework.http.core;

/**
 * The <code>EmptyConsumer</code> object is used to represent a body
 * of zero length. This is the most common body consumer created as 
 * it represents the body for GET messages that have nothing within
 * the body part.
 *
 * @author Niall Gallagher
 */ 
class EmptyConsumer extends BodyConsumer {

   /**
    * This method will not consume any bytes from the cursor. This 
    * ensures that the next byte read from the stream is the first
    * character of the next HTTP message within the pipeline.
    *
    * @param cursor this is the cursor which will not be read from
    */         
   public void consume(Cursor cursor) {
      return;
   }
 
   /**
    * This will return true immediately. Because the empty consumer
    * represents a zero length body and no bytes are read from the
    * cursor, this should not be processed and return finished.  
    *
    * @return this will always return true for the zero length body
    */
   public boolean isFinished() {
      return true;
   }
}


